/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.hap.provider;

import com.ohos.hapsigntool.entity.Options;
import com.ohos.hapsigntool.error.InvalidParamsException;
import com.ohos.hapsigntool.error.SignToolErrMsg;
import com.ohos.hapsigntool.hap.provider.SignProvider;
import com.ohos.hapsigntool.utils.FileUtils;
import com.ohos.hapsigntool.utils.LogUtils;
import com.ohos.hapsigntool.utils.ParamProcessUtil;
import com.ohos.hapsigntool.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CRL;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.util.Optional;
import java.util.Set;

public class LocalJKSSignProvider
extends SignProvider {
    private static final LogUtils LOGGER = new LogUtils(LocalJKSSignProvider.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<X509CRL> getCrl() {
        X509CRL crl = null;
        String crlPath = (String)this.signParams.get("crl");
        if (StringUtils.isEmpty(crlPath)) {
            return Optional.ofNullable(crl);
        }
        try (FileInputStream input = new FileInputStream(crlPath);){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            CRL baseCrl = cf.generateCRL(input);
            if (!(baseCrl instanceof X509CRL)) {
                LOGGER.error("crl is not X509CRL");
                Optional<X509CRL> optional = Optional.ofNullable(crl);
                return optional;
            }
            crl = (X509CRL)baseCrl;
            return Optional.ofNullable(crl);
        }
        catch (IOException e) {
            LOGGER.error("read CRL File has IOException!");
            crl = null;
            return Optional.ofNullable(crl);
        }
        catch (GeneralSecurityException e) {
            LOGGER.error("Generate x509 CRL failed!");
            crl = null;
        }
        return Optional.ofNullable(crl);
    }

    private void checkPublicKeyPath() throws InvalidParamsException {
        String publicCertsFile = (String)this.signParams.get("appCertFile");
        File publicKeyFile = new File(publicCertsFile);
        try {
            FileUtils.isValidFile(publicKeyFile);
        }
        catch (IOException e) {
            LOGGER.error("file is invalid: " + publicCertsFile + System.lineSeparator(), e);
            throw new InvalidParamsException(SignToolErrMsg.PARAM_CHECK_FAILED.toString("appCertFile", "Invalid file: " + publicCertsFile));
        }
    }

    @Override
    public void checkParams(Options options) throws InvalidParamsException {
        super.checkParams(options);
        String[] paramFileds = new String[]{"keystoreFile", "keystorePwd", "keyPwd"};
        Set<String> paramSet = ParamProcessUtil.initParamField(paramFileds);
        for (String paramKey : options.keySet()) {
            if (!paramSet.contains(paramKey)) continue;
            if (paramKey.endsWith("Pwd")) {
                this.signParams.put(paramKey, new String(options.getChars(paramKey)));
                continue;
            }
            this.signParams.put(paramKey, options.getString(paramKey));
        }
        this.checkSignCode();
        this.checkPublicKeyPath();
    }
}

