/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.entity;

import com.ohos.hapsigntool.entity.ContentDigestAlgorithm;
import com.ohos.hapsigntool.entity.Pair;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;

public enum SignatureAlgorithm {
    RSA_PSS_WITH_SHA256(257, "RSA", ContentDigestAlgorithm.SHA256, Pair.create("SHA256withRSAANDMGF1", new PSSParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, 32, 1))),
    RSA_PSS_WITH_SHA384(258, "RSA", ContentDigestAlgorithm.SHA384, Pair.create("SHA384withRSAANDMGF1", new PSSParameterSpec("SHA-384", "MGF1", MGF1ParameterSpec.SHA384, 48, 1))),
    RSA_PSS_WITH_SHA512(259, "RSA", ContentDigestAlgorithm.SHA512, Pair.create("SHA512withRSAANDMGF1", new PSSParameterSpec("SHA-512", "MGF1", MGF1ParameterSpec.SHA512, 64, 1))),
    RSA_PKCS1_V1_5_WITH_SHA256(260, "RSA", ContentDigestAlgorithm.SHA256, Pair.create("SHA256withRSA", null)),
    RSA_PKCS1_V1_5_WITH_SHA384(261, "RSA", ContentDigestAlgorithm.SHA256, Pair.create("SHA384withRSA", null)),
    RSA_PKCS1_V1_5_WITH_SHA512(262, "RSA", ContentDigestAlgorithm.SHA512, Pair.create("SHA512withRSA", null)),
    ECDSA_WITH_SHA256(513, "EC", ContentDigestAlgorithm.SHA256, Pair.create("SHA256withECDSA", null)),
    ECDSA_WITH_SHA384(514, "EC", ContentDigestAlgorithm.SHA384, Pair.create("SHA384withECDSA", null)),
    ECDSA_WITH_SHA512(515, "EC", ContentDigestAlgorithm.SHA512, Pair.create("SHA512withECDSA", null)),
    DSA_WITH_SHA256(769, "DSA", ContentDigestAlgorithm.SHA256, Pair.create("SHA256withDSA", null)),
    DSA_WITH_SHA384(770, "DSA", ContentDigestAlgorithm.SHA384, Pair.create("SHA384withDSA", null)),
    DSA_WITH_SHA512(771, "DSA", ContentDigestAlgorithm.SHA512, Pair.create("SHA512withDSA", null));

    private int id;
    private String keyAlgorithm;
    private ContentDigestAlgorithm contentDigestAlgorithm;
    private Pair<String, ? extends AlgorithmParameterSpec> signatureAlgAndParams;

    private SignatureAlgorithm(int id, String keyAlgorithm, ContentDigestAlgorithm contentDigestAlgorithm, Pair<String, ? extends AlgorithmParameterSpec> signatureAlgAndParams) {
        this.id = id;
        this.keyAlgorithm = keyAlgorithm;
        this.contentDigestAlgorithm = contentDigestAlgorithm;
        this.signatureAlgAndParams = signatureAlgAndParams;
    }

    public int getId() {
        return this.id;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public ContentDigestAlgorithm getContentDigestAlgorithm() {
        return this.contentDigestAlgorithm;
    }

    public Pair<String, ? extends AlgorithmParameterSpec> getSignatureAlgAndParams() {
        return this.signatureAlgAndParams;
    }

    public static SignatureAlgorithm findById(int id) {
        SignatureAlgorithm ret = null;
        for (SignatureAlgorithm alg : SignatureAlgorithm.values()) {
            if (id != alg.getId()) continue;
            return alg;
        }
        return ret;
    }
}

