/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.codesigning.sign;

import com.ohos.hapsigntool.codesigning.elf.ElfFile;
import com.ohos.hapsigntool.codesigning.elf.ElfProgramHeader;
import com.ohos.hapsigntool.codesigning.exception.CodeSignErrMsg;
import com.ohos.hapsigntool.codesigning.exception.ElfFormatException;
import com.ohos.hapsigntool.codesigning.utils.NumberUtils;
import com.ohos.hapsigntool.error.HapFormatException;
import com.ohos.hapsigntool.utils.LogUtils;
import com.ohos.hapsigntool.zip.EntryType;
import com.ohos.hapsigntool.zip.Zip;
import com.ohos.hapsigntool.zip.ZipEntry;
import com.ohos.hapsigntool.zip.ZipEntryHeader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PageInfoGenerator {
    private static final byte ABC_M_CODE = 2;
    private static final byte ELF_M_CODE = 1;
    private static final LogUtils LOGGER = new LogUtils(PageInfoGenerator.class);
    private long maxEntryDataOffset = 0L;
    private final List<ExcSegment> excSegmentList = new ArrayList<ExcSegment>();

    public PageInfoGenerator(Zip zip) throws IOException, HapFormatException, ElfFormatException {
        LinkedHashMap<String, Long> runnableFileNames = new LinkedHashMap<String, Long>();
        List<ZipEntry> zipEntries = zip.getZipEntries();
        for (ZipEntry entry : zipEntries) {
            ZipEntryHeader zipEntryHeader = entry.getZipEntryData().getZipEntryHeader();
            long entryDataOffset = entry.getCentralDirectory().getOffset() + 30L + (long)zipEntryHeader.getFileNameLength() + (long)zipEntryHeader.getExtraLength();
            if (!NumberUtils.isMultiple4K(entryDataOffset)) {
                throw new HapFormatException(CodeSignErrMsg.FILE_4K_ALIGNMENT_ERROR.toString(entryDataOffset));
            }
            if (EntryType.RUNNABLE_FILE.equals((Object)entry.getZipEntryData().getType()) && 0 == entry.getZipEntryData().getZipEntryHeader().getMethod()) {
                runnableFileNames.put(zipEntryHeader.getFileName(), entryDataOffset);
                continue;
            }
            this.maxEntryDataOffset = entryDataOffset;
            break;
        }
        File input = new File(zip.getFile());
        try (JarFile hap = new JarFile(input, false);){
            for (Map.Entry en : runnableFileNames.entrySet()) {
                this.libExecSegment(hap, (String)en.getKey(), (Long)en.getValue());
            }
        }
    }

    private void libExecSegment(JarFile hap, String libFileName, long entryDataOffset) throws IOException, ElfFormatException {
        JarEntry libEntry = hap.getJarEntry(libFileName);
        if (libFileName.endsWith(".abc")) {
            long size = libEntry.getSize();
            this.excSegmentList.add(new ExcSegment(2, libFileName, entryDataOffset, entryDataOffset + size));
        } else {
            try (InputStream stream = hap.getInputStream(libEntry);){
                ElfFile elfFile = new ElfFile(stream);
                if (!elfFile.isElfFile()) {
                    LOGGER.info("{} not ELF file", libFileName);
                    return;
                }
                List<ElfProgramHeader> elfPHeaders = elfFile.filterExecPHeaders();
                for (ElfProgramHeader programHeader : elfPHeaders) {
                    long pOffset = programHeader.getPOffset();
                    long pFilesz = programHeader.getPFilesz();
                    long off = entryDataOffset + pOffset;
                    long endoff = off + pFilesz;
                    this.excSegmentList.add(new ExcSegment(1, libFileName, off, endoff));
                }
            }
        }
    }

    public byte[] generateBitMap() throws HapFormatException {
        if (this.excSegmentList.isEmpty()) {
            return new byte[0];
        }
        if (!NumberUtils.isMultiple4K(this.maxEntryDataOffset)) {
            throw new HapFormatException(CodeSignErrMsg.FILE_4K_ALIGNMENT_ERROR.toString(this.maxEntryDataOffset));
        }
        int len = (int)(this.maxEntryDataOffset / 4096L * 4L);
        BitSet bitmap = new BitSet(len);
        for (ExcSegment es : this.excSegmentList) {
            int begin = (int)(es.getStartOffset() >> 12) * 4;
            int end = NumberUtils.isMultiple4K(es.getEndOffset()) ? (int)(es.getEndOffset() >> 12) * 4 : (int)((es.getEndOffset() >> 12) + 1L) * 4;
            for (int i = begin; i < end; i += 4) {
                if (1 == es.getType()) {
                    bitmap.set(i);
                    continue;
                }
                bitmap.set(i + 1);
            }
        }
        long[] longArray = bitmap.toLongArray();
        int byteLen = bitmap.size() / 8;
        ByteBuffer buffer = ByteBuffer.allocate(byteLen).order(ByteOrder.LITTLE_ENDIAN);
        for (long l : longArray) {
            buffer.putLong(l);
        }
        return buffer.array();
    }

    static class ExcSegment {
        private byte type;
        private String fileName;
        private long startOffset;
        private long endOffset;

        ExcSegment(byte type, String fileName, long startOffset, long endOffset) {
            this.type = type;
            this.fileName = fileName;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public byte getType() {
            return this.type;
        }

        public String getFileName() {
            return this.fileName;
        }

        public long getStartOffset() {
            return this.startOffset;
        }

        public long getEndOffset() {
            return this.endOffset;
        }
    }
}

