/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.codesigning.fsverity;

import com.ohos.hapsigntool.codesigning.datastructure.PageInfoExtension;
import com.ohos.hapsigntool.codesigning.exception.CodeSignErrMsg;
import com.ohos.hapsigntool.codesigning.exception.FsVerityDigestException;
import com.ohos.hapsigntool.codesigning.exception.PageInfoException;
import com.ohos.hapsigntool.codesigning.fsverity.FsVerityDescriptor;
import com.ohos.hapsigntool.codesigning.fsverity.FsVerityDigest;
import com.ohos.hapsigntool.codesigning.fsverity.FsVerityHashAlgorithm;
import com.ohos.hapsigntool.codesigning.fsverity.MerkleTree;
import com.ohos.hapsigntool.codesigning.fsverity.MerkleTreeBuilder;
import com.ohos.hapsigntool.codesigning.utils.DigestUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;

public class FsVerityGenerator {
    private static final FsVerityHashAlgorithm FS_VERITY_HASH_ALGORITHM = FsVerityHashAlgorithm.SHA256;
    private static final byte LOG_2_OF_FSVERITY_HASH_PAGE_SIZE = 12;
    protected byte[] salt = null;
    private byte[] fsVerityDigest = null;
    private byte[] fsVerityDigestV2 = null;
    private byte[] treeBytes = null;
    private byte[] rootHash = null;
    private PageInfoExtension pageInfoExtension;

    public void setPageInfoExtension(PageInfoExtension pg) {
        this.pageInfoExtension = pg;
    }

    public MerkleTree generateMerkleTree(InputStream inputStream, long size, FsVerityHashAlgorithm fsVerityHashAlgorithm) throws FsVerityDigestException {
        MerkleTree merkleTree;
        try (MerkleTreeBuilder builder = new MerkleTreeBuilder();){
            merkleTree = builder.generateMerkleTree(inputStream, size, fsVerityHashAlgorithm);
        }
        catch (IOException e) {
            throw new FsVerityDigestException(e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new FsVerityDigestException(CodeSignErrMsg.ALGORITHM_NOT_SUPPORT_ERROR.toString(fsVerityHashAlgorithm.getHashAlgorithm()), e);
        }
        return merkleTree;
    }

    public void generateFsVerityDigest(InputStream inputStream, long size, long fsvTreeOffset) throws FsVerityDigestException, PageInfoException {
        byte[] digest;
        MerkleTree merkleTree = size == 0L ? new MerkleTree(null, null, FS_VERITY_HASH_ALGORITHM) : this.generateMerkleTree(inputStream, size, FS_VERITY_HASH_ALGORITHM);
        int flags = fsvTreeOffset == 0L ? 0 : 1;
        FsVerityDescriptor.Builder builder = new FsVerityDescriptor.Builder().setFileSize(size).setHashAlgorithm(FS_VERITY_HASH_ALGORITHM.getId()).setLog2BlockSize((byte)12).setSaltSize((byte)this.getSaltSize()).setSalt(this.salt).setRawRootHash(merkleTree.rootHash).setFlags(flags).setMerkleTreeOffset(fsvTreeOffset);
        try {
            byte[] fsVerityDescriptor = builder.build().getDiscByte();
            digest = DigestUtils.computeDigest(fsVerityDescriptor, FS_VERITY_HASH_ALGORITHM.getHashAlgorithm());
            this.fsVerityDigest = FsVerityDigest.getFsVerityDigest(FS_VERITY_HASH_ALGORITHM.getId(), digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new FsVerityDigestException(CodeSignErrMsg.ALGORITHM_NOT_SUPPORT_ERROR.toString(FS_VERITY_HASH_ALGORITHM.getHashAlgorithm()), e);
        }
        if (this.pageInfoExtension != null && flags != 0) {
            PageInfoExtension.valid(this.pageInfoExtension, size);
            try {
                byte[] fsVerityDescriptorV2 = builder.build().getDiscByteCsv2(this.pageInfoExtension.getMapOffset(), this.pageInfoExtension.getMapSize(), this.pageInfoExtension.getUnitSize());
                digest = DigestUtils.computeDigest(fsVerityDescriptorV2, FS_VERITY_HASH_ALGORITHM.getHashAlgorithm());
                this.fsVerityDigestV2 = FsVerityDigest.getFsVerityDigest(FS_VERITY_HASH_ALGORITHM.getId(), digest);
            }
            catch (NoSuchAlgorithmException e) {
                throw new FsVerityDigestException(CodeSignErrMsg.ALGORITHM_NOT_SUPPORT_ERROR.toString(FS_VERITY_HASH_ALGORITHM.getHashAlgorithm()), e);
            }
        }
        this.treeBytes = merkleTree.tree;
        this.rootHash = merkleTree.rootHash;
    }

    public byte[] getFsVerityDigest() {
        return this.fsVerityDigest;
    }

    public byte[] getFsVerityDigestV2() {
        return this.fsVerityDigestV2;
    }

    public byte[] getTreeBytes() {
        return this.treeBytes;
    }

    public byte[] getRootHash() {
        return this.rootHash;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public int getSaltSize() {
        return this.salt == null ? 0 : this.salt.length;
    }

    public static byte getFsVerityHashAlgorithm() {
        return FS_VERITY_HASH_ALGORITHM.getId();
    }

    public static byte getLog2BlockSize() {
        return 12;
    }
}

