/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.codesigning.elf;

import com.ohos.hapsigntool.codesigning.exception.CodeSignErrMsg;
import com.ohos.hapsigntool.codesigning.exception.ElfFormatException;
import com.ohos.hapsigntool.zip.UnsignedDecimalUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ElfHeader {
    private byte[] ident = new byte[16];
    private boolean isElfFile;
    private byte eiClass;
    private byte eiData;
    private byte eiVersion;
    private short eType;
    private int eMachine;
    private int eVersion;
    private long eEntry;
    private long ePhOff;
    private long eShOff;
    private int eFlags;
    private short eEhSize;
    private short ePhEntSize;
    private int ePhNum;
    private short eShEntSize;
    private short eShNum;
    private short eShStrndx;

    public ElfHeader(InputStream is) throws IOException, ElfFormatException {
        ByteOrder bo;
        int len;
        int read = is.read(this.ident);
        this.isElfFile = ElfHeader.isElfFile(this.ident);
        if (read != this.ident.length || !this.isElfFile) {
            return;
        }
        this.eiClass = this.ident[4];
        this.eiData = this.ident[5];
        this.eiVersion = this.ident[6];
        if (this.eiClass == 1) {
            len = 36;
        } else if (this.eiClass == 2) {
            len = 48;
        } else {
            throw new ElfFormatException(CodeSignErrMsg.ELF_FILE_HEADER_ERROR.toString("ei_class"));
        }
        if (this.eiData == 1) {
            bo = ByteOrder.LITTLE_ENDIAN;
        } else if (this.eiData == 2) {
            bo = ByteOrder.BIG_ENDIAN;
        } else {
            throw new ElfFormatException(CodeSignErrMsg.ELF_FILE_HEADER_ERROR.toString("ei_data"));
        }
        byte[] bytes = new byte[len];
        read = is.read(bytes);
        if (read != len) {
            throw new ElfFormatException(CodeSignErrMsg.ELF_FILE_HEADER_ERROR.toString("header"));
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.order(bo);
        this.initHeader(byteBuffer);
    }

    private void initHeader(ByteBuffer byteBuffer) {
        this.eType = byteBuffer.getShort();
        this.eMachine = byteBuffer.getShort();
        this.eVersion = byteBuffer.getInt();
        if (this.eiClass == 1) {
            this.eEntry = UnsignedDecimalUtil.getUnsignedInt(byteBuffer);
            this.ePhOff = UnsignedDecimalUtil.getUnsignedInt(byteBuffer);
            this.eShOff = UnsignedDecimalUtil.getUnsignedInt(byteBuffer);
        } else {
            this.eEntry = byteBuffer.getLong();
            this.ePhOff = byteBuffer.getLong();
            this.eShOff = byteBuffer.getLong();
        }
        this.eFlags = byteBuffer.getInt();
        this.eEhSize = byteBuffer.getShort();
        this.ePhEntSize = byteBuffer.getShort();
        this.ePhNum = UnsignedDecimalUtil.getUnsignedShort(byteBuffer);
        this.eShEntSize = byteBuffer.getShort();
        this.eShNum = byteBuffer.getShort();
        this.eShStrndx = byteBuffer.getShort();
    }

    public byte getEiClass() {
        return this.eiClass;
    }

    public byte getEiData() {
        return this.eiData;
    }

    public long getEPhOff() {
        return this.ePhOff;
    }

    public int getEPhnum() {
        return this.ePhNum;
    }

    public static boolean isElfFile(byte[] bytes) {
        if (bytes == null || bytes.length < 4) {
            return false;
        }
        return bytes[0] == 127 && bytes[1] == 69 && bytes[2] == 76 && bytes[3] == 70;
    }

    public boolean isElfFile() {
        return this.isElfFile;
    }
}

