/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.codesigning.elf;

import com.ohos.hapsigntool.codesigning.elf.ElfHeader;
import com.ohos.hapsigntool.codesigning.elf.ElfProgramHeader;
import com.ohos.hapsigntool.codesigning.exception.ElfFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ElfFile {
    private ElfHeader elfHeader;
    private final List<ElfProgramHeader> programHeaderList = new ArrayList<ElfProgramHeader>();

    public ElfFile(InputStream is) throws IOException, ElfFormatException {
        this.elfHeader = new ElfHeader(is);
        if (!this.isElfFile()) {
            return;
        }
        byte eiClass = this.elfHeader.getEiClass();
        byte eiData = this.elfHeader.getEiData();
        int ePhnum = this.elfHeader.getEPhnum();
        long ePhOff = this.elfHeader.getEPhOff();
        if (eiClass == 1) {
            is.skip(ePhOff - 52L);
        } else if (eiClass == 2) {
            is.skip(ePhOff - 64L);
        }
        for (int i = 0; i < ePhnum; ++i) {
            ElfProgramHeader pHeader = new ElfProgramHeader(is, eiClass, eiData);
            this.programHeaderList.add(pHeader);
        }
    }

    public List<ElfProgramHeader> filterExecPHeaders() {
        return this.programHeaderList.stream().filter(phdr -> (phdr.getPFlags() & 1) == 1).collect(Collectors.toList());
    }

    public final boolean isElfFile() {
        return this.elfHeader.isElfFile();
    }
}

