/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.codesigning.datastructure;

import com.ohos.hapsigntool.codesigning.datastructure.Extension;
import com.ohos.hapsigntool.codesigning.datastructure.MerkleTreeExtension;
import com.ohos.hapsigntool.codesigning.datastructure.PageInfoExtension;
import com.ohos.hapsigntool.codesigning.exception.PageInfoException;
import com.ohos.hapsigntool.codesigning.exception.VerifyCodeSignException;
import com.ohos.hapsigntool.utils.LogUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class SignInfo {
    public static final int FLAG_MERKLE_TREE_INCLUDED = 1;
    public static final int MAX_EXTENSION_NUM = 2;
    private static final LogUtils LOGGER = new LogUtils(SignInfo.class);
    private static final int SIGN_INFO_SIZE_WITHOUT_SIGNATURE = 60;
    private static final int SALT_BUFFER_LENGTH = 32;
    private static final int SIGNATURE_ALIGNMENT = 4;
    private int saltSize;
    private int sigSize;
    private int flags;
    private long dataSize;
    private byte[] salt;
    private int extensionNum;
    private int extensionOffset;
    private byte[] signature;
    private byte[] zeroPadding;
    private List<Extension> extensionList = new ArrayList<Extension>();

    public SignInfo(int saltSize, int flags, long dataSize, byte[] salt, byte[] sig) {
        this.saltSize = saltSize;
        this.flags = flags;
        this.dataSize = dataSize;
        this.salt = salt == null ? new byte[32] : salt;
        this.signature = sig;
        this.sigSize = sig == null ? 0 : sig.length;
        this.zeroPadding = new byte[(4 - this.sigSize % 4) % 4];
        this.extensionOffset = 60 + this.sigSize + this.zeroPadding.length;
    }

    private SignInfo(SignInfoBuilder builder) {
        this.saltSize = builder.saltSize;
        this.sigSize = builder.sigSize;
        this.flags = builder.flags;
        this.dataSize = builder.dataSize;
        this.salt = builder.salt;
        this.extensionNum = builder.extensionNum;
        this.extensionOffset = builder.extensionOffset;
        this.signature = builder.signature;
        this.zeroPadding = builder.zeroPadding;
        this.extensionList = builder.extensionList;
    }

    public void addExtension(Extension extension) {
        this.extensionList.add(extension);
        this.extensionNum = this.extensionList.size();
    }

    public Extension getExtensionByType(int type) {
        for (Extension ext : this.extensionList) {
            if (!ext.isType(type)) continue;
            return ext;
        }
        return null;
    }

    public int getExtensionNum() {
        return this.extensionNum;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public int size() {
        int blockSize = 60 + this.signature.length + this.zeroPadding.length;
        for (Extension ext : this.extensionList) {
            blockSize += ext.size();
        }
        return blockSize;
    }

    public byte[] toByteArray() {
        ByteBuffer bf = ByteBuffer.allocate(this.size()).order(ByteOrder.LITTLE_ENDIAN);
        bf.putInt(this.saltSize);
        bf.putInt(this.sigSize);
        bf.putInt(this.flags);
        bf.putLong(this.dataSize);
        bf.put(this.salt);
        bf.putInt(this.extensionNum);
        bf.putInt(this.extensionOffset);
        bf.put(this.signature);
        bf.put(this.zeroPadding);
        for (Extension ext : this.extensionList) {
            bf.put(ext.toByteArray());
        }
        return bf.array();
    }

    public static SignInfo fromByteArray(byte[] bytes) throws VerifyCodeSignException {
        int inExtensionOffset;
        ByteBuffer bf = ByteBuffer.allocate(bytes.length).order(ByteOrder.LITTLE_ENDIAN);
        bf.put(bytes);
        bf.rewind();
        int inSaltSize = bf.getInt();
        if (inSaltSize < 0) {
            throw new VerifyCodeSignException("Invalid saltSize of SignInfo");
        }
        int inSigSize = bf.getInt();
        if (inSigSize < 0) {
            throw new VerifyCodeSignException("Invalid sigSize of SignInfo");
        }
        int inFlags = bf.getInt();
        if (inFlags != 0 && inFlags != 1) {
            throw new VerifyCodeSignException("Invalid flags of SignInfo");
        }
        long inDataSize = bf.getLong();
        if (inDataSize < 0L) {
            throw new VerifyCodeSignException("Invalid dataSize of SignInfo");
        }
        byte[] inSalt = new byte[32];
        bf.get(inSalt);
        int inExtensionNum = bf.getInt();
        if (inExtensionNum < 0 || inExtensionNum > 2) {
            LOGGER.info("The signature information may be generated by an new tool, extensionNum {} of SignInfo", inExtensionNum);
        }
        if ((inExtensionOffset = bf.getInt()) < 0 || inExtensionOffset % 4 != 0) {
            throw new VerifyCodeSignException("Invalid extensionOffset of SignInfo");
        }
        byte[] inSignature = new byte[inSigSize];
        bf.get(inSignature);
        byte[] inZeroPadding = new byte[(4 - inSigSize % 4) % 4];
        bf.get(inZeroPadding);
        List<Extension> inExtensionList = SignInfo.parseExtensionList(bf, inExtensionNum, inDataSize);
        return new SignInfoBuilder().setSaltSize(inSaltSize).setSigSize(inSigSize).setFlags(inFlags).setDataSize(inDataSize).setSalt(inSalt).setExtensionNum(inExtensionNum).setExtensionOffset(inExtensionOffset).setSignature(inSignature).setZeroPadding(inZeroPadding).setExtensionList(inExtensionList).build();
    }

    private static List<Extension> parseExtensionList(ByteBuffer bf, int inExtensionNum, long inDataSize) throws VerifyCodeSignException {
        ArrayList<Extension> inExtensionList = new ArrayList<Extension>();
        for (int i = 0; i < inExtensionNum; ++i) {
            int extensionSize;
            int extensionType = bf.getInt();
            if (extensionType == 1) {
                extensionSize = bf.getInt();
                if (extensionSize != 80) {
                    throw new VerifyCodeSignException("Invalid MerkleTree extensionSize of SignInfo");
                }
                byte[] merkleTreeExtension = new byte[extensionSize];
                bf.get(merkleTreeExtension);
                inExtensionList.add(MerkleTreeExtension.fromByteArray(merkleTreeExtension));
                continue;
            }
            if (extensionType == 2) {
                extensionSize = bf.getInt();
                if (extensionSize < 24) {
                    throw new VerifyCodeSignException("Invalid PageInfo extensionSize of SignInfo");
                }
                byte[] extensionBytes = new byte[extensionSize];
                bf.get(extensionBytes);
                PageInfoExtension pageInfoExtension = PageInfoExtension.fromByteArray(extensionBytes);
                try {
                    PageInfoExtension.valid(pageInfoExtension, inDataSize);
                }
                catch (PageInfoException e) {
                    throw new VerifyCodeSignException(e.getMessage());
                }
                inExtensionList.add(pageInfoExtension);
                continue;
            }
            LOGGER.info("Invalid extensionType {} of SignInfo", extensionType);
        }
        return inExtensionList;
    }

    public String toString() {
        String str = String.format(Locale.ROOT, "SignInfo: saltSize[%d], sigSize[%d],flags[%d], dataSize[%d], salt[%s], zeroPad[%s], extNum[%d], extOffset[%d]", this.saltSize, this.sigSize, this.flags, this.dataSize, Arrays.toString(this.salt), Arrays.toString(this.zeroPadding), this.extensionNum, this.extensionOffset);
        if (this.getExtensionByType(1) != null) {
            str = str + String.format(Locale.ROOT, "SignInfo.merkleTreeExtension[%s]", this.getExtensionByType(1).toString());
        }
        return str;
    }

    public static class SignInfoBuilder {
        private int saltSize;
        private int sigSize;
        private int flags;
        private long dataSize;
        private byte[] salt;
        private int extensionNum;
        private int extensionOffset;
        private byte[] signature;
        private byte[] zeroPadding;
        private List<Extension> extensionList = new ArrayList<Extension>();

        public SignInfoBuilder setSaltSize(int saltSize) {
            this.saltSize = saltSize;
            return this;
        }

        public SignInfoBuilder setSigSize(int sigSize) {
            this.sigSize = sigSize;
            return this;
        }

        public SignInfoBuilder setFlags(int flags) {
            this.flags = flags;
            return this;
        }

        public SignInfoBuilder setDataSize(long dataSize) {
            this.dataSize = dataSize;
            return this;
        }

        public SignInfoBuilder setSalt(byte[] salt) {
            this.salt = salt;
            return this;
        }

        public SignInfoBuilder setExtensionNum(int extensionNum) {
            this.extensionNum = extensionNum;
            return this;
        }

        public SignInfoBuilder setExtensionOffset(int extensionOffset) {
            this.extensionOffset = extensionOffset;
            return this;
        }

        public SignInfoBuilder setSignature(byte[] signature) {
            this.signature = signature;
            return this;
        }

        public SignInfoBuilder setZeroPadding(byte[] zeroPadding) {
            this.zeroPadding = zeroPadding;
            return this;
        }

        public SignInfoBuilder setExtensionList(List<Extension> extensionList) {
            this.extensionList = extensionList;
            return this;
        }

        public SignInfo build() {
            return new SignInfo(this);
        }
    }
}

