/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.codesigning.datastructure;

import com.ohos.hapsigntool.codesigning.datastructure.SignInfo;
import com.ohos.hapsigntool.codesigning.datastructure.SignedFilePos;
import com.ohos.hapsigntool.codesigning.exception.VerifyCodeSignException;
import com.ohos.hapsigntool.entity.Pair;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class NativeLibInfoSegment {
    private static final int MAGIC_LENGTH_SECNUM_BYTES = 12;
    private static final int SIGNED_FILE_POS_SIZE = 16;
    private static final int MAGIC_NUM = 248702752;
    private static final int ALIGNMENT_FOR_SIGNINFO = 4;
    private int magic;
    private int segmentSize;
    private int sectionNum;
    private List<Pair<String, SignInfo>> soInfoList = new ArrayList<Pair<String, SignInfo>>();
    private List<SignedFilePos> signedFilePosList;
    private List<String> fileNameList;
    private List<SignInfo> signInfoList;
    private byte[] zeroPadding;
    private int fileNameListBlockSize;
    private int signInfoListBlockSize;

    private NativeLibInfoSegment(Builder builder) {
        this.magic = builder.magic;
        this.segmentSize = builder.segmentSize;
        this.sectionNum = builder.sectionNum;
        this.signedFilePosList = builder.signedFilePosList;
        this.fileNameList = builder.fileNameList;
        this.signInfoList = builder.signInfoList;
        this.zeroPadding = builder.zeroPadding;
    }

    public void setSoInfoList(List<Pair<String, SignInfo>> soInfoList) {
        this.soInfoList = soInfoList;
        this.sectionNum = soInfoList.size();
        this.generateList();
    }

    public int getSectionNum() {
        return this.sectionNum;
    }

    public List<String> getFileNameList() {
        return this.fileNameList;
    }

    public List<SignInfo> getSignInfoList() {
        return this.signInfoList;
    }

    private void generateList() {
        this.fileNameList.clear();
        this.signInfoList.clear();
        this.signedFilePosList.clear();
        int fileNameOffset = 0;
        int signInfoOffset = 0;
        for (Pair<String, SignInfo> soInfo : this.soInfoList) {
            String fileName = soInfo.getFirst();
            SignInfo signInfo = soInfo.getSecond();
            int fileNameSizeInBytes = fileName.getBytes(StandardCharsets.UTF_8).length;
            int signInfoSizeInBytes = signInfo.toByteArray().length;
            this.fileNameList.add(fileName);
            this.signInfoList.add(signInfo);
            this.signedFilePosList.add(new SignedFilePos(fileNameOffset, fileNameSizeInBytes, signInfoOffset, signInfoSizeInBytes));
            fileNameOffset += fileNameSizeInBytes;
            signInfoOffset += signInfoSizeInBytes;
        }
        this.fileNameListBlockSize = fileNameOffset;
        this.signInfoListBlockSize = signInfoOffset;
        this.zeroPadding = new byte[(4 - this.fileNameListBlockSize % 4) % 4];
        this.segmentSize = this.size();
        int fileNameOffsetBase = 12 + this.signedFilePosList.size() * 16;
        int signInfoOffsetBase = fileNameOffsetBase + this.fileNameListBlockSize;
        for (SignedFilePos pos : this.signedFilePosList) {
            pos.increaseFileNameOffset(fileNameOffsetBase);
            pos.increaseSignInfoOffset(signInfoOffsetBase + this.zeroPadding.length);
        }
    }

    public int size() {
        int blockSize = 12;
        blockSize += this.signedFilePosList.size() * 16;
        return blockSize += this.fileNameListBlockSize + this.zeroPadding.length + this.signInfoListBlockSize;
    }

    public byte[] toByteArray() {
        ByteBuffer bf = ByteBuffer.allocate(this.size()).order(ByteOrder.LITTLE_ENDIAN);
        bf.putInt(this.magic);
        bf.putInt(this.segmentSize);
        bf.putInt(this.sectionNum);
        for (SignedFilePos offsetAndSize : this.signedFilePosList) {
            bf.putInt(offsetAndSize.getFileNameOffset());
            bf.putInt(offsetAndSize.getFileNameSize());
            bf.putInt(offsetAndSize.getSignInfoOffset());
            bf.putInt(offsetAndSize.getSignInfoSize());
        }
        for (String fileName : this.fileNameList) {
            bf.put(fileName.getBytes(StandardCharsets.UTF_8));
        }
        bf.put(this.zeroPadding);
        for (SignInfo signInfo : this.signInfoList) {
            bf.put(signInfo.toByteArray());
        }
        return bf.array();
    }

    public static NativeLibInfoSegment fromByteArray(byte[] bytes) throws VerifyCodeSignException {
        ByteBuffer bf = ByteBuffer.allocate(bytes.length).order(ByteOrder.LITTLE_ENDIAN);
        bf.put(bytes);
        bf.rewind();
        int inMagic = bf.getInt();
        if (inMagic != 248702752) {
            throw new VerifyCodeSignException("Invalid magic number of NativeLibInfoSegment");
        }
        int inSegmentSize = bf.getInt();
        if (inSegmentSize < 0) {
            throw new VerifyCodeSignException("Invalid segmentSize of NativeLibInfoSegment");
        }
        int inSectionNum = bf.getInt();
        if (inSectionNum < 0) {
            throw new VerifyCodeSignException("Invalid sectionNum of NativeLibInfoSegment");
        }
        ArrayList<SignedFilePos> inSignedFilePosList = new ArrayList<SignedFilePos>();
        for (int i = 0; i < inSectionNum; ++i) {
            byte[] entry = new byte[16];
            bf.get(entry);
            inSignedFilePosList.add(SignedFilePos.fromByteArray(entry));
        }
        ArrayList<String> inFileNameList = new ArrayList<String>();
        int fileNameListSize = 0;
        for (SignedFilePos pos : inSignedFilePosList) {
            byte[] fileNameBuffer = new byte[pos.getFileNameSize()];
            fileNameListSize += pos.getFileNameSize();
            bf.position(pos.getFileNameOffset());
            bf.get(fileNameBuffer);
            inFileNameList.add(new String(fileNameBuffer, StandardCharsets.UTF_8));
        }
        byte[] inZeroPadding = new byte[(4 - fileNameListSize % 4) % 4];
        bf.get(inZeroPadding);
        ArrayList<SignInfo> inSignInfoList = new ArrayList<SignInfo>();
        for (SignedFilePos pos : inSignedFilePosList) {
            if (pos.getSignInfoOffset() % 4 != 0) {
                throw new VerifyCodeSignException("SignInfo not aligned in NativeLibInfoSegment");
            }
            byte[] signInfoBuffer = new byte[pos.getSignInfoSize()];
            bf.position(pos.getSignInfoOffset());
            bf.get(signInfoBuffer);
            inSignInfoList.add(SignInfo.fromByteArray(signInfoBuffer));
        }
        return new Builder().setMagic(inMagic).setSegmentSize(inSegmentSize).setSectionNum(inSectionNum).setSignedFilePosList(inSignedFilePosList).setFileNameList(inFileNameList).setSignInfoList(inSignInfoList).setZeroPadding(inZeroPadding).build();
    }

    public String toString() {
        return String.format(Locale.ROOT, "SoInfoSegment: magic[%d], length[%d], secNum[%d], signedFileEntryList[%s], fileNameList[%s], zeroPadding[%s], signInfoList[%s]", this.magic, this.segmentSize, this.sectionNum, Arrays.toString(this.signedFilePosList.toArray()), Arrays.toString(this.fileNameList.toArray()), Arrays.toString(this.zeroPadding), Arrays.toString(this.signInfoList.toArray()));
    }

    public static class Builder {
        private int magic = 248702752;
        private int segmentSize;
        private int sectionNum;
        private List<SignedFilePos> signedFilePosList = new ArrayList<SignedFilePos>();
        private List<String> fileNameList = new ArrayList<String>();
        private List<SignInfo> signInfoList = new ArrayList<SignInfo>();
        private byte[] zeroPadding = new byte[0];

        public Builder setMagic(int magic) {
            this.magic = magic;
            return this;
        }

        public Builder setSegmentSize(int segmentSize) {
            this.segmentSize = segmentSize;
            return this;
        }

        public Builder setSectionNum(int sectionNum) {
            this.sectionNum = sectionNum;
            return this;
        }

        public Builder setSignedFilePosList(List<SignedFilePos> signedFilePosList) {
            this.signedFilePosList = signedFilePosList;
            return this;
        }

        public Builder setFileNameList(List<String> fileNameList) {
            this.fileNameList = fileNameList;
            return this;
        }

        public Builder setSignInfoList(List<SignInfo> signInfoList) {
            this.signInfoList = signInfoList;
            return this;
        }

        public Builder setZeroPadding(byte[] zeroPadding) {
            this.zeroPadding = zeroPadding;
            return this;
        }

        public NativeLibInfoSegment build() {
            return new NativeLibInfoSegment(this);
        }
    }
}

