/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.codesigning.datastructure;

import com.ohos.hapsigntool.codesigning.datastructure.CodeSignBlockHeader;
import com.ohos.hapsigntool.codesigning.datastructure.Extension;
import com.ohos.hapsigntool.codesigning.datastructure.FsVerityInfoSegment;
import com.ohos.hapsigntool.codesigning.datastructure.HapInfoSegment;
import com.ohos.hapsigntool.codesigning.datastructure.MerkleTreeExtension;
import com.ohos.hapsigntool.codesigning.datastructure.NativeLibInfoSegment;
import com.ohos.hapsigntool.codesigning.datastructure.SegmentHeader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CodeSignBlock {
    public static final long PAGE_SIZE_4K = 4096L;
    public static final int SEGMENT_HEADER_COUNT = 3;
    private CodeSignBlockHeader codeSignBlockHeader = new CodeSignBlockHeader.Builder().build();
    private final List<SegmentHeader> segmentHeaderList = new ArrayList<SegmentHeader>();
    private FsVerityInfoSegment fsVerityInfoSegment = new FsVerityInfoSegment();
    private HapInfoSegment hapInfoSegment = new HapInfoSegment();
    private NativeLibInfoSegment nativeLibInfoSegment = new NativeLibInfoSegment.Builder().build();
    private byte[] zeroPadding;
    private final Map<String, byte[]> merkleTreeMap = new HashMap<String, byte[]>();

    public void addOneMerkleTree(String key, byte[] merkleTree) {
        if (merkleTree == null) {
            this.merkleTreeMap.put(key, new byte[0]);
        } else {
            this.merkleTreeMap.put(key, merkleTree);
        }
    }

    public byte[] getOneMerkleTreeByFileName(String key) {
        return this.merkleTreeMap.get(key);
    }

    public void setCodeSignBlockFlag() {
        int flags = 1;
        if (this.nativeLibInfoSegment.getSectionNum() != 0) {
            flags += 2;
        }
        this.codeSignBlockHeader.setFlags(flags);
    }

    public void setSegmentNum() {
        this.codeSignBlockHeader.setSegmentNum(this.segmentHeaderList.size());
    }

    public void addToSegmentList(SegmentHeader sh) {
        this.segmentHeaderList.add(sh);
    }

    public List<SegmentHeader> getSegmentHeaderList() {
        return this.segmentHeaderList;
    }

    public void setSegmentHeaders() {
        this.segmentHeaderList.add(new SegmentHeader(1, this.fsVerityInfoSegment.size()));
        this.segmentHeaderList.add(new SegmentHeader(2, this.hapInfoSegment.size()));
        this.segmentHeaderList.add(new SegmentHeader(3, this.nativeLibInfoSegment.size()));
    }

    public CodeSignBlockHeader getCodeSignBlockHeader() {
        return this.codeSignBlockHeader;
    }

    public void setCodeSignBlockHeader(CodeSignBlockHeader csbHeader) {
        this.codeSignBlockHeader = csbHeader;
    }

    public void setFsVerityInfoSegment(FsVerityInfoSegment fsVeritySeg) {
        this.fsVerityInfoSegment = fsVeritySeg;
    }

    public FsVerityInfoSegment getFsVerityInfoSegment() {
        return this.fsVerityInfoSegment;
    }

    public HapInfoSegment getHapInfoSegment() {
        return this.hapInfoSegment;
    }

    public void setHapInfoSegment(HapInfoSegment hapSeg) {
        this.hapInfoSegment = hapSeg;
    }

    public NativeLibInfoSegment getSoInfoSegment() {
        return this.nativeLibInfoSegment;
    }

    public void setSoInfoSegment(NativeLibInfoSegment soSeg) {
        this.nativeLibInfoSegment = soSeg;
    }

    public byte[] toByteArray() {
        ByteBuffer bf = ByteBuffer.allocate(this.codeSignBlockHeader.getBlockSize()).order(ByteOrder.LITTLE_ENDIAN);
        bf.put(this.codeSignBlockHeader.toByteArray());
        for (SegmentHeader sh : this.segmentHeaderList) {
            bf.put(sh.toByteArray());
        }
        bf.put(this.zeroPadding);
        if (this.hapInfoSegment.getSignInfo().getExtensionByType(1) != null) {
            bf.put(this.merkleTreeMap.get("Hap"));
        }
        bf.put(this.fsVerityInfoSegment.toByteArray());
        bf.put(this.hapInfoSegment.toByteArray());
        bf.put(this.nativeLibInfoSegment.toByteArray());
        return bf.array();
    }

    public void computeSegmentOffset() {
        int segmentOffset = CodeSignBlockHeader.size() + this.segmentHeaderList.size() * 12 + this.zeroPadding.length + this.getOneMerkleTreeByFileName("Hap").length;
        for (SegmentHeader sh : this.segmentHeaderList) {
            sh.setSegmentOffset(segmentOffset);
            segmentOffset += sh.getSegmentSize();
        }
    }

    public long computeMerkleTreeOffset(long codeSignBlockOffset) {
        long sizeWithoutMerkleTree = CodeSignBlockHeader.size() + 36;
        long residual = (codeSignBlockOffset + sizeWithoutMerkleTree) % 4096L;
        this.zeroPadding = residual == 0L ? new byte[0] : new byte[(int)(4096L - residual)];
        return codeSignBlockOffset + sizeWithoutMerkleTree + (long)this.zeroPadding.length;
    }

    public byte[] generateCodeSignBlockByte(long fsvTreeOffset) {
        long csbSize = (long)CodeSignBlockHeader.size() + (long)this.segmentHeaderList.size() * 12L + (long)this.zeroPadding.length + (long)this.getOneMerkleTreeByFileName("Hap").length + (long)this.fsVerityInfoSegment.size() + (long)this.hapInfoSegment.size() + (long)this.nativeLibInfoSegment.size();
        Extension ext = this.hapInfoSegment.getSignInfo().getExtensionByType(1);
        if (ext instanceof MerkleTreeExtension) {
            MerkleTreeExtension merkleTreeExtension = (MerkleTreeExtension)ext;
            merkleTreeExtension.setMerkleTreeOffset(fsvTreeOffset);
        }
        this.codeSignBlockHeader.setBlockSize(csbSize);
        return this.toByteArray();
    }

    public String toString() {
        return String.format(Locale.ROOT, "CodeSignBlockHeader[%s], SegmentHeaders[%s], FsVeritySeg[%s], HapInfoSeg[%s], SoInfoSeg[%s]", this.codeSignBlockHeader, Arrays.toString(this.segmentHeaderList.toArray()), this.fsVerityInfoSegment, this.hapInfoSegment, this.nativeLibInfoSegment);
    }
}

