/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.api;

import com.google.gson.JsonParser;
import com.ohos.hapsigntool.adapter.LocalizationAdapter;
import com.ohos.hapsigntool.api.CertTools;
import com.ohos.hapsigntool.api.ServiceApi;
import com.ohos.hapsigntool.entity.Options;
import com.ohos.hapsigntool.error.CustomException;
import com.ohos.hapsigntool.error.ERROR;
import com.ohos.hapsigntool.error.SignToolErrMsg;
import com.ohos.hapsigntool.error.VerifyException;
import com.ohos.hapsigntool.hap.provider.LocalJKSSignProvider;
import com.ohos.hapsigntool.hap.provider.RemoteSignProvider;
import com.ohos.hapsigntool.hap.provider.SignProvider;
import com.ohos.hapsigntool.hap.verify.VerifyElf;
import com.ohos.hapsigntool.hap.verify.VerifyHap;
import com.ohos.hapsigntool.profile.ProfileSignTool;
import com.ohos.hapsigntool.profile.VerifyHelper;
import com.ohos.hapsigntool.profile.model.Provision;
import com.ohos.hapsigntool.profile.model.VerificationResult;
import com.ohos.hapsigntool.utils.CertUtils;
import com.ohos.hapsigntool.utils.FileUtils;
import com.ohos.hapsigntool.utils.LogUtils;
import com.ohos.hapsigntool.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SignToolServiceImpl
implements ServiceApi {
    private static final byte[] APP_SIGNING_CAPABILITY = new byte[]{48, 6, 2, 1, 1, 10, 1, 0};
    private static final byte[] PROFILE_SIGNING_CAPABILITY = new byte[]{48, 6, 2, 1, 1, 10, 1, 1};
    private static final LogUtils LOGGER = new LogUtils(ServiceApi.class);

    @Override
    public boolean generateKeyStore(Options options) {
        LocalizationAdapter adapter = new LocalizationAdapter(options);
        adapter.errorOnExist(options.getString("keyAlias"));
        KeyPair keyPair = adapter.getAliasKey(true);
        adapter.releasePwd();
        return keyPair != null;
    }

    @Override
    public boolean generateCsr(Options options) {
        LocalizationAdapter adapter = new LocalizationAdapter(options);
        KeyPair keyPair = adapter.getAliasKey(false);
        adapter.releasePwd();
        byte[] csr = CertTools.generateCsr(keyPair, adapter.getSignAlg(), adapter.getSubject());
        if (csr == null) {
            return false;
        }
        String csrContent = CertUtils.toCsrTemplate(csr);
        this.outputString(csrContent, adapter.getOutFile());
        return true;
    }

    @Override
    public boolean generateCert(Options options) {
        LocalizationAdapter adapter = new LocalizationAdapter(options);
        adapter.errorIfNotExist(adapter.getOptions().getString("keyAlias"));
        String issuerAlias = adapter.getOptions().getString("issuerKeyAlias");
        adapter.errorIfNotExist(issuerAlias);
        KeyPair subjectKeyPair = adapter.getAliasKey(false);
        if (options.containsKey("issuerKeystoreFile")) {
            adapter.setKeyStoreHelper(null);
            adapter.setIssuerKeyStoreFile(true);
        }
        KeyPair rootKeyPair = adapter.getIssuerAliasKey();
        adapter.releasePwd();
        byte[] csr = CertTools.generateCsr(subjectKeyPair, adapter.getSignAlg(), adapter.getSubject());
        X509Certificate cert = CertTools.generateCert(rootKeyPair, csr, adapter);
        return this.outputCert(cert, adapter.getOutFile());
    }

    @Override
    public boolean generateCA(Options options) {
        KeyPair rootKey;
        LocalizationAdapter adapter = new LocalizationAdapter(options);
        boolean isEmpty = StringUtils.isEmpty(options.getString("issuerKeyAlias"));
        KeyPair subKey = adapter.getAliasKey(true);
        String ksFile = options.getString("keystoreFile");
        String iksFile = options.getString("issuerKeystoreFile");
        if (isEmpty) {
            boolean isEqual;
            if (!StringUtils.isEmpty(iksFile) && !ksFile.equals(iksFile)) {
                CustomException.throwException(ERROR.WRITE_FILE_ERROR, SignToolErrMsg.GENERATE_CA_FAILED.toString(ksFile, iksFile));
            }
            if (options.containsKey("issuerKeystorePwd") && !(isEqual = Arrays.equals(options.getChars("keystorePwd"), options.getChars("issuerKeystorePwd")))) {
                CustomException.throwException(ERROR.WRITE_FILE_ERROR, SignToolErrMsg.GENERATE_CA_FAILED.toString("keystorePwd", "issuerKeystorePwd"));
            }
            rootKey = subKey;
        } else {
            if (options.containsKey("issuerKeystoreFile")) {
                FileUtils.validFileType(options.getString("issuerKeystoreFile"), "p12", "jks");
                adapter.setKeyStoreHelper(null);
                adapter.setIssuerKeyStoreFile(true);
            }
            rootKey = adapter.getIssuerAliasKey();
        }
        adapter.releasePwd();
        byte[] csr = CertTools.generateCsr(subKey, adapter.getSignAlg(), adapter.getSubject());
        X509Certificate cert = isEmpty ? CertTools.generateRootCaCert(rootKey, csr, adapter) : CertTools.generateSubCert(rootKey, csr, adapter);
        return this.outputCert(cert, adapter.getOutFile());
    }

    @Override
    public boolean generateAppCert(Options options) {
        LocalizationAdapter adapter = new LocalizationAdapter(options);
        KeyPair keyPair = adapter.getAliasKey(false);
        if (options.containsKey("issuerKeystoreFile")) {
            adapter.setKeyStoreHelper(null);
            adapter.setIssuerKeyStoreFile(true);
        }
        KeyPair issueKeyPair = adapter.getIssuerAliasKey();
        adapter.releasePwd();
        byte[] csr = CertTools.generateCsr(keyPair, adapter.getSignAlg(), adapter.getSubject());
        X509Certificate cert = CertTools.generateEndCert(issueKeyPair, csr, adapter, APP_SIGNING_CAPABILITY);
        return this.getOutputCert(adapter, cert);
    }

    @Override
    public boolean generateProfileCert(Options options) {
        LocalizationAdapter adapter = new LocalizationAdapter(options);
        KeyPair keyPair = adapter.getAliasKey(false);
        if (options.containsKey("issuerKeystoreFile")) {
            adapter.setKeyStoreHelper(null);
            adapter.setIssuerKeyStoreFile(true);
        }
        KeyPair issueKeyPair = adapter.getIssuerAliasKey();
        adapter.releasePwd();
        byte[] csr = CertTools.generateCsr(keyPair, adapter.getSignAlg(), adapter.getSubject());
        X509Certificate cert = CertTools.generateEndCert(issueKeyPair, csr, adapter, PROFILE_SIGNING_CAPABILITY);
        return this.getOutputCert(adapter, cert);
    }

    private boolean getOutputCert(LocalizationAdapter adapter, X509Certificate cert) {
        if (adapter.isOutFormChain()) {
            ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
            certificates.add(cert);
            certificates.add(adapter.getSubCaCertFile());
            certificates.add(adapter.getCaCertFile());
            return this.outputCertChain(certificates, adapter.getOutFile());
        }
        return this.outputCert(cert, adapter.getOutFile());
    }

    @Override
    public boolean signProfile(Options options) {
        boolean isSuccess;
        try {
            LocalizationAdapter adapter = new LocalizationAdapter(options);
            byte[] provisionContent = SignToolServiceImpl.getProvisionContent(new File(adapter.getInFile()));
            byte[] p7b = ProfileSignTool.generateP7b(adapter, provisionContent);
            FileUtils.write(p7b, new File(adapter.getOutFile()));
            isSuccess = true;
        }
        catch (IOException exception) {
            LOGGER.debug(exception.getMessage(), exception);
            LOGGER.error(exception.getMessage());
            isSuccess = false;
        }
        return isSuccess;
    }

    @Override
    public boolean verifyProfile(Options options) {
        boolean isSign;
        try {
            LocalizationAdapter adapter = new LocalizationAdapter(options);
            VerifyHelper verifyHelper = new VerifyHelper();
            byte[] p7b = FileUtils.readFile(new File(adapter.getInFile()));
            VerificationResult verificationResult = verifyHelper.verify(p7b);
            isSign = verificationResult.isVerifiedPassed();
            if (!isSign) {
                LOGGER.error(verificationResult.getMessage());
            }
            this.outputString(FileUtils.GSON_PRETTY_PRINT.toJson(verificationResult), adapter.getOutFile());
        }
        catch (IOException exception) {
            LOGGER.debug(exception.getMessage(), exception);
            LOGGER.error(exception.getMessage());
            isSign = false;
        }
        catch (VerifyException e) {
            CustomException.throwException(ERROR.VERIFY_ERROR, SignToolErrMsg.VERIFY_PROFILE_FAILED.toString(e.getMessage()));
            isSign = false;
        }
        return isSign;
    }

    @Override
    public boolean signHap(Options options) {
        SignProvider signProvider;
        String mode = options.getString("mode");
        if ("localSign".equalsIgnoreCase(mode)) {
            signProvider = new LocalJKSSignProvider();
        } else if ("remoteSign".equalsIgnoreCase(mode)) {
            signProvider = new RemoteSignProvider();
        } else {
            LOGGER.info("Resign mode. But not implement yet");
            return false;
        }
        String inForm = options.getString("inForm", "zip");
        if ("zip".equalsIgnoreCase(inForm)) {
            return signProvider.sign(options);
        }
        if ("elf".equalsIgnoreCase(inForm)) {
            return signProvider.signElf(options);
        }
        return signProvider.signBin(options);
    }

    @Override
    public boolean verifyHap(Options options) {
        if ("zip".equals(options.getOrDefault("inForm", "zip"))) {
            VerifyHap hapVerify = new VerifyHap();
            return hapVerify.verify(options);
        }
        VerifyElf verifyElf = new VerifyElf();
        return verifyElf.verify(options);
    }

    public void outputString(String content, String file) {
        if (StringUtils.isEmpty(file)) {
            LOGGER.info(content);
        } else {
            try {
                FileUtils.write(content.getBytes(StandardCharsets.UTF_8), new File(file));
            }
            catch (IOException exception) {
                LOGGER.debug(exception.getMessage(), exception);
                CustomException.throwException(ERROR.WRITE_FILE_ERROR, SignToolErrMsg.FILE_WRITE_FAILED.toString(exception.getMessage()));
            }
        }
    }

    public boolean outputCert(X509Certificate certificate, String file) {
        try {
            if (StringUtils.isEmpty(file)) {
                LOGGER.info(CertUtils.generateCertificateInCer(certificate));
            } else {
                FileUtils.write(CertUtils.generateCertificateInCer(certificate).getBytes(StandardCharsets.UTF_8), new File(file));
            }
            return true;
        }
        catch (IOException | CertificateException exception) {
            LOGGER.debug(exception.getMessage(), exception);
            CustomException.throwException(ERROR.WRITE_FILE_ERROR, SignToolErrMsg.FILE_WRITE_FAILED.toString(exception.getMessage()));
            return false;
        }
    }

    public boolean outputCertChain(List<X509Certificate> certificates, String file) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (X509Certificate cert : certificates) {
                stringBuilder.append(CertUtils.generateCertificateInCer(cert));
            }
            if (StringUtils.isEmpty(file)) {
                LOGGER.info(stringBuilder.toString());
            } else {
                FileUtils.write(stringBuilder.toString().getBytes(StandardCharsets.UTF_8), new File(file));
            }
            return true;
        }
        catch (IOException | CertificateException exception) {
            LOGGER.debug(exception.getMessage(), exception);
            CustomException.throwException(ERROR.WRITE_FILE_ERROR, SignToolErrMsg.FILE_WRITE_FAILED.toString(exception.getMessage()));
            return false;
        }
    }

    public static byte[] getProvisionContent(File input) throws IOException {
        byte[] bytes = FileUtils.readFile(input);
        String json = JsonParser.parseString(new String(bytes, StandardCharsets.UTF_8)).toString();
        Provision provision = FileUtils.GSON.fromJson(new String(bytes, StandardCharsets.UTF_8), Provision.class);
        Provision.enforceValid(provision);
        return json.getBytes(StandardCharsets.UTF_8);
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
}

