/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.adapter;

import com.ohos.hapsigntool.entity.Options;
import com.ohos.hapsigntool.error.CustomException;
import com.ohos.hapsigntool.error.ERROR;
import com.ohos.hapsigntool.error.SignToolErrMsg;
import com.ohos.hapsigntool.error.VerifyCertificateChainException;
import com.ohos.hapsigntool.utils.CertUtils;
import com.ohos.hapsigntool.utils.FileUtils;
import com.ohos.hapsigntool.utils.KeyPairTools;
import com.ohos.hapsigntool.utils.KeyStoreHelper;
import com.ohos.hapsigntool.utils.LogUtils;
import com.ohos.hapsigntool.utils.StringUtils;
import com.ohos.hapsigntool.utils.ValidateUtils;
import java.io.File;
import java.io.IOException;
import java.security.KeyPair;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;

public class LocalizationAdapter {
    private static final int MIN_CERT_CHAIN_SIZE = 2;
    private static final int MAX_CERT_CHAIN_SIZE = 3;
    private static final LogUtils LOGGER = new LogUtils(LocalizationAdapter.class);
    private final Options options;
    private KeyStoreHelper keyStoreHelper;
    private boolean isIssuerKeyStoreFile = false;

    public LocalizationAdapter(Options options) {
        this.options = options;
    }

    public void setKeyStoreHelper(KeyStoreHelper keyStoreHelper) {
        this.keyStoreHelper = keyStoreHelper;
    }

    public void setIssuerKeyStoreFile(boolean issuerKeyStoreFile) {
        this.isIssuerKeyStoreFile = issuerKeyStoreFile;
    }

    public Options getOptions() {
        return this.options;
    }

    private void initKeyStore() {
        if (this.keyStoreHelper != null) {
            return;
        }
        if (this.isIssuerKeyStoreFile) {
            String keyStore = this.options.getString("issuerKeystoreFile", "");
            this.keyStoreHelper = new KeyStoreHelper(keyStore, this.options.getChars("issuerKeystorePwd"));
        } else {
            String keyStore = this.options.getString("keystoreFile", "");
            this.keyStoreHelper = new KeyStoreHelper(keyStore, this.options.getChars("keystorePwd"));
        }
        this.setIssuerKeyStoreFile(false);
    }

    public KeyPair getAliasKey(boolean autoCreate) {
        return this.getKeyPair(this.options.getString("keyAlias"), this.options.getChars("keyPwd"), autoCreate);
    }

    public KeyPair getIssuerAliasKey() {
        return this.getKeyPair(this.options.getString("issuerKeyAlias"), this.options.getChars("issuerKeyPwd"), false);
    }

    public boolean hasAlias(String alias) {
        if (this.keyStoreHelper == null) {
            this.initKeyStore();
        }
        return this.keyStoreHelper.hasAlias(alias);
    }

    public void errorIfNotExist(String alias) {
        if (this.keyStoreHelper == null) {
            this.initKeyStore();
        }
        this.keyStoreHelper.errorIfNotExist(alias);
    }

    public void errorOnExist(String alias) {
        if (this.keyStoreHelper == null) {
            this.initKeyStore();
        }
        this.keyStoreHelper.errorOnExist(alias);
    }

    private KeyPair getKeyPair(String alias, char[] keyPwd, boolean autoCreate) {
        if (this.keyStoreHelper == null) {
            this.initKeyStore();
        }
        ValidateUtils.throwIfNotMatches(!StringUtils.isEmpty(alias), ERROR.ACCESS_ERROR, SignToolErrMsg.PARAM_VALUE_EMPTY.toString("KeyAlias"));
        KeyPair keyPair = null;
        if (this.keyStoreHelper.hasAlias(alias)) {
            keyPair = this.keyStoreHelper.loadKeyPair(alias, keyPwd);
        } else if (autoCreate) {
            this.options.required("keyAlg", "keySize");
            keyPair = KeyPairTools.generateKeyPair(this.options.getString("keyAlg"), this.options.getInt("keySize"));
            this.keyStoreHelper.store(alias, keyPwd, keyPair, null);
        }
        ValidateUtils.throwIfNotMatches(keyPair != null, ERROR.PARAM_NOT_EXIST_ERROR, SignToolErrMsg.KEY_ALIAS_NOT_FOUND.toString(alias, this.keyStoreHelper.getKeyStorePath()));
        return keyPair;
    }

    public List<X509Certificate> getSignCertChain() {
        List<X509Certificate> certificates;
        String certPath = this.options.getString("profileCertFile");
        if (StringUtils.isEmpty(certPath)) {
            certPath = this.options.getString("appCertFile");
        }
        ValidateUtils.throwIfNotMatches((certificates = this.getCertsFromFile(certPath, "profileCertFile")).size() >= 2 && certificates.size() <= 3, ERROR.NOT_SUPPORT_ERROR, SignToolErrMsg.CERT_CHAIN_FORMAT_FAILED.toString(certPath));
        return certificates;
    }

    public X509Certificate getSubCaCertFile() {
        String certPath = this.options.getString("subCaCertFile");
        return this.getCertsFromFile(certPath, "subCaCertFile").get(0);
    }

    public X509Certificate getCaCertFile() {
        String certPath = this.options.getString("rootCaCertFile");
        return this.getCertsFromFile(certPath, "rootCaCertFile").get(0);
    }

    public boolean isOutFormChain() {
        String outForm = this.options.getString("outForm", "certChain");
        return "certChain".equals(outForm);
    }

    public List<X509Certificate> getCertsFromFile(String certPath, String logTitle) {
        ValidateUtils.throwIfNotMatches(!StringUtils.isEmpty(certPath), ERROR.PARAM_NOT_EXIST_ERROR, SignToolErrMsg.FILE_NOT_EXIST.toString(logTitle));
        File certFile = new File(certPath);
        ValidateUtils.throwIfNotMatches(certFile.exists(), ERROR.FILE_NOT_FOUND, SignToolErrMsg.FILE_NOT_EXIST.toString(certPath));
        List<X509Certificate> certificates = null;
        try {
            certificates = CertUtils.generateCertificates(FileUtils.readFile(certFile));
        }
        catch (VerifyCertificateChainException | IOException | CertificateException exception) {
            LOGGER.debug(exception.getMessage(), exception);
            CustomException.throwException(ERROR.ACCESS_ERROR, SignToolErrMsg.CERT_FORMAT_FAILED.toString(exception.getMessage()));
        }
        ValidateUtils.throwIfNotMatches(certificates != null && !certificates.isEmpty(), ERROR.READ_FILE_ERROR, SignToolErrMsg.CERT_FORMAT_FAILED.toString("can not found certificates in file " + certPath));
        return certificates;
    }

    public String getSignAlg() {
        return this.options.getString("signAlg");
    }

    public boolean isKeyUsageCritical() {
        return this.options.getBoolean("keyUsageCritical", true);
    }

    public boolean isExtKeyUsageCritical() {
        return this.options.getBoolean("extKeyUsageCritical", true);
    }

    public boolean isBasicConstraintsCa() {
        return this.options.getBoolean("basicConstraintsCa", false);
    }

    public boolean isBasicConstraintsCritical() {
        return this.options.getBoolean("basicConstraintsCritical", false);
    }

    public int getBasicConstraintsPathLen() {
        return this.options.getInt("basicConstraintsPathLen");
    }

    public KeyPurposeId[] getExtKeyUsage() {
        return CertUtils.parseExtKeyUsage(this.options.getString("extKeyUsage"));
    }

    public KeyUsage getKeyUsage() {
        return new KeyUsage(CertUtils.parseKeyUsage(this.options.getString("keyUsage")));
    }

    public X500Name getSubject() {
        String subject = this.options.getString("subject");
        return CertUtils.buildDN(subject);
    }

    public X500Name getIssuer() {
        String issuer = this.options.getString("issuer", this.options.getString("subject"));
        return CertUtils.buildDN(issuer);
    }

    public String getOutFile() {
        return this.options.getString("outFile");
    }

    public String getInFile() {
        String file = this.options.getString("inFile");
        ValidateUtils.throwIfNotMatches(new File(file).exists(), ERROR.FILE_NOT_FOUND, SignToolErrMsg.FILE_NOT_EXIST.toString(file));
        return file;
    }

    public boolean isRemoteSigner() {
        String mode = this.options.getString("mode", "localSign");
        return "remoteSign".equalsIgnoreCase(mode);
    }

    public void releasePwd() {
        this.resetChars(this.options.getChars("keystorePwd"));
        this.resetChars(this.options.getChars("keyPwd"));
        this.resetChars(this.options.getChars("issuerKeyPwd"));
        this.resetChars(this.options.getChars("issuerKeystorePwd"));
    }

    private void resetChars(char[] chars) {
        if (chars == null) {
            return;
        }
        Arrays.fill(chars, '\u0000');
    }
}

