/*
 * Decompiled with CFR 0.152.
 */
package ohos;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import ohos.BundleException;
import ohos.CompressVerify;
import ohos.Log;
import ohos.ModuleJsonInfo;
import ohos.PackageNormalize;
import ohos.Utility;
import org.apache.commons.compress.archivers.zip.DefaultBackingStoreSupplier;
import org.apache.commons.compress.archivers.zip.ParallelScatterZipCreator;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.parallel.InputStreamSupplier;
import org.apache.commons.compress.utils.IOUtils;

public class PackageUtil {
    private static final Log LOG = new Log("");

    public static List<String> getPackageNameFromPath(Path path) {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!Files.exists(path, new LinkOption[0])) {
            LOG.warning("getPackageNameFromPath path not exists: " + path);
            return arrayList;
        }
        if (Files.isRegularFile(path, new LinkOption[0]) && (string = path.getFileName().toString()).endsWith(".hsp")) {
            arrayList.add(string.substring(0, string.lastIndexOf(".hsp")));
            return arrayList;
        }
        string = PackageUtil.getPackInfoContentFromPath(path);
        if (string == null) {
            return arrayList;
        }
        return PackageUtil.getPackageNameFromPackInfo(string);
    }

    public static String getBundleTypeFromPath(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            LOG.warning("getBundleTypeFromPath path not exists: " + path);
            return "";
        }
        String string = PackageUtil.getModuleJsonContentFromPath(path);
        if (string == null) {
            return "";
        }
        return PackageUtil.getBundleTypeFromModuleJson(string);
    }

    public static List<String> getPackageNameFromPackInfo(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            JSONObject jSONObject = JSON.parseObject(string, JSONObject.class);
            if (jSONObject == null) {
                LOG.warning("getPackagesFromPackInfo failed, json format invalid.");
                return arrayList;
            }
            JSONArray jSONArray = jSONObject.getJSONArray("packages");
            if (jSONArray == null) {
                LOG.warning("getPackagesFromPackInfo failed, json format invalid.");
                return arrayList;
            }
            for (int i = 0; i < jSONArray.size(); ++i) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                String string2 = jSONObject2.getString("name");
                if (string2 == null) continue;
                arrayList.add(string2);
            }
            return arrayList;
        }
        catch (JSONException jSONException) {
            LOG.warning("getPackagesFromPackInfo err: " + jSONException.getMessage());
            return new ArrayList<String>();
        }
    }

    private static String getBundleTypeFromModuleJson(String string) {
        try {
            JSONObject jSONObject = JSON.parseObject(string, JSONObject.class);
            if (jSONObject == null) {
                LOG.warning("getBundleTypeFromModuleJson failed, parse json is null.");
                return "";
            }
            JSONObject jSONObject2 = jSONObject.getJSONObject("app");
            if (jSONObject2 == null) {
                LOG.warning("getBundleTypeFromModuleJson failed, [app] is null.");
                return "";
            }
            String string2 = jSONObject2.getString("bundleType");
            return string2 != null ? string2 : "app";
        }
        catch (JSONException jSONException) {
            LOG.warning("getBundleTypeFromModuleJson failed: " + jSONException.getMessage());
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ModuleJsonInfo parseModuleJsonInfo(Path path) {
        ModuleJsonInfo moduleJsonInfo = new ModuleJsonInfo();
        try (FileInputStream fileInputStream = new FileInputStream(path.toFile());){
            JSONObject jSONObject = JSON.parseObject((InputStream)fileInputStream, JSONObject.class, new Feature[0]);
            if (jSONObject == null) {
                LOG.warning("parseModuleJsonInfo failed, json format invalid.");
                ModuleJsonInfo moduleJsonInfo2 = moduleJsonInfo;
                return moduleJsonInfo2;
            }
            JSONObject jSONObject2 = jSONObject.getJSONObject("app");
            if (jSONObject2 == null) {
                LOG.warning("parseModuleJsonInfo failed, not found [app]");
                ModuleJsonInfo moduleJsonInfo3 = moduleJsonInfo;
                return moduleJsonInfo3;
            }
            JSONObject jSONObject3 = jSONObject.getJSONObject("module");
            if (jSONObject3 == null) {
                LOG.warning("parseModuleJsonInfo failed, not found [module]");
                ModuleJsonInfo moduleJsonInfo4 = moduleJsonInfo;
                return moduleJsonInfo4;
            }
            moduleJsonInfo.setGenerateBuildHash(jSONObject2.getBooleanValue("generateBuildHash") || jSONObject3.getBooleanValue("generateBuildHash"));
            moduleJsonInfo.setCompressNativeLibs(jSONObject3.getBooleanValue("compressNativeLibs"));
            String string = jSONObject3.getString("type");
            moduleJsonInfo.setModuleType(string != null ? string : "");
            String string2 = jSONObject3.getString("name");
            moduleJsonInfo.setModuleName(string2 != null ? string2 : "");
            ModuleJsonInfo moduleJsonInfo5 = moduleJsonInfo;
            return moduleJsonInfo5;
        }
        catch (IOException iOException) {
            LOG.warning("parseModuleJsonInfo err: " + iOException.getMessage());
            return moduleJsonInfo;
        }
    }

    private static String getPackInfoContentFromPath(Path path) {
        block5: {
            try {
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    String string = path.getFileName().toString();
                    if (string.equals("pack.info")) {
                        return new String(Files.readAllBytes(path));
                    }
                    if (string.endsWith(".hsp")) {
                        return PackageUtil.getZipEntryContent(path, "pack.info");
                    }
                    break block5;
                }
                return new String(Files.readAllBytes(path.resolve("pack.info")));
            }
            catch (IOException iOException) {
                LOG.warning("getPackInfoContentFromPath err: " + iOException.getMessage());
            }
        }
        return null;
    }

    private static String getModuleJsonContentFromPath(Path path) {
        block5: {
            try {
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    String string = path.getFileName().toString();
                    if (string.equals("module.json")) {
                        return new String(Files.readAllBytes(path));
                    }
                    if (string.endsWith(".hsp")) {
                        return PackageUtil.getZipEntryContent(path, "module.json");
                    }
                    break block5;
                }
                return new String(Files.readAllBytes(path.resolve("module.json")));
            }
            catch (IOException iOException) {
                LOG.warning("getPackInfoContentFromPath err: " + iOException.getMessage());
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getZipEntryContent(Path path, String string) {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return null;
        }
        try (ZipFile zipFile = new ZipFile(path.toFile());
             ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            ZipArchiveEntry zipArchiveEntry = zipFile.getEntry(string);
            if (zipArchiveEntry == null) return null;
            IOUtils.copy(zipFile.getInputStream(zipArchiveEntry), (OutputStream)byteArrayOutputStream);
            String string2 = byteArrayOutputStream.toString();
            return string2;
        }
        catch (IOException iOException) {
            LOG.warning("getZipEntryContent err: " + iOException.getMessage());
        }
        return null;
    }

    public static Path pack(Path path, Path path2, Path path3, int n) throws BundleException, IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new BundleException("pack err, input path not exists.");
        }
        if (!Files.exists(path2, new LinkOption[0])) {
            throw new BundleException("pack err, app pack.info not exists.");
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            return PackageUtil.packDir(path, path2, path3, n);
        }
        if (Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().endsWith(".hsp")) {
            return PackageUtil.repackHsp(path, path2, path3, n);
        }
        throw new BundleException("pack err, not support: " + path);
    }

    public static boolean rmdir(Path path) {
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    Files.delete(path);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
                    Files.delete(path);
                    return FileVisitResult.CONTINUE;
                }
            });
            return true;
        }
        catch (IOException iOException) {
            LOG.warning("rmdir err: " + iOException.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String hash(Path path2) {
        try (Stream<Path> stream = Files.walk(path2, new FileVisitOption[0]);){
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            stream.filter(path -> Files.isRegularFile(path, new LinkOption[0])).sorted().forEach(path -> {
                try {
                    byte[] byArray = Files.readAllBytes(path);
                    messageDigest.update(byArray);
                }
                catch (IOException iOException) {
                    LOG.warning("calc hash err: " + iOException.getMessage());
                }
            });
            byte[] byArray = messageDigest.digest();
            StringBuilder stringBuilder = new StringBuilder();
            for (byte by : byArray) {
                stringBuilder.append(String.format("%02x", by));
            }
            String string = stringBuilder.toString();
            return string;
        }
        catch (IOException | NoSuchAlgorithmException exception) {
            LOG.warning("calc hash err: " + exception.getMessage());
            return "";
        }
    }

    private static Path repackHsp(Path path, Path path2, Path path3, int n) throws BundleException, IOException {
        Path path4 = Files.createFile(path3.resolve(path.getFileName()), new FileAttribute[0]);
        try (ZipFile zipFile = new ZipFile(path.toFile());
             ZipArchiveOutputStream zipArchiveOutputStream = new ZipArchiveOutputStream(new CheckedOutputStream(Files.newOutputStream(path4, new OpenOption[0]), new CRC32()));){
            int n2 = Runtime.getRuntime().availableProcessors();
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(n2, n2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
            ParallelScatterZipCreator parallelScatterZipCreator = new ParallelScatterZipCreator(threadPoolExecutor, new DefaultBackingStoreSupplier(null), n);
            PackageUtil.pathToZipEntry(path2, "", parallelScatterZipCreator, false);
            Enumeration<ZipArchiveEntry> enumeration = zipFile.getEntries();
            while (enumeration.hasMoreElements()) {
                ZipArchiveEntry zipArchiveEntry = enumeration.nextElement();
                if ("pack.info".equals(zipArchiveEntry.getName())) continue;
                InputStreamSupplier inputStreamSupplier = () -> {
                    try {
                        return zipFile.getInputStream(zipArchiveEntry);
                    }
                    catch (IOException iOException) {
                        LOG.error("addArchiveEntry err: " + iOException.getMessage());
                        return null;
                    }
                };
                parallelScatterZipCreator.addArchiveEntry(zipArchiveEntry, inputStreamSupplier);
            }
            parallelScatterZipCreator.writeTo(zipArchiveOutputStream);
        }
        catch (InterruptedException | ExecutionException exception) {
            String string = "repackHsp err: " + exception.getMessage();
            LOG.error(string);
            throw new BundleException(string);
        }
        return path4;
    }

    private static Path packDir(Path path, Path path2, Path path3, int n) throws BundleException, IOException {
        List<String> list = PackageUtil.getPackageNameFromPath(path.resolve("pack.info"));
        if (list.size() != 1) {
            throw new BundleException("pack err, pack.info format err");
        }
        ModuleJsonInfo moduleJsonInfo = PackageUtil.parseModuleJsonInfo(path.resolve("module.json"));
        String string = list.get(0);
        String string2 = moduleJsonInfo.isShared() ? ".hsp" : ".hap";
        Path path4 = Files.createFile(path3.resolve(string + string2), new FileAttribute[0]);
        if (moduleJsonInfo.isCompressNativeLibs()) {
            return PackageUtil.packMultiThread(path, path2, path4, n, moduleJsonInfo);
        }
        return PackageUtil.packSingleThread(path, path2, path4, moduleJsonInfo);
    }

    private static Path packSingleThread(Path path, Path path2, Path path3, ModuleJsonInfo moduleJsonInfo) throws BundleException, IOException {
        File[] fileArray = path.toFile().listFiles();
        if (fileArray == null || fileArray.length == 0) {
            throw new BundleException("pack err, dir is empty");
        }
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new CheckedOutputStream(Files.newOutputStream(path3, new OpenOption[0]), new CRC32()));){
            PackageUtil.pathToZipEntry(path2, "", zipOutputStream, false);
            if (moduleJsonInfo.isGenerateBuildHash()) {
                PackageUtil.genBuildHash(path, zipOutputStream);
            }
            PackageUtil.filesToZipEntry(fileArray, zipOutputStream, moduleJsonInfo.isGenerateBuildHash(), moduleJsonInfo.isCompressNativeLibs());
        }
        return path3;
    }

    private static Path packMultiThread(Path path, Path path2, Path path3, int n, ModuleJsonInfo moduleJsonInfo) throws BundleException, IOException {
        File[] fileArray = path.toFile().listFiles();
        if (fileArray == null || fileArray.length == 0) {
            throw new BundleException("pack err, dir is empty");
        }
        try (ZipArchiveOutputStream zipArchiveOutputStream = new ZipArchiveOutputStream(new CheckedOutputStream(Files.newOutputStream(path3, new OpenOption[0]), new CRC32()));){
            int n2 = Runtime.getRuntime().availableProcessors();
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(n2, n2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
            ParallelScatterZipCreator parallelScatterZipCreator = new ParallelScatterZipCreator(threadPoolExecutor, new DefaultBackingStoreSupplier(null), n);
            PackageUtil.pathToZipEntry(path2, "", parallelScatterZipCreator, false);
            if (moduleJsonInfo.isGenerateBuildHash()) {
                PackageUtil.genBuildHash(path, parallelScatterZipCreator);
            }
            PackageUtil.filesToZipEntry(fileArray, parallelScatterZipCreator, moduleJsonInfo.isGenerateBuildHash(), moduleJsonInfo.isCompressNativeLibs());
            parallelScatterZipCreator.writeTo(zipArchiveOutputStream);
        }
        catch (InterruptedException | ExecutionException exception) {
            String string = "packDir err: " + exception.getMessage();
            LOG.error(string);
            throw new BundleException(string);
        }
        return path3;
    }

    private static void filesToZipEntry(File[] fileArray, ParallelScatterZipCreator parallelScatterZipCreator, boolean bl, boolean bl2) throws BundleException {
        for (File file : fileArray) {
            if (file.isFile() && !file.getName().equals("pack.info")) {
                if (bl && file.getName().equals("module.json")) continue;
                PackageUtil.pathToZipEntry(file.toPath(), "", parallelScatterZipCreator, false);
                continue;
            }
            if (!file.isDirectory()) continue;
            if (file.getName().equals("libs")) {
                PackageUtil.pathToZipEntry(file.toPath(), "libs/", parallelScatterZipCreator, bl2);
                continue;
            }
            PackageUtil.pathToZipEntry(file.toPath(), file.getName() + "/", parallelScatterZipCreator, false);
        }
    }

    private static void genBuildHash(Path path, ParallelScatterZipCreator parallelScatterZipCreator) {
        String string = PackageUtil.hash(path);
        if (string.isEmpty()) {
            return;
        }
        Path path2 = path.resolve("module.json");
        if (!Files.exists(path2, new LinkOption[0])) {
            LOG.warning("module.json not found: " + path);
            return;
        }
        try (FileInputStream fileInputStream = new FileInputStream(path2.toFile());){
            JSONObject jSONObject = JSON.parseObject((InputStream)fileInputStream, JSONObject.class, new Feature[0]);
            if (jSONObject == null) {
                LOG.warning("generateBuildHash: parse json is null.");
                return;
            }
            JSONObject jSONObject2 = jSONObject.getJSONObject("module");
            if (jSONObject2 == null) {
                LOG.warning("generateBuildHash: parse json[module] is null.");
                return;
            }
            jSONObject2.put("buildHash", (Object)string);
            byte[] byArray = JSON.toJSONBytes((Object)jSONObject, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.SortField);
            ZipArchiveEntry zipArchiveEntry = new ZipArchiveEntry("module.json");
            zipArchiveEntry.setMethod(0);
            InputStreamSupplier inputStreamSupplier = () -> new ByteArrayInputStream(byArray);
            parallelScatterZipCreator.addArchiveEntry(zipArchiveEntry, inputStreamSupplier);
        }
        catch (IOException iOException) {
            LOG.warning("genBuildHash err: " + iOException.getMessage());
        }
    }

    private static void pathToZipEntry(Path path, String string, ParallelScatterZipCreator parallelScatterZipCreator, boolean bl) throws BundleException {
        try {
            File file = path.toFile();
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                if (fileArray == null) {
                    return;
                }
                for (File file2 : fileArray) {
                    PackageUtil.addArchiveEntry(file2, string, parallelScatterZipCreator, bl);
                }
            } else {
                PackageUtil.addArchiveEntry(file, string, parallelScatterZipCreator, bl);
            }
        }
        catch (IOException iOException) {
            String string2 = "pathToZip err: " + iOException.getMessage();
            LOG.error(string2);
            throw new BundleException(string2);
        }
    }

    private static void addArchiveEntry(File file, String string, ParallelScatterZipCreator parallelScatterZipCreator, boolean bl) throws IOException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                LOG.error("listFiles null: " + file.getName());
                return;
            }
            if (fileArray.length == 0) {
                String object = (string + file.getName() + File.separator).replace(File.separator, "/");
                ZipArchiveEntry zipArchiveEntry = new ZipArchiveEntry(object);
                zipArchiveEntry.setMethod(0);
                zipArchiveEntry.setSize(0L);
                zipArchiveEntry.setCrc(0L);
                InputStreamSupplier inputStreamSupplier = () -> new ByteArrayInputStream(new byte[0]);
                parallelScatterZipCreator.addArchiveEntry(zipArchiveEntry, inputStreamSupplier);
            }
            for (File file2 : fileArray) {
                PackageUtil.addArchiveEntry(file2, string + file.getName() + File.separator, parallelScatterZipCreator, bl);
            }
        } else {
            String string2 = (string + file.getName()).replace(File.separator, "/");
            ZipArchiveEntry zipArchiveEntry = new ZipArchiveEntry(string2);
            if (bl) {
                zipArchiveEntry.setMethod(8);
            } else {
                zipArchiveEntry.setMethod(0);
            }
            InputStreamSupplier inputStreamSupplier = () -> {
                try {
                    return PackageUtil.getInputStream(string2, file);
                }
                catch (IOException iOException) {
                    LOG.error("addArchiveEntry err: " + iOException.getMessage());
                    return null;
                }
            };
            parallelScatterZipCreator.addArchiveEntry(zipArchiveEntry, inputStreamSupplier);
        }
    }

    private static InputStream getInputStream(String string, File file) throws IOException {
        if (!string.contains("resources/rawfile") && !string.contains("resources/resfile") && file.getName().toLowerCase(Locale.ENGLISH).endsWith(".json")) {
            try {
                Object object = JSON.parse(Files.readAllBytes(file.toPath()), new Feature[0]);
                byte[] byArray = JSON.toJSONBytes(object, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat);
                return new ByteArrayInputStream(byArray);
            }
            catch (JSONException jSONException) {
                LOG.warning("json format err: " + file.getName());
            }
        }
        return Files.newInputStream(file.toPath(), new OpenOption[0]);
    }

    private static void filesToZipEntry(File[] fileArray, ZipOutputStream zipOutputStream, boolean bl, boolean bl2) throws BundleException {
        for (File file : fileArray) {
            if (file.isFile() && !file.getName().equals("pack.info")) {
                if (bl && file.getName().equals("module.json")) continue;
                PackageUtil.pathToZipEntry(file.toPath(), "", zipOutputStream, false);
                continue;
            }
            if (!file.isDirectory()) continue;
            if (file.getName().equals("libs")) {
                PackageUtil.pathToZipEntry(file.toPath(), "libs/", zipOutputStream, bl2);
                continue;
            }
            PackageUtil.pathToZipEntry(file.toPath(), file.getName() + "/", zipOutputStream, false);
        }
    }

    private static void genBuildHash(Path path, ZipOutputStream zipOutputStream) {
        String string = PackageUtil.hash(path);
        if (string.isEmpty()) {
            return;
        }
        Path path2 = path.resolve("module.json");
        if (!Files.exists(path2, new LinkOption[0])) {
            LOG.warning("module.json not found: " + path);
            return;
        }
        try (FileInputStream fileInputStream = new FileInputStream(path2.toFile());){
            JSONObject jSONObject = JSON.parseObject((InputStream)fileInputStream, JSONObject.class, new Feature[0]);
            if (jSONObject == null) {
                LOG.warning("generateBuildHash: parse json is null.");
                return;
            }
            JSONObject jSONObject2 = jSONObject.getJSONObject("module");
            if (jSONObject2 == null) {
                LOG.warning("generateBuildHash: parse json[module] is null.");
                return;
            }
            jSONObject2.put("buildHash", (Object)string);
            byte[] byArray = JSON.toJSONBytes((Object)jSONObject, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.SortField);
            CRC32 cRC32 = new CRC32();
            cRC32.update(byArray, 0, byArray.length);
            ZipEntry zipEntry = new ZipEntry("module.json");
            zipEntry.setMethod(0);
            zipEntry.setCompressedSize(byArray.length);
            zipEntry.setCrc(cRC32.getValue());
            zipOutputStream.putNextEntry(zipEntry);
            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
                IOUtils.copy(byteArrayInputStream, zipOutputStream, 40960);
            }
            zipOutputStream.closeEntry();
        }
        catch (IOException iOException) {
            LOG.warning("genBuildHash err: " + iOException.getMessage());
        }
    }

    private static void pathToZipEntry(Path path, String string, ZipOutputStream zipOutputStream, boolean bl) throws BundleException {
        try {
            File file = path.toFile();
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                if (fileArray == null) {
                    return;
                }
                for (File file2 : fileArray) {
                    PackageUtil.addArchiveEntry(file2, string, zipOutputStream, bl);
                }
            } else {
                PackageUtil.addArchiveEntry(file, string, zipOutputStream, bl);
            }
        }
        catch (IOException iOException) {
            String string2 = "pathToZip err: " + iOException.getMessage();
            LOG.error(string2);
            throw new BundleException(string2);
        }
    }

    private static void addArchiveEntry(File file, String string, ZipOutputStream zipOutputStream, boolean bl) throws IOException, BundleException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                LOG.error("listFiles null: " + file.getName());
                return;
            }
            if (fileArray.length == 0) {
                String object = (string + file.getName() + File.separator).replace(File.separator, "/");
                ZipEntry zipEntry = new ZipEntry(object);
                zipEntry.setMethod(0);
                zipEntry.setSize(0L);
                zipEntry.setCrc(0L);
                zipOutputStream.putNextEntry(zipEntry);
                zipOutputStream.closeEntry();
            }
            for (File throwable3 : fileArray) {
                PackageUtil.addArchiveEntry(throwable3, string + file.getName() + File.separator, zipOutputStream, bl);
            }
        } else {
            Object object;
            String string2 = (string + file.getName()).replace(File.separator, "/");
            ZipEntry zipEntry = new ZipEntry(string2);
            if (bl) {
                zipEntry.setMethod(8);
            } else {
                zipEntry.setMethod(0);
                object = PackageNormalize.getCrcFromFile(file);
                zipEntry.setCrc(((CRC32)object).getValue());
                zipEntry.setCompressedSize(file.length());
            }
            zipOutputStream.putNextEntry(zipEntry);
            object = Files.newInputStream(file.toPath(), new OpenOption[0]);
            Throwable throwable = null;
            try {
                IOUtils.copy((InputStream)object, zipOutputStream, 40960);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        ((InputStream)object).close();
                    }
                }
            }
            zipOutputStream.closeEntry();
        }
    }

    private static boolean checkBundleTypeConsistency(List<String> list, List<String> list2, Utility utility) {
        String string = "";
        if (!list.isEmpty()) {
            string = PackageUtil.getBundleTypeFromPath(Paths.get(list.get(0), new String[0]));
        } else if (!list2.isEmpty()) {
            string = PackageUtil.getBundleTypeFromPath(Paths.get(list2.get(0), new String[0]));
        }
        if (string == null || string.isEmpty()) {
            return false;
        }
        for (String string2 : list) {
            if (string.equals(PackageUtil.getBundleTypeFromPath(Paths.get(string2, new String[0])))) continue;
            LOG.error("bundleType is not same");
            return false;
        }
        for (String string2 : list2) {
            if (string.equals(PackageUtil.getBundleTypeFromPath(Paths.get(string2, new String[0])))) continue;
            LOG.error("bundleType is not same");
            return false;
        }
        if (string.equals("shared")) {
            utility.setIsSharedApp(true);
        }
        return true;
    }

    private static boolean moduleJsonAndPackInfoExists(List<String> list, List<String> list2) {
        Path path;
        for (String string : list) {
            path = Paths.get(string, new String[0]);
            if (!Files.exists(path.resolve("module.json"), new LinkOption[0])) {
                LOG.error("not found module.json in path: " + path);
                return false;
            }
            if (Files.exists(path.resolve("pack.info"), new LinkOption[0])) continue;
            LOG.error("not found pack.info in path: " + path);
            return false;
        }
        for (String string : list2) {
            path = Paths.get(string, new String[0]);
            if (!Files.isDirectory(path, new LinkOption[0])) continue;
            if (!Files.exists(path.resolve("module.json"), new LinkOption[0])) {
                LOG.error("not found module.json in path: " + path);
                return false;
            }
            if (Files.exists(path.resolve("pack.info"), new LinkOption[0])) continue;
            LOG.error("not found pack.info in path: " + path);
            return false;
        }
        return true;
    }

    private static boolean isFileValid(String string, String string2) {
        Path path = Paths.get(string, new String[0]);
        return Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().endsWith(string2);
    }

    private static boolean isDirValid(String string) {
        return Files.isDirectory(Paths.get(string, new String[0]), new LinkOption[0]);
    }

    public static boolean isVerifyValidInFastAppMode(Utility utility) {
        if (!PackageUtil.isVerifyValid(utility)) {
            return false;
        }
        if (!(utility.getHapPath().isEmpty() || PackageUtil.isFormatPathValid(utility.getHapPath(), utility.getFormattedHapPathList()) && PackageUtil.isHapPathValid(utility.getFormattedHapPathList()))) {
            LOG.error("CompressVerify::isVerifyValidInFastAppMode hap-path is invalid.");
            return false;
        }
        if (!(utility.getHspPath().isEmpty() || PackageUtil.isFormatPathValid(utility.getHspPath(), utility.getFormattedHspPathList()) && PackageUtil.isHspPathValid(utility.getFormattedHspPathList()))) {
            LOG.error("CompressVerify::isVerifyValidInFastAppMode hsp-path is invalid.");
            return false;
        }
        if (utility.getHapPath().isEmpty() && utility.getHspPath().isEmpty()) {
            LOG.error("CompressVerify::isVerifyValidInFastAppMode hap-path and hsp-path is empty.");
            return false;
        }
        if (!PackageUtil.moduleJsonAndPackInfoExists(utility.getFormattedHapPathList(), utility.getFormattedHspPathList())) {
            LOG.error("CompressVerify::isVerifyValidInFastAppMode hap-path or hsp-path is invalid.");
            return false;
        }
        if (!PackageUtil.checkBundleTypeConsistency(utility.getFormattedHapPathList(), utility.getFormattedHspPathList(), utility)) {
            LOG.error("CompressVerify::isVerifyValidInFastAppMode bundleType is inconsistent.");
            return false;
        }
        if (!PackageUtil.isPackInfoValid(Paths.get(utility.getPackInfoPath(), new String[0]), utility.getFormattedHapPathList(), utility.getFormattedHspPathList())) {
            LOG.error("CompressVerify::isVerifyValidInFastAppMode pack.info is invalid.");
            return false;
        }
        if (!utility.getEncryptPath().isEmpty() && !PackageUtil.isFileValid(utility.getEncryptPath(), "encrypt.json")) {
            LOG.error("CompressVerify::isVerifyValidInFastAppMode encrypt-path is invalid.");
            return false;
        }
        Path path = Paths.get(utility.getOutPath(), new String[0]);
        if (utility.getForceRewrite().equals("false") && Files.exists(path, new LinkOption[0])) {
            LOG.error("CompressVerify::isVerifyValidInFastAppMode out file already existed.");
            return false;
        }
        if (!path.getFileName().toString().endsWith(".app")) {
            LOG.error("CompressVerify::isVerifyValidInFastAppMode out-path must end with .app.");
            return false;
        }
        return true;
    }

    private static boolean isVerifyValid(Utility utility) {
        if (utility.getPackInfoPath().isEmpty()) {
            LOG.error("CompressVerify::isArgsValidInAppMode pack-info-path is empty.");
            return false;
        }
        if (!PackageUtil.isFileValid(utility.getPackInfoPath(), "pack.info")) {
            LOG.error("CompressVerify::isVerifyValidInFastAppMode pack-info-path is invalid.");
            return false;
        }
        if (!utility.getSignaturePath().isEmpty() && !PackageUtil.isFileValid(utility.getSignaturePath(), "")) {
            LOG.error("CompressVerify::isVerifyValidInFastAppMode signature-path is invalid.");
            return false;
        }
        if (!utility.getCertificatePath().isEmpty() && !PackageUtil.isFileValid(utility.getCertificatePath(), "")) {
            LOG.error("CompressVerify::isVerifyValidInFastAppMode certificate-path is invalid.");
            return false;
        }
        if (!utility.getPackResPath().isEmpty() && !PackageUtil.isFileValid(utility.getPackResPath(), "pack.res")) {
            LOG.error("CompressVerify::isVerifyValidInFastAppMode pack-res-path is invalid.");
            return false;
        }
        if (!utility.getEntryCardPath().isEmpty() && !CompressVerify.compatibleProcess(utility, utility.getEntryCardPath(), utility.getformattedEntryCardPathList(), ".png")) {
            LOG.error("CompressVerify::isVerifyValidInFastAppMode entrycard-path is invalid.");
            return false;
        }
        if (utility.getOutPath().isEmpty()) {
            LOG.error("CompressVerify::isVerifyValidInFastAppMode out-path is empty.");
            return false;
        }
        return true;
    }

    private static boolean isHapPathValid(List<String> list) {
        for (String string : list) {
            if (PackageUtil.isDirValid(string)) continue;
            return false;
        }
        return true;
    }

    private static boolean isHspPathValid(List<String> list) {
        for (String string : list) {
            if (PackageUtil.isDirValid(string) || PackageUtil.isFileValid(string, ".hsp")) continue;
            return false;
        }
        return true;
    }

    private static boolean isFormatPathValid(String string, List<String> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : string.split(",")) {
            try {
                Path path = Paths.get(string2, new String[0]).toRealPath(new LinkOption[0]);
                if (!Files.exists(path, new LinkOption[0])) {
                    LOG.error("PackageUtil::formatPath not exists: " + path);
                    return false;
                }
                hashSet.add(path.toString());
            }
            catch (IOException iOException) {
                LOG.error("PackageUtil::formatPath err: " + iOException.getMessage());
                return false;
            }
        }
        list.addAll(hashSet);
        return true;
    }

    private static boolean isPackInfoValid(Path path, List<String> list, List<String> list2) {
        String string;
        List<String> list3;
        List<String> list4 = PackageUtil.getPackageNameFromPath(path);
        HashSet<String> hashSet = new HashSet<String>(list4);
        if (list4.size() > hashSet.size()) {
            LOG.error("package name is redundant in app pack.info: " + path);
            return false;
        }
        if (list4.isEmpty()) {
            LOG.error("app pack.info format err: " + path);
            return false;
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        for (String string2 : list) {
            list3 = PackageUtil.getPackageNameFromPath(Paths.get(string2, new String[0]));
            if (list3.size() != 1) {
                LOG.error("module pack.info format err: " + string2);
                return false;
            }
            string = list3.get(0);
            if (!list4.contains(string)) {
                LOG.error("module pack.info name not exist in app pack.info name list: " + string2);
                return false;
            }
            if (hashSet2.contains(string)) {
                LOG.error("package name is redundant in " + string2);
                return false;
            }
            hashSet2.add(string);
        }
        for (String string2 : list2) {
            list3 = PackageUtil.getPackageNameFromPath(Paths.get(string2, new String[0]));
            if (list3.size() != 1) {
                LOG.error("module pack.info format err: " + string2);
                return false;
            }
            string = list3.get(0);
            if (!list4.contains(string)) {
                LOG.error("module pack.info name not exist in app pack.info name list: " + string2);
                return false;
            }
            if (hashSet2.contains(string)) {
                LOG.error("package name is redundant in " + string2);
                return false;
            }
            hashSet2.add(string);
        }
        if (!hashSet.equals(hashSet2)) {
            LOG.error("package name not same between module and app pack.info.");
            return false;
        }
        return true;
    }
}

