/*
 * Decompiled with CFR 0.152.
 */
package ohos;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import ohos.BundleException;
import ohos.Log;
import ohos.Utility;
import org.apache.commons.compress.utils.IOUtils;

public class PackageNormalize {
    private static final Log LOG = new Log(PackageNormalize.class.toString());
    private static final int BUFFER_SIZE = 10240;
    private static final String MODULE_JSON = "module.json";
    private static final String PACK_INFO = "pack.info";
    private static final String APP = "app";
    private static final String SUMMARY = "summary";
    private static final String VERSION = "version";
    private static final String CODE = "code";
    private static final String BUNDLE_NAME = "bundleName";
    private static final String VERSION_CODE = "versionCode";
    private static final String TMP = "tmp";

    public static boolean normalize(Utility utility) {
        Path path = Paths.get(utility.getOutPath(), new String[0]);
        for (String string : utility.getFormattedHspPathList()) {
            try {
                PackageNormalize.normalize(Paths.get(string, new String[0]), path, utility.getBundleName(), utility.getVersionCode());
            }
            catch (BundleException bundleException) {
                LOG.error("PackageNormalize::normalize BundleException: " + bundleException.getMessage());
                return false;
            }
            catch (IOException iOException) {
                LOG.error("PackageNormalize::normalize IOException: " + iOException.getMessage());
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void normalize(Path path, Path path2, String string, int n) throws BundleException, IOException {
        Path path3 = path2.resolve(path.getFileName());
        Path path4 = Files.createTempDirectory(path2, TMP, new FileAttribute[0]);
        Path path5 = Files.createFile(path4.resolve(MODULE_JSON), new FileAttribute[0]);
        Path path6 = Files.createFile(path4.resolve(PACK_INFO), new FileAttribute[0]);
        try (ZipFile zipFile = new ZipFile(path.toFile());
             OutputStream outputStream = Files.newOutputStream(path3, new OpenOption[0]);
             ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);){
            Object object;
            Object object2;
            ZipEntry zipEntry = zipFile.getEntry(MODULE_JSON);
            if (zipEntry != null) {
                object2 = Files.newOutputStream(path5, new OpenOption[0]);
                object = null;
                try {
                    IOUtils.copy(zipFile.getInputStream(zipEntry), (OutputStream)object2);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (object2 != null) {
                        if (object != null) {
                            try {
                                ((OutputStream)object2).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((OutputStream)object2).close();
                        }
                    }
                }
            }
            object2 = zipFile.getEntry(PACK_INFO);
            if (zipEntry != null) {
                object = Files.newOutputStream(path6, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    IOUtils.copy(zipFile.getInputStream((ZipEntry)object2), (OutputStream)object);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((OutputStream)object).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((OutputStream)object).close();
                        }
                    }
                }
            }
            PackageNormalize.updateModuleJson(path5, string, n);
            PackageNormalize.updatePackInfo(path6, string, n);
            PackageNormalize.copyHsp(zipFile, path5, path6, zipOutputStream);
        }
        finally {
            PackageNormalize.rmdir(path4);
        }
    }

    private static void rmdir(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                Files.delete(path);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
                Files.delete(path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static void updateModuleJson(Path path, String string, int n) throws BundleException, IOException {
        try (FileInputStream fileInputStream = new FileInputStream(path.toFile());){
            JSONObject jSONObject = JSON.parseObject((InputStream)fileInputStream, JSONObject.class, new Feature[0]);
            if (jSONObject == null) {
                LOG.error("updateModuleJson failed, parse json is null.");
                throw new BundleException("updateModuleJson failed, parse json is null.");
            }
            if (!jSONObject.containsKey(APP)) {
                LOG.error("updateModuleJson failed, json format not invalid.");
                throw new BundleException("updateModuleJson failed, json format invalid.");
            }
            JSONObject jSONObject2 = jSONObject.getJSONObject(APP);
            jSONObject2.put(BUNDLE_NAME, (Object)string);
            jSONObject2.put(VERSION_CODE, (Object)n);
            Files.write(path, JSON.toJSONBytes((Object)jSONObject, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.SortField), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        }
    }

    private static void updatePackInfo(Path path, String string, int n) throws BundleException, IOException {
        try (FileInputStream fileInputStream = new FileInputStream(path.toFile());){
            JSONObject jSONObject = JSON.parseObject((InputStream)fileInputStream, JSONObject.class, new Feature[0]);
            if (jSONObject == null) {
                LOG.error("updatePackInfo failed, json format invalid.");
                throw new BundleException("updatePackInfo failed, json format invalid.");
            }
            JSONObject jSONObject2 = jSONObject.getJSONObject(SUMMARY);
            if (jSONObject2 == null) {
                LOG.error("updatePackInfo failed, json format invalid.");
                throw new BundleException("updatePackInfo failed, json format invalid.");
            }
            JSONObject jSONObject3 = jSONObject2.getJSONObject(APP);
            if (jSONObject3 == null) {
                LOG.error("updatePackInfo failed, json format invalid.");
                throw new BundleException("updatePackInfo failed, json format invalid.");
            }
            jSONObject3.put(BUNDLE_NAME, (Object)string);
            JSONObject jSONObject4 = jSONObject3.getJSONObject(VERSION);
            if (jSONObject4 == null) {
                LOG.error("updatePackInfo failed, json format invalid.");
                throw new BundleException("updatePackInfo failed, json format invalid.");
            }
            jSONObject4.put(CODE, (Object)n);
            Files.write(path, JSON.toJSONBytes((Object)jSONObject, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.SortField), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        }
    }

    private static void copyHsp(ZipFile zipFile, Path path, Path path2, ZipOutputStream zipOutputStream) throws BundleException, IOException {
        zipOutputStream.setLevel(1);
        boolean bl = true;
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (MODULE_JSON.equals(zipEntry.getName()) || PACK_INFO.equals(zipEntry.getName())) {
                bl = zipEntry.getMethod() == 0;
                continue;
            }
            ZipEntry zipEntry2 = zipEntry.getMethod() == 0 ? new ZipEntry(zipEntry) : new ZipEntry(zipEntry.getName());
            zipOutputStream.putNextEntry(zipEntry2);
            if (!zipEntry.isDirectory()) {
                IOUtils.copy(zipFile.getInputStream(zipEntry), (OutputStream)zipOutputStream);
            }
            zipOutputStream.closeEntry();
        }
        PackageNormalize.compressFile(path, bl, MODULE_JSON, zipOutputStream);
        PackageNormalize.compressFile(path2, bl, PACK_INFO, zipOutputStream);
    }

    private static void compressFile(Path path, boolean bl, String string, ZipOutputStream zipOutputStream) throws BundleException, IOException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            ZipEntry zipEntry;
            if (bl) {
                zipEntry = new ZipEntry(string);
                zipEntry.setMethod(0);
                File file = path.toFile();
                zipEntry.setCompressedSize(file.length());
                CRC32 cRC32 = PackageNormalize.getCrcFromFile(file);
                zipEntry.setCrc(cRC32.getValue());
                zipOutputStream.putNextEntry(zipEntry);
            } else {
                zipEntry = new ZipEntry(string);
                zipEntry.setMethod(8);
                zipOutputStream.putNextEntry(zipEntry);
            }
            IOUtils.copy(inputStream, (OutputStream)zipOutputStream);
            zipOutputStream.closeEntry();
        }
    }

    public static CRC32 getCrcFromFile(File file) throws BundleException {
        CRC32 cRC32 = new CRC32();
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            byte[] byArray = new byte[10240];
            int n = fileInputStream.read(byArray);
            while (n > 0) {
                cRC32.update(byArray, 0, n);
                n = fileInputStream.read(byArray);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOG.error("PackageNormalize::getCrcFromFile file not found exception: " + fileNotFoundException.getMessage());
            throw new BundleException("Get Crc from file failed.");
        }
        catch (IOException iOException) {
            LOG.error("PackageNormalize::getCrcFromFile io exception: " + iOException.getMessage());
            throw new BundleException("Get Crc from file failed, io exception.");
        }
        return cRC32;
    }
}

