/*
 * Decompiled with CFR 0.152.
 */
package ohos;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ohos.BundleException;
import ohos.DependencyItem;
import ohos.DistroFilter;
import ohos.FileUtils;
import ohos.HQFInfo;
import ohos.HapVerifyInfo;
import ohos.Log;
import ohos.ModuleApiVersion;
import ohos.ModuleMetadataInfo;
import ohos.MultiAppMode;
import ohos.PreloadItem;
import ohos.Version;

class ModuleJsonUtil {
    private static final String APP = "app";
    private static final String BUNDLE_TYPE = "bundleType";
    private static final String ASSETACCESSGROUPS = "assetAccessGroups";
    private static final String ABILITIES = "abilities";
    private static final String VERSIONCODE = "versionCode";
    private static final String VERSIONNAME = "versionName";
    private static final String MIN_COMPATIBLE_VERSION_CODE = "minCompatibleVersionCode";
    private static final String API_VERSION = "apiVersion";
    private static final String MIN_API_VERSION = "minAPIVersion";
    private static final String TARGET_API_VERSION = "targetAPIVersion";
    private static final String API_RELEASE_TYPE = "apiReleaseType";
    private static final String DEBUG = "debug";
    private static final String COMPATIBLE = "compatible";
    private static final String RELEASE_TYPE = "releaseType";
    private static final String TARGET = "target";
    private static final String VERSION = "version";
    private static final String CODE = "code";
    private static final String NAME = "name";
    private static final String SKILLS = "skills";
    private static final String SKILLS_ENTITIES = "entities";
    private static final String SKILLS_ACTIONS = "actions";
    private static final String ACTION_SYSTEM_HOME = "action.system.home";
    private static final String OHOS_WANT_ACTION_HOME = "ohos.want.action.home";
    private static final String ENTITY_SYSTEM_HOME = "entity.system.home";
    private static final String MODULE = "module";
    private static final String MODULES = "modules";
    private static final String MODULE_NAME = "moduleName";
    private static final String MODULE_TYPE = "moduleType";
    private static final String DISTRO = "distro";
    private static final String PACKAGE = "package";
    private static final String PACKAGES = "packages";
    private static final String SUMMARY = "summary";
    private static final String BUNDLE_NAME = "bundleName";
    private static final String ENTRY = "entry";
    private static final char DOT = '.';
    private static final String CONFIG_JSON = "config.json";
    private static final String MODULE_JSON = "module.json";
    private static final String DEVICE_TYPE = "deviceType";
    private static final String DEVICE_TYPES = "deviceTypes";
    private static final String TYPE = "type";
    private static final String VENDOR = "vendor";
    private static final String METADATA = "metadata";
    private static final String RESOURCE = "resource";
    private static final String PROFILE = "$profile:";
    private static final String VALUE = "value";
    private static final String JSON_PERFIX = ".json";
    private static final String DISTRO_FILTER = "distroFilter";
    private static final String DISTRIBUTION_FILTER = "distributionFilter";
    private static final String DEPENDENCIES = "dependencies";
    private static final String EXTENSION_ABILITIES = "extensionAbilities";
    private static final String INSTALLATION_FREE = "installationFree";
    private static final String PATCH_JSON = "patch.json";
    private static final String PATCH_VERSION_CODE = "patchVersionCode";
    private static final String PATCH_VERSION_NAME = "patchVersionName";
    private static final String ORIGINAL_MODULE_HASH = "originalModuleHash";
    private static final String EMPTY_STRING = "";
    private static final String COMPRESS_NATIVE_LIBS = "compressNativeLibs";
    private static final String ASAN_ENABLED = "asanEnabled";
    private static final String TSAN_ENABLED = "tsanEnabled";
    private static final String GWP_ASAN_ENABLED = "GWPAsanEnabled";
    private static final String HW_ASAN_ENABLED = "hwasanEnabled";
    private static final String UB_SAN_ENABLED = "ubsanEnabled";
    private static final String ATOMIC_SERVICE = "atomicService";
    private static final String SPLIT = "split";
    private static final String MAIN = "main";
    private static final String PRELOADS = "preloads";
    private static final String SHARED = "shared";
    private static final String APP_SERVICE = "appService";
    private static final String REQUEST_PERMISSIONS = "requestPermissions";
    private static final String TARGET_MODULE_NAME = "targetModuleName";
    private static final String TARGET_PRIORITY = "targetPriority";
    private static final String TARGET_BUNDLE_NAME = "targetBundleName";
    private static final String DEVICE_CONFIG = "deviceConfig";
    private static final String DEFAULT = "default";
    private static final String COMPILE_SDK_VERSION = "compileSdkVersion";
    private static final String COMPILE_SDK_TYPE = "compileSdkType";
    private static final String PROXY_DATAS = "proxyDatas";
    private static final String PROXY_DATA = "proxyData";
    private static final String PROXY_URI = "uri";
    private static final String CONTINUE_TYPE = "continueType";
    private static final String CONTINUE_BUNDLE_NAME = "continueBundleName";
    private static final String MULTI_APP_MODE = "multiAppMode";
    private static final String MULTI_APP_MODE_TYPE = "multiAppModeType";
    private static final String MULTI_APP_MODE_NUMBER = "maxCount";
    private static final String FORMS = "forms";
    private static final String DEFAULTDIMENSION = "defaultDimension";
    private static final String SUPPORTDIMENSIONS = "supportDimensions";
    private static final Log LOG = new Log(ModuleJsonUtil.class.toString());

    ModuleJsonUtil() {
    }

    public static Version parseStageVersion(String string) throws BundleException {
        Version version = new Version();
        JSONObject jSONObject = ModuleJsonUtil.getAppObj(string);
        if (!jSONObject.containsKey(VERSIONCODE) || !jSONObject.containsKey(VERSIONNAME)) {
            String string2 = "ModuleJsonUtil:parseStageVersion json file do not contain version.";
            LOG.error(string2);
            throw new BundleException(string2);
        }
        version.versionCode = jSONObject.getIntValue(VERSIONCODE);
        version.versionName = jSONObject.getString(VERSIONNAME);
        version.minCompatibleVersionCode = jSONObject.containsKey(MIN_COMPATIBLE_VERSION_CODE) ? jSONObject.getIntValue(MIN_COMPATIBLE_VERSION_CODE) : version.versionCode;
        return version;
    }

    public static Version parseFaVersion(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getAppObj(string);
        JSONObject jSONObject2 = jSONObject.getJSONObject(VERSION);
        if (jSONObject2 == null) {
            LOG.error("ModuleJsonUtil:parseFaVersion failed : json file do not version.");
            throw new BundleException("ModuleJsonUtil:parseFaVersion failed : json file do not version.");
        }
        Version version = new Version();
        if (!jSONObject2.containsKey(CODE) || !jSONObject2.containsKey(NAME)) {
            LOG.error("ModuleJsonUtil:parseFaVersion failed : json file do not version name or version code.");
            throw new BundleException("ModuleJsonUtil:parseFaVersion failed : json file do not version name or version code.");
        }
        version.versionName = jSONObject2.getString(NAME);
        version.versionCode = jSONObject2.getIntValue(CODE);
        version.minCompatibleVersionCode = jSONObject2.containsKey(MIN_COMPATIBLE_VERSION_CODE) ? jSONObject2.getIntValue(MIN_COMPATIBLE_VERSION_CODE) : version.versionCode;
        return version;
    }

    public static String parseFaBundleType(String string) throws BundleException {
        boolean bl = ModuleJsonUtil.parseFAInstallationFree(string);
        if (bl) {
            return ATOMIC_SERVICE;
        }
        return APP;
    }

    public static ModuleApiVersion parseStageModuleApiVersion(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getAppObj(string);
        ModuleApiVersion moduleApiVersion = new ModuleApiVersion();
        if (jSONObject.containsKey(MIN_API_VERSION)) {
            moduleApiVersion.setCompatibleApiVersion(jSONObject.getIntValue(MIN_API_VERSION));
        }
        if (jSONObject.containsKey(TARGET_API_VERSION)) {
            moduleApiVersion.setTargetApiVersion(jSONObject.getIntValue(TARGET_API_VERSION));
        }
        if (jSONObject.containsKey(API_RELEASE_TYPE)) {
            moduleApiVersion.setReleaseType(jSONObject.getString(API_RELEASE_TYPE));
        }
        return moduleApiVersion;
    }

    public static List<String> parseAssetAccessGroups(String string) throws BundleException {
        ArrayList<String> arrayList = new ArrayList<String>();
        JSONObject jSONObject = ModuleJsonUtil.getAppObj(string);
        if (jSONObject.containsKey(ASSETACCESSGROUPS)) {
            JSONArray jSONArray = jSONObject.getJSONArray(ASSETACCESSGROUPS);
            for (int i = 0; i < jSONArray.size(); ++i) {
                arrayList.add(jSONArray.getString(i));
            }
        }
        return arrayList;
    }

    public static ModuleApiVersion parseFAModuleApiVersion(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getAppObj(string);
        if (!jSONObject.containsKey(API_VERSION)) {
            LOG.error("ModuleJsonUtil::parseFAAPIVersion json file do not contain apiVersion.");
            throw new BundleException("ModuleJsonUtil::parseFAAPIVersion json file do not contain apiVersion.");
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject(API_VERSION);
        ModuleApiVersion moduleApiVersion = new ModuleApiVersion();
        if (jSONObject2.containsKey(COMPATIBLE)) {
            moduleApiVersion.setCompatibleApiVersion(jSONObject2.getIntValue(COMPATIBLE));
        }
        if (jSONObject2.containsKey(RELEASE_TYPE)) {
            moduleApiVersion.setReleaseType(jSONObject2.getString(RELEASE_TYPE));
        }
        if (jSONObject2.containsKey(TARGET)) {
            moduleApiVersion.setTargetApiVersion(jSONObject2.getIntValue(TARGET));
        }
        return moduleApiVersion;
    }

    public static String parseStageModuleName(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getModuleObj(string);
        if (!jSONObject.containsKey(NAME)) {
            LOG.error("ModuleJsonUtil:parseStageModuleName failed: json file do not contain module name.");
            throw new BundleException("ModuleJsonUtil:parseStageModuleName failed: json file do not contain module name.");
        }
        String string2 = jSONObject.getString(NAME);
        return string2;
    }

    public static String parseFaModuleName(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getModuleObj(string);
        JSONObject jSONObject2 = jSONObject.getJSONObject(DISTRO);
        if (jSONObject2 == null) {
            LOG.error("ModuleJsonUtil:parseFaModuleName failed: json file do not contain distro.");
            throw new BundleException("ModuleJsonUtil:parseFaModuleName failed: json file do not contain distro.");
        }
        if (!jSONObject2.containsKey(MODULE_NAME)) {
            LOG.error("ModuleJsonUtil:parseFaModuleName failed: json file do not contain moduleName.");
            throw new BundleException("ModuleJsonUtil:parseFaModuleName failed: json file do not contain moduleName.");
        }
        String string2 = jSONObject2.getString(MODULE_NAME);
        return string2;
    }

    public static String parsePatchModuleName(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getModuleObj(string);
        if (!jSONObject.containsKey(NAME)) {
            LOG.error("ModuleJsonUtil:parsePatchModuleName failed: json file do not contain moduleName.");
            throw new BundleException("ModuleJsonUtil:parsePatchModuleName failed: json file do not contain moduleName.");
        }
        String string2 = jSONObject.getString(NAME);
        return string2;
    }

    public static String parseFaPackageStr(String string) throws BundleException {
        String string2 = EMPTY_STRING;
        JSONObject jSONObject = ModuleJsonUtil.getModuleObj(string);
        if (!jSONObject.containsKey(PACKAGE)) {
            LOG.error("ModuleJsonUtil:parseFaPackageStr failed: json file do not contain package.");
            throw new BundleException("ModuleJsonUtil:parseFaPackageStr failed: json file do not contain package.");
        }
        string2 = jSONObject.getString(PACKAGE);
        return string2;
    }

    public static String parseBundleName(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getAppObj(string);
        String string2 = EMPTY_STRING;
        if (!jSONObject.containsKey(BUNDLE_NAME)) {
            LOG.error("ModuleJsonUtil::parseStageBundleName json object do not contain bundleNames.");
            throw new BundleException("ModuleJsonUtil::parseStageBundleName json object do not contain bundleNames.");
        }
        string2 = jSONObject.getString(BUNDLE_NAME);
        return string2;
    }

    public static String parseVendor(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getAppObj(string);
        String string2 = EMPTY_STRING;
        if (jSONObject.containsKey(VENDOR)) {
            string2 = jSONObject.getString(VENDOR);
        }
        return string2;
    }

    public static String mergeTwoPackInfo(String string, String string2) throws BundleException {
        String string3 = EMPTY_STRING;
        try {
            JSONObject jSONObject = JSON.parseObject(string);
            JSONObject jSONObject2 = JSON.parseObject(string2);
            if (!ModuleJsonUtil.verifyPackInfo(jSONObject, jSONObject2)) {
                LOG.error("ModuleJsonUtil:mergeTwoPackInfo verify pack.info failed.");
                throw new BundleException("ModuleJsonUtil:mergeTwoPackInfo verify pack.info failed.");
            }
            string3 = ModuleJsonUtil.mergePackInfoObj(jSONObject, jSONObject2);
        }
        catch (JSONException | BundleException exception) {
            LOG.error("ModuleJsonUtil:mergeTwoPackInfo merge pack.info failed: " + exception.getMessage());
            throw new BundleException("ModuleJsonUtil:mergeTwoPackInfo merge pack.info failed.");
        }
        return string3;
    }

    public static boolean verifyPackInfo(JSONObject jSONObject, JSONObject jSONObject2) throws BundleException {
        if (jSONObject == null || jSONObject2 == null) {
            LOG.error("ModuleJsonUtil:verifyPackInfo fail to read pack.info.");
            return false;
        }
        JSONObject jSONObject3 = jSONObject.getJSONObject(SUMMARY);
        JSONObject jSONObject4 = jSONObject2.getJSONObject(SUMMARY);
        if (jSONObject3 == null || jSONObject4 == null) {
            LOG.error("ModuleJsonUtil:verifyPackInfo pack.info do not contain summary.");
            return false;
        }
        JSONObject jSONObject5 = jSONObject3.getJSONObject(APP);
        JSONObject jSONObject6 = jSONObject4.getJSONObject(APP);
        if (jSONObject5 == null || jSONObject6 == null) {
            LOG.error("ModuleJsonUtil:verifyPackInfo pack.info do not contain app.");
            return false;
        }
        if (!ModuleJsonUtil.verifyAppInPackInfo(jSONObject5, jSONObject6)) {
            LOG.error("ModuleJsonUtil:verifyPackInfo verify app failed.");
            return false;
        }
        return true;
    }

    public static boolean verifyAppInPackInfo(JSONObject jSONObject, JSONObject jSONObject2) {
        int n;
        String string;
        if (jSONObject == null || jSONObject2 == null) {
            LOG.error("ModuleJsonUtil:verifyAppInPackInfo input null json object.");
            return false;
        }
        String string2 = jSONObject.getString(BUNDLE_NAME);
        if (!string2.equals(string = jSONObject2.getString(BUNDLE_NAME))) {
            LOG.error("ModuleJsonUtil:verifyAppInPackInfo bundleName is different.");
            return false;
        }
        if (!ModuleJsonUtil.checkBundleTypeInPackInfo(jSONObject, jSONObject2)) {
            LOG.error("ModuleJsonUtil:verifyAppInPackInfo bundleType is different.");
            return false;
        }
        JSONObject jSONObject3 = jSONObject.getJSONObject(VERSION);
        JSONObject jSONObject4 = jSONObject2.getJSONObject(VERSION);
        if (jSONObject3 == null || jSONObject4 == null) {
            LOG.error("ModuleJsonUtil:verifyAppInPackInfo version object is empty.");
            return false;
        }
        int n2 = jSONObject3.getIntValue(CODE);
        if (n2 != (n = jSONObject4.getIntValue(CODE))) {
            LOG.error("ModuleJsonUtil:verifyAppInPackInfo versionCode is different.");
            return false;
        }
        return true;
    }

    public static boolean checkBundleTypeInPackInfo(JSONObject jSONObject, JSONObject jSONObject2) {
        if (jSONObject.isEmpty() || jSONObject2.isEmpty()) {
            LOG.error("ModuleJsonUtil:checkBundleTypeInPackInfo pack.info has empty module.");
            return false;
        }
        String string = APP;
        String string2 = APP;
        if (jSONObject.containsKey(BUNDLE_TYPE)) {
            string = ModuleJsonUtil.getJsonString(jSONObject, BUNDLE_TYPE);
        }
        if (jSONObject2.containsKey(BUNDLE_TYPE)) {
            string2 = ModuleJsonUtil.getJsonString(jSONObject2, BUNDLE_TYPE);
        }
        if (!string.equals(string2)) {
            LOG.error("bundleType in pack.info is not same.");
            return false;
        }
        return true;
    }

    public static boolean verifyModuleInPackInfo(JSONArray jSONArray, JSONArray jSONArray2) throws BundleException {
        String string;
        JSONObject jSONObject;
        int n;
        if (jSONArray.isEmpty() || jSONArray2.isEmpty()) {
            LOG.error("ModuleJsonUtil:verifyModuleInPackInfo pack.info has empty module.");
            throw new BundleException("ModuleJsonUtil:verifyModuleInPackInfo pack.info has empty module.");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < jSONArray.size(); ++n) {
            jSONObject = jSONArray.getJSONObject(n);
            string = ModuleJsonUtil.parseDistroModuleName(jSONObject);
            if (arrayList.contains(string)) {
                LOG.error("ModuleJsonUtil:verifyModuleInPackInfo duplicated moduleName.");
                return false;
            }
            arrayList.add(string);
        }
        for (n = 0; n < jSONArray2.size(); ++n) {
            jSONObject = jSONArray2.getJSONObject(n);
            string = ModuleJsonUtil.parseDistroModuleName(jSONObject);
            if (arrayList.contains(string)) {
                LOG.error("ModuleJsonUtil:verifyModuleInPackInfo duplicated moduleName.");
                return false;
            }
            arrayList.add(string);
        }
        return true;
    }

    public static void parsePackInfoFormsName(String string, List<String> list, List<String> list2) throws BundleException {
        JSONObject jSONObject = JSONObject.parseObject(string);
        if (jSONObject == null || !jSONObject.containsKey(SUMMARY)) {
            LOG.error("ModuleJsonUtil::parsePackInfoFormsName error: summary is null.");
            throw new BundleException("Parse pack info forms name failed, summary is null.");
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject(SUMMARY);
        if (jSONObject2 == null || !jSONObject2.containsKey(MODULES)) {
            LOG.error("ModuleJsonUtil::parsePackInfoFormsName error: summary.modules is null.");
            return;
        }
        JSONArray jSONArray = jSONObject2.getJSONArray(MODULES);
        for (int i = 0; i < jSONArray.size(); ++i) {
            JSONObject jSONObject3 = jSONArray.getJSONObject(i);
            if (jSONObject3 == null || !jSONObject3.containsKey(DISTRO)) {
                LOG.error("ModuleJsonUtil::parsePackInfoFormsName error: summary.modules.distro is null.");
                continue;
            }
            JSONObject jSONObject4 = jSONObject3.getJSONObject(DISTRO);
            if (jSONObject4 == null || !jSONObject4.containsKey(MODULE_NAME)) {
                LOG.error("ModuleJsonUtil::parsePackInfoFormsName error: summary.modules.distro.moduleName is null.");
                continue;
            }
            String string2 = jSONObject4.getString(MODULE_NAME);
            ModuleJsonUtil.parsePackInfoExtensionAbility(string2, jSONObject3, list, list2);
        }
    }

    public static boolean verifyPackageName(JSONArray jSONArray, JSONArray jSONArray2) {
        String string;
        JSONObject jSONObject;
        int n;
        if (jSONArray == null || jSONArray.isEmpty() || jSONArray2 == null || jSONArray2.isEmpty()) {
            LOG.error("ModuleJsonUtil:verifyPackageName pack.info has empty packages.");
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < jSONArray.size(); ++n) {
            jSONObject = jSONArray.getJSONObject(n);
            string = jSONObject.getString(NAME);
            if (arrayList.contains(string)) {
                LOG.error("ModuleJsonUtil:verifyPackageName duplicated package name.");
                return false;
            }
            arrayList.add(string);
        }
        for (n = 0; n < jSONArray2.size(); ++n) {
            jSONObject = jSONArray2.getJSONObject(n);
            string = jSONObject.getString(NAME);
            if (arrayList.contains(string)) {
                LOG.error("ModuleJsonUtil:verifyPackageName duplicated package name.");
                return false;
            }
            arrayList.add(string);
        }
        return true;
    }

    public static String parseDistroModuleName(JSONObject jSONObject) throws BundleException {
        String string = EMPTY_STRING;
        try {
            if (jSONObject == null) {
                LOG.error("ModuleJsonUtil:parseFaModuleName failed: json file do not contain module.");
                throw new BundleException("ModuleJsonUtil:parseFaModuleName failed: json file do not contain module.");
            }
            JSONObject jSONObject2 = jSONObject.getJSONObject(DISTRO);
            if (jSONObject2 == null) {
                LOG.error("ModuleJsonUtil:parseFaModuleName failed: json file do not contain distro.");
                throw new BundleException("ModuleJsonUtil:parseFaModuleName failed: json file do not contain distro.");
            }
            if (!jSONObject2.containsKey(MODULE_NAME)) {
                LOG.error("ModuleJsonUtil:parseFaModuleName failed: json file do not contain moduleName.");
                throw new BundleException("ModuleJsonUtil:parseFaModuleName failed:json file do not contain moduleName.");
            }
            string = jSONObject2.getString(MODULE_NAME);
        }
        catch (BundleException bundleException) {
            LOG.error("ModuleJsonUtil:parseFaModuleName failed.");
            throw new BundleException("ModuleJsonUtil:parseFaModuleName failed.");
        }
        return string;
    }

    public static String mergePackInfoObj(JSONObject jSONObject, JSONObject jSONObject2) throws BundleException {
        if (jSONObject == null || jSONObject2 == null) {
            String string = "ModuleJsonUtil:mergePackInfoObj input an invalid json object.";
            LOG.error(string);
            throw new BundleException(string);
        }
        JSONObject jSONObject3 = jSONObject.getJSONObject(SUMMARY);
        JSONObject jSONObject4 = jSONObject2.getJSONObject(SUMMARY);
        if (jSONObject3 == null || jSONObject4 == null) {
            String string = "ModuleJsonUtil:mergePackInfoObj input json file has empty summary.";
            LOG.error(string);
            throw new BundleException(string);
        }
        JSONArray jSONArray = jSONObject3.getJSONArray(MODULES);
        JSONArray jSONArray2 = jSONObject4.getJSONArray(MODULES);
        if (jSONArray == null || jSONArray2 == null) {
            String string = "ModuleJsonUtil:mergePackInfoObj input json file has empty module.";
            LOG.error(string);
            throw new BundleException(string);
        }
        jSONArray.addAll((Collection)jSONArray2);
        JSONArray jSONArray3 = jSONObject.getJSONArray(PACKAGES);
        JSONArray jSONArray4 = jSONObject2.getJSONArray(PACKAGES);
        if (jSONArray3 == null || jSONArray4 == null) {
            String string = "ModuleJsonUtil:mergePackInfoObj input json file has empty packages.";
            LOG.error(string);
            throw new BundleException(string);
        }
        jSONArray3.addAll((Collection)jSONArray4);
        return jSONObject.toString();
    }

    public static String mergeTwoPackInfoByPackagePair(String string, String string2, HashMap<String, String> hashMap) throws BundleException {
        JSONObject jSONObject;
        JSONObject jSONObject2;
        try {
            jSONObject2 = JSON.parseObject(string);
            jSONObject = JSON.parseObject(string2);
        }
        catch (JSONException jSONException) {
            String string3 = "parse JSONObject failed: " + jSONException.getMessage();
            LOG.error(string3);
            throw new BundleException(string3);
        }
        JSONObject jSONObject3 = jSONObject2.getJSONObject(SUMMARY);
        JSONObject jSONObject4 = jSONObject3.getJSONObject(APP);
        JSONObject jSONObject5 = jSONObject.getJSONObject(SUMMARY);
        JSONObject jSONObject6 = jSONObject5.getJSONObject(APP);
        if (!ModuleJsonUtil.verifyAppInPackInfo(jSONObject4, jSONObject6)) {
            String string4 = "verify pack.info failed, different version, bundleType or bundleName.";
            LOG.error(string4);
            throw new BundleException(string4);
        }
        for (Map.Entry<String, String> entry : hashMap.entrySet()) {
            String string5 = entry.getKey().substring(0, entry.getKey().lastIndexOf(46));
            ModuleJsonUtil.mergeTwoPackInfoObjByPackagePair(jSONObject2, jSONObject, string5, entry.getValue());
        }
        return jSONObject2.toString();
    }

    public static void mergeTwoPackInfoObjByPackagePair(JSONObject jSONObject, JSONObject jSONObject2, String string, String string2) throws BundleException {
        Object object;
        JSON jSON;
        if (jSONObject == null || jSONObject2 == null) {
            String string3 = "ModuleJsonUtil:mergeTwoPackInfoObjByPackagePair failed: pack.info is not json object.";
            LOG.error(string3);
            throw new BundleException(string3);
        }
        JSONObject jSONObject3 = jSONObject.getJSONObject(SUMMARY);
        JSONObject jSONObject4 = jSONObject2.getJSONObject(SUMMARY);
        if (jSONObject3 == null || jSONObject4 == null) {
            String string4 = "ModuleJsonUtil:mergeTwoPackInfoObjByPackagePair failed: pack.info do not contain summary.";
            LOG.error(string4);
            throw new BundleException(string4);
        }
        JSONArray jSONArray = jSONObject3.getJSONArray(MODULES);
        JSONArray jSONArray2 = jSONObject4.getJSONArray(MODULES);
        if (jSONArray == null || jSONArray2 == null) {
            LOG.error("ModuleJsonUtil:mergeTwoPackInfoObjByPackagePair input json file has empty module.");
            throw new BundleException("ModuleJsonUtil:mergeTwoPackInfoObjByPackagePair input json file has empty module.");
        }
        boolean bl = false;
        for (int i = 0; i < jSONArray2.size(); ++i) {
            jSON = jSONArray2.getJSONObject(i);
            object = ((JSONObject)jSON).getJSONObject(DISTRO);
            if (!((JSONObject)object).getString(MODULE_NAME).equals(string2)) continue;
            jSONArray.add(jSON);
            bl = true;
            break;
        }
        if (!bl) {
            String string5 = "ModuleJsonUtil:mergeTwoPackInfoObjByPackagePair input json do not contain " + string2 + ".";
            LOG.error(string5);
            throw new BundleException(string5);
        }
        JSONArray jSONArray3 = jSONObject.getJSONArray(PACKAGES);
        jSON = jSONObject2.getJSONArray(PACKAGES);
        if (jSONArray3 == null || jSON == null) {
            object = "ModuleJsonUtil:mergeTwoPackInfoObjByPackagePair failed: pack.info do not contain packages.";
            LOG.error((String)object);
            throw new BundleException((String)object);
        }
        boolean bl2 = false;
        for (int i = 0; i < ((JSONArray)jSON).size(); ++i) {
            JSONObject jSONObject5 = ((JSONArray)jSON).getJSONObject(i);
            if (!jSONObject5.getString(NAME).equals(string)) continue;
            jSONArray3.add(jSONObject5);
            bl2 = true;
            break;
        }
        if (!bl2) {
            String string6 = "ModuleJsonUtil:mergeTwoPackInfoObjByPackagePair input json do not contain " + string + ".";
            LOG.error(string6);
            throw new BundleException(string6);
        }
    }

    public static List<String> parseFaEntry(String string) throws BundleException {
        JSONObject jSONObject;
        String string2 = FileUtils.getJsonInZips(new File(string), CONFIG_JSON);
        try {
            jSONObject = JSONObject.parseObject(string2);
        }
        catch (JSONException jSONException) {
            String string3 = "parse JSONobject failed.";
            LOG.error(string3);
            throw new BundleException(string3);
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject(MODULE);
        if (jSONObject2 == null) {
            String string4 = "ModuleJsonUtil::isFaEntry error, json do not contain module.";
            LOG.error(string4);
            throw new BundleException(string4);
        }
        List<String> list = new ArrayList<String>();
        JSONObject jSONObject3 = jSONObject2.getJSONObject(DISTRO);
        if (jSONObject3 == null) {
            String string5 = "ModuleJsonUtil::isFaEntry error, json do not contain distro.";
            LOG.error(string5);
            throw new BundleException(string5);
        }
        String string6 = jSONObject3.getString(MODULE_TYPE);
        if (ENTRY.equals(string6)) {
            list = ModuleJsonUtil.getDeviceTypeFromFAModule(jSONObject2);
        }
        return list;
    }

    public static List<String> parseStageEntry(String string) throws BundleException {
        JSONObject jSONObject;
        String string2 = FileUtils.getJsonInZips(new File(string), MODULE_JSON);
        try {
            jSONObject = JSONObject.parseObject(string2);
        }
        catch (JSONException jSONException) {
            String string3 = "parse JSONobject failed.";
            LOG.error(string3);
            throw new BundleException(string3);
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject(MODULE);
        if (jSONObject2 == null) {
            String string4 = "ModuleJsonUtil::isFaEntry error, json do not contain module.";
            LOG.error(string4);
            throw new BundleException(string4);
        }
        List<String> list = new ArrayList<String>();
        String string5 = jSONObject2.getString(TYPE);
        if (string5 != null && string5.equals(ENTRY)) {
            list = ModuleJsonUtil.getDeviceTypesFromStageModule(jSONObject2);
        }
        return list;
    }

    public static List<String> getDeviceTypeFromFAModule(JSONObject jSONObject) {
        List<String> list = new ArrayList<String>();
        if (jSONObject == null) {
            return list;
        }
        list = JSONObject.parseArray(ModuleJsonUtil.getJsonString(jSONObject, DEVICE_TYPE), String.class);
        return list;
    }

    public static List<String> getDeviceTypesFromStageModule(JSONObject jSONObject) {
        List<String> list = new ArrayList<String>();
        if (jSONObject == null) {
            return list;
        }
        list = JSONObject.parseArray(ModuleJsonUtil.getJsonString(jSONObject, DEVICE_TYPES), String.class);
        return list;
    }

    public static void parseStageHapVerifyInfo(HapVerifyInfo hapVerifyInfo) throws BundleException {
        if (hapVerifyInfo.getProfileStr().isEmpty()) {
            throw new BundleException("ModuleJsonUtil::parseStageHapVerifyInfo failed, module.json is empty.");
        }
        String string = ModuleJsonUtil.parseBundleName(hapVerifyInfo.getProfileStr());
        hapVerifyInfo.setBundleName(string);
        hapVerifyInfo.setVendor(ModuleJsonUtil.parseVendor(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setVersion(ModuleJsonUtil.parseStageVersion(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setApiVersion(ModuleJsonUtil.parseStageModuleApiVersion(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setAssetAccessGroups(ModuleJsonUtil.parseAssetAccessGroups(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setModuleName(ModuleJsonUtil.parseStageModuleName(hapVerifyInfo.getProfileStr()));
        List<ModuleMetadataInfo> list = ModuleJsonUtil.parseModuleAllMetadata(hapVerifyInfo.getProfileStr(), hapVerifyInfo.getResourceMap());
        hapVerifyInfo.setDistroFilter(ModuleJsonUtil.parseStageDistroFilter(list));
        hapVerifyInfo.setDeviceType(ModuleJsonUtil.parseDeviceType(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setAbilityNames(ModuleJsonUtil.parseAbilityNames(hapVerifyInfo.getProfileStr()));
        List<String> list2 = ModuleJsonUtil.parseExtensionAbilityName(hapVerifyInfo.getProfileStr());
        hapVerifyInfo.addAbilityNames(list2);
        hapVerifyInfo.setModuleType(ModuleJsonUtil.parseModuleType(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setDependencyItemList(ModuleJsonUtil.parseDependencies(hapVerifyInfo.getProfileStr(), string));
        hapVerifyInfo.setInstallationFree(ModuleJsonUtil.parseStageInstallation(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setBundleType(ModuleJsonUtil.parseStageBundleType(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setPreloadItems(ModuleJsonUtil.parseAtomicServicePreloads(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setTargetBundleName(ModuleJsonUtil.parseTargetBundleName(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setTargetPriority(ModuleJsonUtil.parseTargetPriority(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setTargetModuleName(ModuleJsonUtil.parseTargetModuleName(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setTargetModulePriority(ModuleJsonUtil.parseTargetModulePriority(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setDebug(ModuleJsonUtil.getDebug(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setCompileSdkType(ModuleJsonUtil.getCompileSdkType(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setCompileSdkVersion(ModuleJsonUtil.getCompileSdkVersion(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setProxyDataUris(ModuleJsonUtil.parseProxyDataUri(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setContinueTypeMap(ModuleJsonUtil.parseAbilityContinueTypeMap(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setMultiAppMode(ModuleJsonUtil.parseMultiAppMode(hapVerifyInfo.getProfileStr()));
    }

    public static void parseFAHapVerifyInfo(HapVerifyInfo hapVerifyInfo) throws BundleException {
        if (hapVerifyInfo.getProfileStr().isEmpty()) {
            LOG.error("ModuleJsonUtil::parseFAHapVerifyInfo failed, config.json is empty.");
            throw new BundleException("ModuleJsonUtil::parseFAHapVerifyInfo failed, config.json is empty.");
        }
        String string = ModuleJsonUtil.parseBundleName(hapVerifyInfo.getProfileStr());
        hapVerifyInfo.setBundleName(string);
        hapVerifyInfo.setBundleType(ModuleJsonUtil.parseFaBundleType(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setVendor(ModuleJsonUtil.parseVendor(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setVersion(ModuleJsonUtil.parseFaVersion(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setApiVersion(ModuleJsonUtil.parseFAModuleApiVersion(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setModuleName(ModuleJsonUtil.parseFaModuleName(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setDistroFilter(ModuleJsonUtil.parseFADistroFilter(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setDeviceType(ModuleJsonUtil.parseDeviceType(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setAbilityNames(ModuleJsonUtil.parseAbilityNames(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setModuleType(ModuleJsonUtil.parseFAIsEntry(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setPackageName(ModuleJsonUtil.parseFaPackageStr(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setDependencyItemList(ModuleJsonUtil.parseDependencies(hapVerifyInfo.getProfileStr(), string));
        hapVerifyInfo.setInstallationFree(ModuleJsonUtil.parseFAInstallationFree(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setDebug(ModuleJsonUtil.getFADebug(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setCompileSdkType(ModuleJsonUtil.getFACompileSdkType(hapVerifyInfo.getProfileStr()));
        hapVerifyInfo.setCompileSdkVersion(ModuleJsonUtil.getFACompileSdkVersion(hapVerifyInfo.getProfileStr()));
    }

    private static MultiAppMode parseMultiAppMode(String string) throws BundleException {
        MultiAppMode multiAppMode = new MultiAppMode();
        JSONObject jSONObject = ModuleJsonUtil.getAppObj(string);
        JSONObject jSONObject2 = jSONObject.getJSONObject(MULTI_APP_MODE);
        if (jSONObject2 != null) {
            String string2 = jSONObject2.getString(MULTI_APP_MODE_TYPE);
            Integer n = jSONObject2.getInteger(MULTI_APP_MODE_NUMBER);
            multiAppMode.setMultiAppModeType(string2 != null ? string2 : EMPTY_STRING);
            multiAppMode.setMaxCount(n != null ? n : 0);
        }
        return multiAppMode;
    }

    public static DistroFilter parseStageDistroFilter(List<ModuleMetadataInfo> list) {
        for (ModuleMetadataInfo moduleMetadataInfo : list) {
            String string = moduleMetadataInfo.resource;
            if (string.isEmpty()) continue;
            JSONObject jSONObject = JSONObject.parseObject(string);
            if (jSONObject.containsKey(DISTRIBUTION_FILTER)) {
                return JSONObject.parseObject(ModuleJsonUtil.getJsonString(jSONObject, DISTRIBUTION_FILTER), DistroFilter.class);
            }
            if (!jSONObject.containsKey(DISTRO_FILTER)) continue;
            return JSONObject.parseObject(ModuleJsonUtil.getJsonString(jSONObject, DISTRO_FILTER), DistroFilter.class);
        }
        return new DistroFilter();
    }

    public static List<ModuleMetadataInfo> parseModuleAllMetadata(String string, HashMap<String, String> hashMap) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getModuleObj(string);
        ArrayList<ModuleMetadataInfo> arrayList = new ArrayList<ModuleMetadataInfo>();
        if (jSONObject.containsKey(METADATA)) {
            JSONArray jSONArray = jSONObject.getJSONArray(METADATA);
            for (int i = 0; i < jSONArray.size(); ++i) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                arrayList.add(ModuleJsonUtil.parseModuleMetadata(jSONObject2, hashMap));
            }
        }
        return arrayList;
    }

    public static ModuleMetadataInfo parseModuleMetadata(JSONObject jSONObject, HashMap<String, String> hashMap) throws BundleException {
        if (jSONObject == null) {
            throw new BundleException("ModuleJsonUtil::parseModuleMetadata failed, jsonObject is null.");
        }
        ModuleMetadataInfo moduleMetadataInfo = new ModuleMetadataInfo();
        if (jSONObject.containsKey(NAME)) {
            moduleMetadataInfo.name = ModuleJsonUtil.getJsonString(jSONObject, NAME);
        }
        if (jSONObject.containsKey(VALUE)) {
            moduleMetadataInfo.value = ModuleJsonUtil.getJsonString(jSONObject, VALUE);
        }
        if (jSONObject.containsKey(RESOURCE)) {
            String string = moduleMetadataInfo.resource = ModuleJsonUtil.getJsonString(jSONObject, RESOURCE);
            string = string.replace(PROFILE, EMPTY_STRING);
            string = string + JSON_PERFIX;
            moduleMetadataInfo.resource = hashMap.get(string);
        }
        return moduleMetadataInfo;
    }

    public static DistroFilter parseFADistroFilter(String string) throws BundleException {
        DistroFilter distroFilter = new DistroFilter();
        try {
            JSONObject jSONObject;
            JSONObject jSONObject2 = JSON.parseObject(string);
            if (jSONObject2.containsKey(MODULE) && (jSONObject = jSONObject2.getJSONObject(MODULE)).containsKey(DISTRO_FILTER)) {
                distroFilter = JSONObject.parseObject(ModuleJsonUtil.getJsonString(jSONObject, DISTRO_FILTER), DistroFilter.class);
            }
        }
        catch (JSONException jSONException) {
            String string2 = "parse JSONObject failed: " + jSONException.getMessage();
            LOG.error(string2);
            throw new BundleException(string2);
        }
        return distroFilter;
    }

    public static List<String> parseDeviceType(String string) throws BundleException {
        ArrayList<String> arrayList = new ArrayList<String>();
        JSONObject jSONObject = ModuleJsonUtil.getModuleObj(string);
        if (jSONObject.containsKey(DEVICE_TYPE)) {
            return JSONObject.parseArray(ModuleJsonUtil.getJsonString(jSONObject, DEVICE_TYPE), String.class);
        }
        if (jSONObject.containsKey(DEVICE_TYPES)) {
            return JSONObject.parseArray(ModuleJsonUtil.getJsonString(jSONObject, DEVICE_TYPES), String.class);
        }
        return arrayList;
    }

    public static List<String> parseAbilityNames(String string) throws BundleException {
        ArrayList<String> arrayList = new ArrayList<String>();
        JSONObject jSONObject = ModuleJsonUtil.getModuleObj(string);
        if (jSONObject.containsKey(ABILITIES)) {
            JSONArray jSONArray = jSONObject.getJSONArray(ABILITIES);
            for (int i = 0; i < jSONArray.size(); ++i) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                if (!jSONObject2.containsKey(NAME)) continue;
                arrayList.add(ModuleJsonUtil.getJsonString(jSONObject2, NAME));
            }
        }
        return arrayList;
    }

    public static Map<String, List<String>> parseAbilityContinueTypeMap(String string) throws BundleException {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        JSONObject jSONObject = ModuleJsonUtil.getModuleObj(string);
        if (jSONObject.containsKey(ABILITIES)) {
            JSONArray jSONArray = jSONObject.getJSONArray(ABILITIES);
            for (int i = 0; i < jSONArray.size(); ++i) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                String string2 = ModuleJsonUtil.getJsonString(jSONObject2, NAME);
                if (jSONObject2.containsKey(CONTINUE_TYPE)) {
                    JSONArray jSONArray2 = jSONObject2.getJSONArray(CONTINUE_TYPE);
                    hashMap.put(string2, jSONArray2.toJavaList(String.class));
                    continue;
                }
                hashMap.put(string2, new ArrayList());
            }
        }
        return hashMap;
    }

    public static List<String> parseExtensionAbilityName(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getModuleObj(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (jSONObject.containsKey(EXTENSION_ABILITIES)) {
            JSONArray jSONArray = jSONObject.getJSONArray(EXTENSION_ABILITIES);
            for (int i = 0; i < jSONArray.size(); ++i) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                if (!jSONObject2.containsKey(NAME)) continue;
                arrayList.add(ModuleJsonUtil.getJsonString(jSONObject2, NAME));
            }
        }
        return arrayList;
    }

    public static Map<String, Boolean> parseAbilitySkillsMap(String string) throws BundleException {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        JSONObject jSONObject = ModuleJsonUtil.getModuleObj(string);
        JSONArray jSONArray = jSONObject.getJSONArray(ABILITIES);
        if (jSONArray == null) {
            return hashMap;
        }
        block0: for (int i = 0; i < jSONArray.size(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            String string2 = ModuleJsonUtil.getJsonString(jSONObject2, NAME);
            hashMap.put(string2, false);
            if (!jSONObject2.containsKey(SKILLS)) continue;
            JSONArray jSONArray2 = jSONObject2.getJSONArray(SKILLS);
            for (int j = 0; j < jSONArray2.size(); ++j) {
                JSONObject jSONObject3 = jSONArray2.getJSONObject(j);
                String string3 = ModuleJsonUtil.getJsonString(jSONObject3, SKILLS_ENTITIES);
                String string4 = ModuleJsonUtil.getJsonString(jSONObject3, SKILLS_ACTIONS);
                if (string3.contains(ENTITY_SYSTEM_HOME) && string4.contains(ACTION_SYSTEM_HOME)) {
                    hashMap.put(string2, true);
                    continue block0;
                }
                if (!string3.contains(ENTITY_SYSTEM_HOME) || !string4.contains(OHOS_WANT_ACTION_HOME)) continue;
                hashMap.put(string2, true);
                continue block0;
            }
        }
        return hashMap;
    }

    public static Map<String, Boolean> parseExtensionAbilitySkillsMap(String string) throws BundleException {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        JSONObject jSONObject = ModuleJsonUtil.getModuleObj(string);
        JSONArray jSONArray = jSONObject.getJSONArray(EXTENSION_ABILITIES);
        if (jSONArray == null) {
            return hashMap;
        }
        block0: for (int i = 0; i < jSONArray.size(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            String string2 = ModuleJsonUtil.getJsonString(jSONObject2, NAME);
            hashMap.put(string2, false);
            if (!jSONObject2.containsKey(SKILLS)) continue;
            JSONArray jSONArray2 = jSONObject2.getJSONArray(SKILLS);
            for (int j = 0; j < jSONArray2.size(); ++j) {
                JSONObject jSONObject3 = jSONArray2.getJSONObject(j);
                String string3 = ModuleJsonUtil.getJsonString(jSONObject3, SKILLS_ENTITIES);
                String string4 = ModuleJsonUtil.getJsonString(jSONObject3, SKILLS_ACTIONS);
                if (string3.contains(ENTITY_SYSTEM_HOME) && string4.contains(ACTION_SYSTEM_HOME)) {
                    hashMap.put(string2, true);
                    continue block0;
                }
                if (!string3.contains(ENTITY_SYSTEM_HOME) || !string4.contains(OHOS_WANT_ACTION_HOME)) continue;
                hashMap.put(string2, true);
                continue block0;
            }
        }
        return hashMap;
    }

    public static String parseModuleType(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getModuleObj(string);
        if (jSONObject.containsKey(TYPE)) {
            return ModuleJsonUtil.getJsonString(jSONObject, TYPE);
        }
        return EMPTY_STRING;
    }

    public static String parseFAIsEntry(String string) throws BundleException {
        JSONObject jSONObject;
        JSONObject jSONObject2 = ModuleJsonUtil.getModuleObj(string);
        if (jSONObject2.containsKey(DISTRO) && (jSONObject = jSONObject2.getJSONObject(DISTRO)).containsKey(MODULE_TYPE)) {
            return ModuleJsonUtil.getJsonString(jSONObject, MODULE_TYPE);
        }
        return EMPTY_STRING;
    }

    static List<DependencyItem> parseDependencies(String string, String string2) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getModuleObj(string);
        ArrayList<DependencyItem> arrayList = new ArrayList<DependencyItem>();
        if (!jSONObject.containsKey(DEPENDENCIES)) {
            return arrayList;
        }
        JSONArray jSONArray = jSONObject.getJSONArray(DEPENDENCIES);
        for (int i = 0; i < jSONArray.size(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            DependencyItem dependencyItem = new DependencyItem();
            if (jSONObject2.containsKey(BUNDLE_NAME)) {
                dependencyItem.setBundleName(jSONObject2.getString(BUNDLE_NAME));
            } else {
                dependencyItem.setBundleName(string2);
            }
            if (jSONObject2.containsKey(MODULE_NAME)) {
                dependencyItem.setModuleName(jSONObject2.getString(MODULE_NAME));
            }
            arrayList.add(dependencyItem);
        }
        return arrayList;
    }

    static boolean parseStageInstallation(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getModuleObj(string);
        if (jSONObject.containsKey(INSTALLATION_FREE)) {
            return jSONObject.getBoolean(INSTALLATION_FREE);
        }
        return false;
    }

    static String parseStageBundleType(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getModuleObj(string);
        String string2 = ModuleJsonUtil.parseStageModuleName(string);
        if (!jSONObject.containsKey(TYPE)) {
            String string3 = "parse failed, input module.json is invalid, module.json has no type in module: " + string2;
            LOG.error(string3);
            throw new BundleException(string3);
        }
        String string4 = jSONObject.getString(TYPE);
        boolean bl = ModuleJsonUtil.getJsonBooleanValue(jSONObject, INSTALLATION_FREE, false);
        JSONObject jSONObject2 = ModuleJsonUtil.getAppObj(string);
        if (!jSONObject2.containsKey(BUNDLE_TYPE)) {
            if (bl) {
                String string5 = "The app.json5 file configuration does not match the installationFree: true settings. Add the bundleType field to the app.json5 file and set it atomicService.";
                LOG.error(string5);
                throw new BundleException(string5);
            }
            return APP;
        }
        String string6 = ModuleJsonUtil.getJsonString(jSONObject2, BUNDLE_TYPE);
        if (string6.equals(APP)) {
            if (bl) {
                String string7 = "installationFree must be false in module(" + string2 + ") when bundleType is app.";
                LOG.error(string7);
                throw new BundleException(string7);
            }
            return APP;
        }
        if (string6.equals(ATOMIC_SERVICE)) {
            if (!bl) {
                String string8 = "installationFree must be true in module(" + string2 + ") when bundleType is atomicService.";
                LOG.error(string8);
                throw new BundleException(string8);
            }
            return ATOMIC_SERVICE;
        }
        if (SHARED.equals(string6)) {
            if (!SHARED.equals(string4)) {
                String string9 = "type must be shared in module(" + string2 + ") when bundleType is shared.";
                LOG.error(string9);
                throw new BundleException(string9);
            }
            return SHARED;
        }
        if (APP_SERVICE.equals(string6)) {
            return APP_SERVICE;
        }
        LOG.error("bundleType is invalid in app.json.");
        throw new BundleException("bundleType is invalid in app.json.");
    }

    static List<PreloadItem> parseAtomicServicePreloads(String string) throws BundleException {
        ArrayList<PreloadItem> arrayList = new ArrayList<PreloadItem>();
        JSONObject jSONObject = ModuleJsonUtil.getModuleObj(string);
        JSONObject jSONObject2 = null;
        if (!jSONObject.containsKey(ATOMIC_SERVICE)) {
            return arrayList;
        }
        jSONObject2 = jSONObject.getJSONObject(ATOMIC_SERVICE);
        if (!jSONObject2.containsKey(PRELOADS)) {
            return arrayList;
        }
        JSONArray jSONArray = jSONObject2.getJSONArray(PRELOADS);
        for (int i = 0; i < jSONArray.size(); ++i) {
            PreloadItem preloadItem = new PreloadItem();
            JSONObject jSONObject3 = jSONArray.getJSONObject(i);
            if (jSONObject3.containsKey(MODULE_NAME)) {
                preloadItem.setModuleName(ModuleJsonUtil.getJsonString(jSONObject3, MODULE_NAME));
            }
            arrayList.add(preloadItem);
        }
        return arrayList;
    }

    static List<String> parseProxyDataUri(String string) throws BundleException {
        ArrayList<String> arrayList = new ArrayList<String>();
        JSONObject jSONObject = ModuleJsonUtil.getModuleObj(string);
        if (!jSONObject.containsKey(PROXY_DATAS) && !jSONObject.containsKey(PROXY_DATA)) {
            return arrayList;
        }
        if (jSONObject.containsKey(PROXY_DATA)) {
            JSONArray jSONArray = jSONObject.getJSONArray(PROXY_DATA);
            for (int i = 0; i < jSONArray.size(); ++i) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                if (!jSONObject2.containsKey(PROXY_URI)) {
                    LOG.error("parse JOSNObject failed in parseProxyDataUri.");
                    throw new BundleException("parse JOSNObject failed in parseProxyDataUri.");
                }
                String string2 = jSONObject2.getString(PROXY_URI);
                arrayList.add(string2);
            }
        } else {
            JSONArray jSONArray = jSONObject.getJSONArray(PROXY_DATAS);
            for (int i = 0; i < jSONArray.size(); ++i) {
                JSONObject jSONObject3 = jSONArray.getJSONObject(i);
                if (!jSONObject3.containsKey(PROXY_URI)) {
                    LOG.error("parse JOSNObject failed in parseProxyDataUri.");
                    throw new BundleException("parse JOSNObject failed in parseProxyDataUri.");
                }
                String string3 = jSONObject3.getString(PROXY_URI);
                arrayList.add(string3);
            }
        }
        return arrayList;
    }

    static JSONObject getAppObj(String string) throws BundleException {
        JSONObject jSONObject;
        try {
            jSONObject = JSON.parseObject(string);
        }
        catch (JSONException jSONException) {
            String string2 = "parse JSONobject failed.";
            LOG.error(string2);
            throw new BundleException(string2);
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject(APP);
        if (jSONObject2 == null) {
            LOG.error("ModuleJsonUtil::parseStageInstallation json do not contain app.");
            throw new BundleException("ModuleJsonUtil::parseStageInstallation json do not contain app.");
        }
        return jSONObject2;
    }

    static JSONObject getModuleObj(String string) throws BundleException {
        JSONObject jSONObject;
        try {
            jSONObject = JSON.parseObject(string);
        }
        catch (JSONException jSONException) {
            String string2 = "parse JSONobject failed.";
            LOG.error(string2);
            throw new BundleException(string2);
        }
        if (jSONObject == null) {
            LOG.error("ModuleJsonUtil::parseStageInstallation jsonObj is null.");
            throw new BundleException("ModuleJsonUtil::parseStageInstallation jsonObj is null.");
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject(MODULE);
        if (jSONObject2 == null) {
            LOG.error("ModuleJsonUtil::parseStageInstallation json do not contain module.");
            throw new BundleException("ModuleJsonUtil::parseStageInstallation json do not contain module.");
        }
        return jSONObject2;
    }

    static String parseTargetBundleName(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getAppObj(string);
        String string2 = EMPTY_STRING;
        if (jSONObject.containsKey(TARGET_BUNDLE_NAME)) {
            string2 = jSONObject.getString(TARGET_BUNDLE_NAME);
        }
        return string2;
    }

    static int parseTargetPriority(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getAppObj(string);
        int n = 0;
        if (jSONObject.containsKey(TARGET_PRIORITY)) {
            n = jSONObject.getIntValue(TARGET_PRIORITY);
        }
        return n;
    }

    static String parseTargetModuleName(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getModuleObj(string);
        String string2 = EMPTY_STRING;
        if (jSONObject.containsKey(TARGET_MODULE_NAME)) {
            string2 = jSONObject.getString(TARGET_MODULE_NAME);
        }
        return string2;
    }

    static int parseTargetModulePriority(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getModuleObj(string);
        int n = 0;
        if (jSONObject.containsKey(TARGET_PRIORITY)) {
            n = jSONObject.getIntValue(TARGET_PRIORITY);
        }
        return n;
    }

    static boolean parseFAInstallationFree(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getModuleObj(string);
        JSONObject jSONObject2 = jSONObject.getJSONObject(DISTRO);
        if (jSONObject2 == null) {
            LOG.error("ModuleJsonUtil::parseStageInstallation json do not contain distro.");
            throw new BundleException("ModuleJsonUtil::parseStageInstallation json do not contain distro.");
        }
        if (jSONObject2.containsKey(INSTALLATION_FREE)) {
            return jSONObject2.getBoolean(INSTALLATION_FREE);
        }
        return false;
    }

    static HQFInfo parseHQFInfo(String string) throws BundleException {
        File file = new File(string);
        String string2 = FileUtils.getJsonInZips(file, PATCH_JSON);
        return ModuleJsonUtil.parsePatch(string2);
    }

    static HQFInfo parsePatch(String string) throws BundleException {
        JSONObject jSONObject;
        JSONObject jSONObject2 = ModuleJsonUtil.getAppObj(string);
        HQFInfo hQFInfo = new HQFInfo();
        if (jSONObject2.containsKey(BUNDLE_NAME)) {
            hQFInfo.setBundleName(jSONObject2.getString(BUNDLE_NAME));
        }
        if (jSONObject2.containsKey(VERSIONCODE)) {
            hQFInfo.setVersionCode(jSONObject2.getIntValue(VERSIONCODE));
        }
        if (jSONObject2.containsKey(VERSIONNAME)) {
            hQFInfo.setVersionName(jSONObject2.getString(VERSIONNAME));
        }
        if (jSONObject2.containsKey(PATCH_VERSION_CODE)) {
            hQFInfo.setPatchVersionCode(jSONObject2.getIntValue(PATCH_VERSION_CODE));
        }
        if (jSONObject2.containsKey(PATCH_VERSION_NAME)) {
            hQFInfo.setPatchVersionName(jSONObject2.getString(PATCH_VERSION_NAME));
        }
        if ((jSONObject = ModuleJsonUtil.getModuleObj(string)).containsKey(NAME)) {
            hQFInfo.setModuleName(jSONObject.getString(NAME));
        }
        if (jSONObject.containsKey(TYPE)) {
            hQFInfo.setType(jSONObject.getString(TYPE));
        }
        if (jSONObject.containsKey(DEVICE_TYPES)) {
            hQFInfo.setDeviceTypes(JSONObject.parseArray(ModuleJsonUtil.getJsonString(jSONObject, DEVICE_TYPES), String.class));
        }
        if (jSONObject.containsKey(ORIGINAL_MODULE_HASH)) {
            hQFInfo.setOriginalModuleHash(jSONObject.getString(ORIGINAL_MODULE_HASH));
        }
        return hQFInfo;
    }

    public static boolean stageIsCompressNativeLibs(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getModuleObj(string);
        if (jSONObject.containsKey(COMPRESS_NATIVE_LIBS)) {
            return jSONObject.getBoolean(COMPRESS_NATIVE_LIBS);
        }
        return false;
    }

    public static boolean getStageAsanEnabled(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getAppObj(string);
        if (jSONObject.containsKey(ASAN_ENABLED)) {
            return jSONObject.getBoolean(ASAN_ENABLED);
        }
        return false;
    }

    public static boolean getStageTsanEnabled(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getAppObj(string);
        if (jSONObject.containsKey(TSAN_ENABLED)) {
            return jSONObject.getBoolean(TSAN_ENABLED);
        }
        return false;
    }

    public static Map<String, List<String>> getAbilityContinueBundleNameMap(String string) throws BundleException {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        JSONObject jSONObject = ModuleJsonUtil.getModuleObj(string);
        if (jSONObject.containsKey(ABILITIES)) {
            JSONArray jSONArray = jSONObject.getJSONArray(ABILITIES);
            for (int i = 0; i < jSONArray.size(); ++i) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                String string2 = ModuleJsonUtil.getJsonString(jSONObject2, NAME);
                if (jSONObject2.containsKey(CONTINUE_BUNDLE_NAME)) {
                    JSONArray jSONArray2 = jSONObject2.getJSONArray(CONTINUE_BUNDLE_NAME);
                    hashMap.put(string2, jSONArray2.toJavaList(String.class));
                    continue;
                }
                hashMap.put(string2, new ArrayList());
            }
        }
        return hashMap;
    }

    public static boolean getStageGwpAsanEnabled(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getAppObj(string);
        if (jSONObject.containsKey(GWP_ASAN_ENABLED)) {
            return jSONObject.getBoolean(GWP_ASAN_ENABLED);
        }
        return false;
    }

    public static boolean getStageHwasanEnabled(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getAppObj(string);
        if (jSONObject.containsKey(HW_ASAN_ENABLED)) {
            return jSONObject.getBoolean(HW_ASAN_ENABLED);
        }
        return false;
    }

    public static boolean getStageUbsanEnabled(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getAppObj(string);
        if (jSONObject.containsKey(UB_SAN_ENABLED)) {
            return jSONObject.getBoolean(UB_SAN_ENABLED);
        }
        return false;
    }

    public static String getStageApiReleaseType(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getAppObj(string);
        return ModuleJsonUtil.getJsonString(jSONObject, API_RELEASE_TYPE);
    }

    public static boolean getDebug(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getAppObj(string);
        return ModuleJsonUtil.getJsonBooleanValue(jSONObject, DEBUG, false);
    }

    public static boolean getFADebug(String string) throws BundleException {
        JSONObject jSONObject;
        try {
            jSONObject = JSON.parseObject(string);
        }
        catch (JSONException jSONException) {
            LOG.error("parse JOSNObject failed in getStageApiReleaseType.");
            throw new BundleException("parse JOSNObject failed in getStageApiReleaseType.");
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject(DEVICE_CONFIG);
        if (jSONObject2 == null) {
            return false;
        }
        JSONObject jSONObject3 = jSONObject2.getJSONObject(DEFAULT);
        if (jSONObject3 == null) {
            return false;
        }
        return ModuleJsonUtil.getJsonBooleanValue(jSONObject3, DEBUG, false);
    }

    public static String getFACompileSdkVersion(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getAppObj(string);
        JSONObject jSONObject2 = jSONObject.getJSONObject(API_VERSION);
        String string2 = EMPTY_STRING;
        if (jSONObject2.containsKey(COMPILE_SDK_VERSION)) {
            string2 = jSONObject2.getString(COMPILE_SDK_VERSION);
        }
        return string2;
    }

    public static String getFACompileSdkType(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getAppObj(string);
        if (!jSONObject.containsKey(API_VERSION)) {
            throw new BundleException("ModuleJsonUtil::parseFAAPIVersion json file do not contain apiVersion.");
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject(API_VERSION);
        String string2 = EMPTY_STRING;
        if (jSONObject2.containsKey(COMPILE_SDK_TYPE)) {
            string2 = jSONObject2.getString(COMPILE_SDK_TYPE);
        }
        return string2;
    }

    public static String getCompileSdkVersion(String string) throws BundleException {
        String string2 = EMPTY_STRING;
        JSONObject jSONObject = ModuleJsonUtil.getAppObj(string);
        if (jSONObject.containsKey(COMPILE_SDK_VERSION)) {
            string2 = jSONObject.getString(COMPILE_SDK_VERSION);
        } else {
            LOG.warning("getCompileSdkType failed: json file do not contain module compileSdkVersion.");
        }
        return string2;
    }

    public static String getCompileSdkType(String string) throws BundleException {
        String string2 = EMPTY_STRING;
        JSONObject jSONObject = ModuleJsonUtil.getAppObj(string);
        if (jSONObject.containsKey(COMPILE_SDK_TYPE)) {
            string2 = jSONObject.getString(COMPILE_SDK_TYPE);
        } else {
            LOG.warning("getCompileSdkType failed: json file do not contain module compileSdkType.");
        }
        return string2;
    }

    public static String getStageTargetModuleName(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getModuleObj(string);
        return ModuleJsonUtil.getJsonString(jSONObject, TARGET_MODULE_NAME);
    }

    public static String getStageTargetBundleName(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getAppObj(string);
        return ModuleJsonUtil.getJsonString(jSONObject, TARGET_BUNDLE_NAME);
    }

    public static boolean isExistedStageRequestPermissions(String string) throws BundleException {
        return ModuleJsonUtil.isExistedProperty(string, MODULE, REQUEST_PERMISSIONS);
    }

    public static boolean isExistedStageModuleTargetPriority(String string) throws BundleException {
        return ModuleJsonUtil.isExistedProperty(string, MODULE, TARGET_PRIORITY);
    }

    public static boolean isExistedStageAppTargetPriority(String string) throws BundleException {
        return ModuleJsonUtil.isExistedProperty(string, APP, TARGET_PRIORITY);
    }

    private static boolean isExistedProperty(String string, String string2, String string3) throws BundleException {
        JSONObject jSONObject;
        try {
            jSONObject = JSON.parseObject(string);
        }
        catch (JSONException jSONException) {
            LOG.error("parse JOSNObject failed in isExistedProperty.");
            throw new BundleException("parse JOSNObject failed in isExistedProperty.");
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
        if (jSONObject2 == null) {
            LOG.error("parse failed, input module.json is invalid, module.json has no " + string2 + ".");
            throw new BundleException("parse failed, input module.json is invalid, module.json has no " + string2 + ".");
        }
        return jSONObject2.containsKey(string3);
    }

    public static boolean getFAAsanEnabled(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getAppObj(string);
        if (jSONObject.containsKey(ASAN_ENABLED)) {
            return jSONObject.getBoolean(ASAN_ENABLED);
        }
        return false;
    }

    public static String getFAReleaseType(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getAppObj(string);
        JSONObject jSONObject2 = jSONObject.getJSONObject(API_VERSION);
        if (jSONObject2 == null) {
            return EMPTY_STRING;
        }
        return ModuleJsonUtil.getJsonString(jSONObject2, RELEASE_TYPE);
    }

    public static boolean isModuleAtomicServiceValid(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getModuleObj(string);
        if (!jSONObject.containsKey(ATOMIC_SERVICE)) {
            return true;
        }
        JSONObject jSONObject2 = ModuleJsonUtil.getAppObj(string);
        if (!(!jSONObject.containsKey(ATOMIC_SERVICE) || jSONObject2.containsKey(BUNDLE_TYPE) && ModuleJsonUtil.getJsonString(jSONObject2, BUNDLE_TYPE).equals(ATOMIC_SERVICE))) {
            LOG.error("module can not config atomicService when bundleType is not atomicService.");
            return false;
        }
        return true;
    }

    public static boolean checkEntryInAtomicService(String string) throws BundleException {
        if (!ModuleJsonUtil.parseStageBundleType(string).equals(ATOMIC_SERVICE)) {
            return true;
        }
        if (ModuleJsonUtil.parseModuleType(string).equals(ENTRY) && ModuleJsonUtil.parseAbilityNames(string).isEmpty()) {
            LOG.error("entry module must contain at least one ability.");
            return false;
        }
        return true;
    }

    public static boolean checkAtomicServiceInstallationFree(String string) throws BundleException {
        JSONObject jSONObject = ModuleJsonUtil.getModuleObj(string);
        JSONObject jSONObject2 = ModuleJsonUtil.getAppObj(string);
        boolean bl = ModuleJsonUtil.getJsonBooleanValue(jSONObject, INSTALLATION_FREE, false);
        if (!jSONObject2.containsKey(BUNDLE_TYPE)) {
            if (bl) {
                String string2 = "The app.json5 file configuration does not match the installationFree: true settings. Add the bundleType field to the app.json5 file and set it atomicService.";
                LOG.error(string2);
                return false;
            }
            return true;
        }
        String string3 = ModuleJsonUtil.getJsonString(jSONObject2, BUNDLE_TYPE);
        if (string3.equals(APP)) {
            if (bl) {
                LOG.error("installationFree must be false when bundleType is app.");
                return false;
            }
        } else if (string3.equals(ATOMIC_SERVICE)) {
            if (!bl) {
                LOG.error("installationFree must be true when bundleType is atomicService.");
                return false;
            }
        } else if (SHARED.equals(string3)) {
            if (bl) {
                LOG.error("installationFree must be false when bundleType is shared.");
                return false;
            }
        } else if (APP_SERVICE.equals(string3)) {
            if (bl) {
                LOG.error("installationFree must be false when bundleType is appService.");
                return false;
            }
        } else {
            LOG.error("bundleType is invalid in app.json.");
            return false;
        }
        return true;
    }

    private static String getJsonString(JSONObject jSONObject, String string) {
        String string2 = EMPTY_STRING;
        if (jSONObject != null && jSONObject.containsKey(string) && jSONObject.get(string) != null) {
            string2 = jSONObject.get(string).toString();
        }
        return string2;
    }

    private static boolean getJsonBooleanValue(JSONObject jSONObject, String string, boolean bl) {
        boolean bl2 = bl;
        if (jSONObject != null && jSONObject.containsKey(string)) {
            bl2 = jSONObject.getBooleanValue(string);
        }
        return bl2;
    }

    private static int getCount(String string, char c) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            ++n;
        }
        return n;
    }

    private static void parsePackInfoExtensionAbility(String string, JSONObject jSONObject, List<String> list, List<String> list2) throws BundleException {
        if (!jSONObject.containsKey(EXTENSION_ABILITIES)) {
            LOG.warning("ModuleJsonUtil::parsePackInfoExtensionAbility error: summary.modules.extensionAbilities is null.");
            return;
        }
        JSONArray jSONArray = jSONObject.getJSONArray(EXTENSION_ABILITIES);
        for (int i = 0; i < jSONArray.size(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            if (jSONObject2 == null || !jSONObject2.containsKey(FORMS)) {
                LOG.warning("ModuleJsonUtil::parsePackInfoExtensionAbility error: summary.modules.extensionAbilities.forms is null.");
                continue;
            }
            ModuleJsonUtil.parsePackInfoForms(string, jSONObject2, list, list2);
        }
    }

    private static void parsePackInfoForms(String string, JSONObject jSONObject, List<String> list, List<String> list2) throws BundleException {
        JSONArray jSONArray = jSONObject.getJSONArray(FORMS);
        for (int i = 0; i < jSONArray.size(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            if (jSONObject2 == null || !jSONObject2.containsKey(NAME)) {
                LOG.warning("ModuleJsonUtil::parsePackInfoForms error: summary.modules.extensionAbilities.forms.name is null.");
                continue;
            }
            String string2 = jSONObject2.getString(NAME);
            list.add(string2);
            if (!jSONObject2.containsKey(DEFAULTDIMENSION)) {
                LOG.error("ModuleJsonUtil::parsePackInfoForms exception: summary.modules.extensionAbilities.forms.defaultDimension is null.");
                throw new BundleException("Parse pack info defaultDimension failed, defaultDimension is null.");
            }
            String string3 = jSONObject2.getString(DEFAULTDIMENSION);
            if (ModuleJsonUtil.getCount(string3, '*') != 1) {
                LOG.error("ModuleJsonUtil::parsePackInfoForms exception: summary.modules.extensionAbilities.forms.defaultDimension is not only 1.");
                throw new BundleException("Parse pack info defaultDimension failed, defaultDimension is not only 1.");
            }
            if (!jSONObject2.containsKey(SUPPORTDIMENSIONS)) {
                LOG.error("ModuleJsonUtil::parsePackInfoForms exception: summary.modules.extensionAbilities.forms.supportDimensions is null.");
                throw new BundleException("Parse pack info supportDimensions failed, supportDimensions is null.");
            }
            List<String> list3 = JSONObject.parseArray(ModuleJsonUtil.getJsonString(jSONObject2, SUPPORTDIMENSIONS), String.class);
            for (String string4 : list3) {
                String string5 = string + "/" + string2 + "-" + string4.replace("*", "x");
                list2.add(string5);
            }
        }
    }
}

