/*
 * Decompiled with CFR 0.152.
 */
package ohos;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ohos.ApiVersion;
import ohos.BundleException;
import ohos.CountryCode;
import ohos.DependencyItem;
import ohos.DistroFilter;
import ohos.HapVerifyInfo;
import ohos.Log;
import ohos.PreloadItem;
import ohos.ScreenDensity;
import ohos.ScreenShape;
import ohos.ScreenWindow;
import ohos.VerifyCollection;

class HapVerify {
    private static final String INCLUDE = "include";
    private static final String EXCLUDE = "exclude";
    private static final Log LOG = new Log(HapVerify.class.toString());
    private static final String EMPTY_STRING = "";
    private static final String ENTRY = "entry";
    private static final String FEATURE = "feature";
    private static final String SHARED_LIBRARY = "shared";
    private static final String HAR = "har";
    private static final String REFERENCE_LINK = "FAQ";
    private static final String ATOMIC_SERVICE = "atomicService";
    private static final String TYPE_SHARED = "shared";
    private static final long FILE_LENGTH_1M = 0x100000L;
    private static final double FILE_SIZE_OFFSET_DOUBLE = 0.01;
    private static final int FILE_SIZE_DECIMAL_PRECISION = 2;
    private static final String HAP_SUFFIX = ".hap";
    private static final String HSP_SUFFIX = ".hsp";

    HapVerify() {
    }

    public static boolean checkHapIsValid(List<HapVerifyInfo> list) throws BundleException {
        if (list == null || list.isEmpty()) {
            LOG.error("HapVerify::checkHapIsValid hapVerifyInfos is empty");
            return false;
        }
        if (!HapVerify.checkAppFieldsIsSame(list)) {
            LOG.error("some app variable is different.");
            return false;
        }
        if (!HapVerify.checkModuleNameIsValid(list)) {
            return false;
        }
        if (!HapVerify.checkPackageNameIsValid(list)) {
            LOG.error("packageName duplicated.");
            return false;
        }
        if (!HapVerify.checkEntryIsValid(list)) {
            return false;
        }
        if (!HapVerify.checkDependencyIsValid(list)) {
            LOG.error("module dependency is invalid.");
            return false;
        }
        if (!HapVerify.checkAtomicServiceIsValid(list)) {
            LOG.error("checkAtomicServiceIsValid failed.");
            return false;
        }
        if (!HapVerify.checkAbilityNameIsValid(list)) {
            LOG.info("Ability name is duplicated.");
        }
        if (!HapVerify.checkTargetModuleNameIsExisted(list)) {
            LOG.error("target module is not found.");
            return false;
        }
        if (!HapVerify.checkCompileSdkIsValid(list)) {
            LOG.error("compile sdk config is not same.");
            return false;
        }
        if (!HapVerify.checkProxyDataUriIsUnique(list)) {
            LOG.error("uris in proxy data are not unique.");
            return false;
        }
        return HapVerify.checkContinueTypeIsValid(list);
    }

    private static boolean checkContinueTypeIsValid(List<HapVerifyInfo> list) {
        for (HapVerifyInfo hapVerifyInfo : list) {
            if (HapVerify.checkContinueTypeIsValid(hapVerifyInfo)) continue;
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            for (int j = i + 1; j < list.size(); ++j) {
                if (HapVerify.checkContinueTypeIsValid(list.get(i), list.get(j))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean checkContinueTypeIsValid(HapVerifyInfo hapVerifyInfo) {
        List<String> list = hapVerifyInfo.getAbilityNames();
        if (list.size() < 2) {
            return true;
        }
        for (int i = 0; i < list.size(); ++i) {
            List<String> list2 = hapVerifyInfo.getContinueTypeMap().get(list.get(i));
            if (list2 == null) continue;
            for (int j = i + 1; j < list.size(); ++j) {
                List<String> list3 = hapVerifyInfo.getContinueTypeMap().get(list.get(j));
                if (list3 == null || Collections.disjoint(list2, list3)) continue;
                LOG.error("Module: (" + hapVerifyInfo.getModuleName() + "), Ability: (" + list.get(i) + ") and Ability: (" + list.get(j) + ") have same continueType.");
                LOG.error("Ability: (" + list.get(i) + ") have continueType: " + list2);
                LOG.error("Another Ability: (" + list.get(j) + ") have continueType: " + list3);
                return false;
            }
        }
        return true;
    }

    private static boolean checkContinueTypeIsValid(HapVerifyInfo hapVerifyInfo, HapVerifyInfo hapVerifyInfo2) {
        List list;
        if (Collections.disjoint(hapVerifyInfo.getDeviceType(), hapVerifyInfo2.getDeviceType())) {
            return true;
        }
        List list2 = hapVerifyInfo.getContinueTypeMap().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        if (!Collections.disjoint(list2, list = hapVerifyInfo2.getContinueTypeMap().values().stream().flatMap(Collection::stream).collect(Collectors.toList()))) {
            LOG.error("Module: (" + hapVerifyInfo.getModuleName() + ") and Module: (" + hapVerifyInfo2.getModuleName() + ") have same deviceType and continueType.");
            LOG.error("Module: (" + hapVerifyInfo.getModuleName() + ") have deviceType: " + hapVerifyInfo.getDeviceType() + " and continueType: " + list2);
            LOG.error("Another Module: (" + hapVerifyInfo2.getModuleName() + ") have deviceType: " + hapVerifyInfo2.getDeviceType() + " and continueType: " + list);
            return false;
        }
        return true;
    }

    public static boolean checkSharedApppIsValid(List<HapVerifyInfo> list) throws BundleException {
        if (list == null || list.isEmpty()) {
            LOG.error("HapVerify::checkSharedApppIsValid hapVerifyInfos is empty.");
            return false;
        }
        String string = list.get(0).getModuleName();
        for (HapVerifyInfo hapVerifyInfo : list) {
            if (!string.equals(hapVerifyInfo.getModuleName())) {
                LOG.error("HapVerify::checkSharedApppIsValid module name is different.");
                return false;
            }
            if (!hapVerifyInfo.getDependencyItemList().isEmpty()) {
                LOG.error("HapVerify::checkSharedApppIsValid shared hsp cannot depend on other modules.");
                return false;
            }
            if ("shared".equals(hapVerifyInfo.getModuleType())) continue;
            LOG.error("HapVerify::checkSharedApppIsValid module type is not shared app.");
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            for (int j = i + 1; j < list.size(); ++j) {
                if (HapVerify.checkDuplicatedIsValid(list.get(i), list.get(j))) continue;
                LOG.error("HapVerify::checkSharedApppIsValid duplicated module.");
                return false;
            }
        }
        return true;
    }

    private static boolean checkAppFieldsIsSame(List<HapVerifyInfo> list) {
        if (list.isEmpty()) {
            LOG.error("HapVerify::checkAppVariableIsSame failed, hapVerifyInfos is empty.");
            return false;
        }
        HapVerifyInfo hapVerifyInfo2 = list.get(0);
        Optional<HapVerifyInfo> optional = list.stream().filter(hapVerifyInfo -> !hapVerifyInfo.getModuleType().equals("shared")).findFirst();
        if (optional.isPresent()) {
            hapVerifyInfo2 = optional.get();
        }
        ArrayList<HapVerifyInfo> arrayList = new ArrayList<HapVerifyInfo>();
        int n = -1;
        int n2 = -1;
        VerifyCollection verifyCollection = new VerifyCollection();
        verifyCollection.bundleName = hapVerifyInfo2.getBundleName();
        verifyCollection.setBundleType(hapVerifyInfo2.getBundleType());
        verifyCollection.vendor = hapVerifyInfo2.getVendor();
        verifyCollection.versionCode = hapVerifyInfo2.getVersion().versionCode;
        verifyCollection.versionName = hapVerifyInfo2.getVersion().versionName;
        verifyCollection.compatibleApiVersion = hapVerifyInfo2.getApiVersion().getCompatibleApiVersion();
        verifyCollection.releaseType = hapVerifyInfo2.getApiVersion().getReleaseType();
        verifyCollection.targetBundleName = hapVerifyInfo2.getTargetBundleName();
        verifyCollection.targetPriority = hapVerifyInfo2.getTargetPriority();
        verifyCollection.debug = hapVerifyInfo2.isDebug();
        verifyCollection.setModuleName(hapVerifyInfo2.getModuleName());
        verifyCollection.setModuleType(hapVerifyInfo2.getModuleType());
        verifyCollection.setMultiAppMode(hapVerifyInfo2.getMultiAppMode());
        List<String> list2 = hapVerifyInfo2.getAssetAccessGroups();
        String string = hapVerifyInfo2.getModuleName();
        Optional<HapVerifyInfo> optional2 = list.stream().filter(hapVerifyInfo -> ENTRY.equals(hapVerifyInfo.getModuleType())).findFirst();
        if (optional2.isPresent()) {
            string = optional2.get().getModuleName();
            list2 = optional2.get().getAssetAccessGroups();
        }
        for (HapVerifyInfo hapVerifyInfo3 : list) {
            if (!HapVerify.appFieldsIsSame(verifyCollection, hapVerifyInfo3)) {
                LOG.warning("Module: (" + verifyCollection.getModuleName() + ") and Module: (" + hapVerifyInfo3.getModuleName() + ") has different values.");
                return false;
            }
            if (!HapVerify.appAssetAccessGroupsIsSame(list2, hapVerifyInfo3)) {
                LOG.warning("Module: (" + string + ") and Module: (" + hapVerifyInfo3.getModuleName() + ") has different values.");
            }
            if (hapVerifyInfo3.getFileType() == HAP_SUFFIX) {
                arrayList.add(hapVerifyInfo3);
                continue;
            }
            if (hapVerifyInfo3.getFileType() != HSP_SUFFIX) continue;
            if (hapVerifyInfo3.getVersion().minCompatibleVersionCode > n) {
                n = hapVerifyInfo3.getVersion().minCompatibleVersionCode;
            }
            if (hapVerifyInfo3.getApiVersion().getTargetApiVersion() <= n2) continue;
            n2 = hapVerifyInfo3.getApiVersion().getTargetApiVersion();
        }
        return HapVerify.appFieldsIsValid(arrayList, n, n2);
    }

    private static boolean appFieldsIsValid(List<HapVerifyInfo> list, int n, int n2) {
        if (list.isEmpty()) {
            LOG.warning("hapList empty");
            return true;
        }
        HapVerifyInfo hapVerifyInfo = list.get(0);
        for (HapVerifyInfo hapVerifyInfo2 : list) {
            if (hapVerifyInfo.getVersion().minCompatibleVersionCode == hapVerifyInfo2.getVersion().minCompatibleVersionCode && hapVerifyInfo.getApiVersion().getTargetApiVersion() == hapVerifyInfo2.getApiVersion().getTargetApiVersion()) continue;
            LOG.error("hap minCompatibleVersionCode or targetApiVersion different");
            return false;
        }
        if (hapVerifyInfo.getVersion().minCompatibleVersionCode < n || hapVerifyInfo.getApiVersion().getTargetApiVersion() < n2) {
            LOG.error("minCompatibleVersionCode or targetApiVersion property hap less than hsp");
            return false;
        }
        return true;
    }

    private static boolean appFieldsIsSame(VerifyCollection verifyCollection, HapVerifyInfo hapVerifyInfo) {
        if (hapVerifyInfo.getBundleName().isEmpty() || !verifyCollection.bundleName.equals(hapVerifyInfo.getBundleName())) {
            LOG.error("input module bundleName is different.");
            return false;
        }
        if (!verifyCollection.getBundleType().equals(hapVerifyInfo.getBundleType())) {
            LOG.error("input module bundleType is different.");
            return false;
        }
        if (verifyCollection.versionCode != hapVerifyInfo.getVersion().versionCode) {
            LOG.error("input module versionCode is different.");
            return false;
        }
        if (verifyCollection.compatibleApiVersion != hapVerifyInfo.getApiVersion().getCompatibleApiVersion()) {
            LOG.error("input module minApiVersion is different.");
            return false;
        }
        if (!verifyCollection.releaseType.equals(hapVerifyInfo.getApiVersion().getReleaseType())) {
            if (verifyCollection.getModuleType().equals("shared") || hapVerifyInfo.getModuleType().equals("shared")) {
                LOG.warning("Module: (" + verifyCollection.getModuleName() + ") and Module: (" + hapVerifyInfo.getModuleName() + ") has different releaseType.");
            } else {
                LOG.error("input module releaseType is different.");
                LOG.error("Solutions: > Check if the releaseType is the same in different modules.");
                return false;
            }
        }
        if (!verifyCollection.targetBundleName.equals(hapVerifyInfo.getTargetBundleName())) {
            LOG.error("targetBundleName is different.");
            return false;
        }
        if (verifyCollection.targetPriority != hapVerifyInfo.getTargetPriority()) {
            LOG.error("targetPriority is different.");
            return false;
        }
        if (verifyCollection.debug != hapVerifyInfo.isDebug()) {
            LOG.error("debug is different.");
            LOG.error("Solutions: > Check if the debug type is the same in different modules.");
            return false;
        }
        if (HapVerify.isEntryOrFeature(verifyCollection.getModuleType()) && HapVerify.isEntryOrFeature(hapVerifyInfo.getModuleType()) && !verifyCollection.getMultiAppMode().equals(hapVerifyInfo.getMultiAppMode())) {
            LOG.error("multiAppMode is different.");
            return false;
        }
        return true;
    }

    private static boolean appAssetAccessGroupsIsSame(List<String> list, HapVerifyInfo hapVerifyInfo) {
        if (!new HashSet<String>(list).equals(new HashSet<String>(hapVerifyInfo.getAssetAccessGroups()))) {
            LOG.warning("input module assetAccessGroups is different.");
            return false;
        }
        return true;
    }

    private static boolean isEntryOrFeature(String string) {
        return ENTRY.equals(string) || FEATURE.equals(string);
    }

    private static boolean checkModuleNameIsValid(List<HapVerifyInfo> list) throws BundleException {
        for (int i = 0; i < list.size() - 1; ++i) {
            if (list.get(i).getModuleName().isEmpty()) {
                LOG.error("HapVerify::checkModuleNameIsValid should not be empty.");
                throw new BundleException("HapVerify::checkModuleNameIsValid should not be empty.");
            }
            for (int j = i + 1; j < list.size(); ++j) {
                if (!list.get(i).getModuleName().equals(list.get(j).getModuleName()) || HapVerify.checkDuplicatedIsValid(list.get(i), list.get(j))) continue;
                LOG.error("Module: (" + list.get(i).getModuleName() + ") and Module: (" + list.get(j).getModuleName() + ") have the same moduleName, please check deviceType or distroFilter of the module.");
                LOG.error("Module: " + list.get(i).getModuleName() + " has deviceType " + list.get(i).getDeviceType() + ".");
                LOG.error("Another Module: " + list.get(j).getModuleName() + " has deviceType " + list.get(j).getDeviceType() + ".");
                if (!EMPTY_STRING.equals(list.get(i).getDistroFilter().dump())) {
                    LOG.error("Module: " + list.get(i).getModuleName() + " DistroFilter is : " + list.get(i).getDistroFilter().dump() + ".");
                }
                if (!EMPTY_STRING.equals(list.get(j).getDistroFilter().dump())) {
                    LOG.error("Another Module: " + list.get(j).getModuleName() + " DistroFilter is " + list.get(j).getDistroFilter().dump() + ".");
                }
                LOG.error("Solution: Make sure the module name is valid and unique.");
                LOG.error("Reference: FAQ.");
                return false;
            }
        }
        return true;
    }

    private static boolean checkPackageNameIsValid(List<HapVerifyInfo> list) throws BundleException {
        for (int i = 0; i < list.size() - 1; ++i) {
            if (list.get(i).getPackageName().isEmpty()) continue;
            for (int j = i + 1; j < list.size(); ++j) {
                if (!list.get(i).getPackageName().equals(list.get(j).getPackageName()) || HapVerify.checkDuplicatedIsValid(list.get(i), list.get(j))) continue;
                LOG.error("Module: (" + list.get(i).getModuleName() + ") and Module: (" + list.get(j).getModuleName() + ") have the same packageName, please check deviceType or distroFilter of the module.");
                LOG.error("Module: " + list.get(i).getModuleName() + " has deviceType " + list.get(i).getDeviceType() + ".");
                LOG.error("Another Module: " + list.get(j).getModuleName() + " has deviceType " + list.get(j).getDeviceType() + ".");
                if (!EMPTY_STRING.equals(list.get(i).getDistroFilter().dump())) {
                    LOG.error("Module: " + list.get(i).getModuleName() + " DistroFilter is : " + list.get(i).getDistroFilter().dump() + ".");
                }
                if (!EMPTY_STRING.equals(list.get(j).getDistroFilter().dump())) {
                    LOG.error("Another Module: " + list.get(j).getModuleName() + " DistroFilter is " + list.get(j).getDistroFilter().dump() + ".");
                }
                LOG.error("Solution: Make sure package name is valid and unique.");
                LOG.error("Reference: FAQ.");
                return false;
            }
        }
        return true;
    }

    private static boolean checkAbilityNameIsValid(List<HapVerifyInfo> list) throws BundleException {
        for (HapVerifyInfo hapVerifyInfo : list) {
            long l = hapVerifyInfo.getAbilityNames().stream().distinct().count();
            if (l == (long)hapVerifyInfo.getAbilityNames().size()) continue;
            LOG.warning(hapVerifyInfo.getModuleName() + " ability duplicated, please rename ability name.");
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getAbilityNames().isEmpty()) continue;
            for (int j = i + 1; j < list.size(); ++j) {
                if (Collections.disjoint(list.get(i).getAbilityNames(), list.get(j).getAbilityNames()) || HapVerify.checkDuplicatedIsValid(list.get(i), list.get(j))) continue;
                LOG.warning("Module: (" + list.get(i).getModuleName() + ") and Module: (" + list.get(j).getModuleName() + ") have the same ability name.");
                LOG.warning("Module: " + list.get(i).getModuleName() + " has ability " + list.get(i).getAbilityNames() + ".");
                LOG.warning("Module: " + list.get(j).getModuleName() + " has ability " + list.get(j).getAbilityNames() + ".");
                LOG.warning("Solution: Make sure ability name is valid and unique.");
                LOG.warning("Reference: FAQ.");
                return false;
            }
        }
        return true;
    }

    private static boolean checkTargetModuleNameIsExisted(List<HapVerifyInfo> list) throws BundleException {
        ArrayList<HapVerifyInfo> arrayList = new ArrayList<HapVerifyInfo>();
        ArrayList<HapVerifyInfo> arrayList2 = new ArrayList<HapVerifyInfo>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        for (HapVerifyInfo hapVerifyInfo : list) {
            if (!hapVerifyInfo.getTargetBundleName().isEmpty()) {
                return true;
            }
            if (!hapVerifyInfo.getTargetModuleName().isEmpty()) {
                arrayList.add(hapVerifyInfo);
                arrayList3.add(hapVerifyInfo.getTargetModuleName());
                continue;
            }
            arrayList2.add(hapVerifyInfo);
            if ("shared".equals(hapVerifyInfo.getModuleType())) continue;
            arrayList4.add(hapVerifyInfo.getModuleName());
        }
        if (arrayList.isEmpty()) {
            return true;
        }
        if (arrayList2.isEmpty()) {
            LOG.error("target modules are needed to pack with overlay module.");
            return false;
        }
        if (!arrayList4.containsAll(arrayList3)) {
            LOG.error("target modules are needed to pack with overlay module.");
            return false;
        }
        return true;
    }

    private static boolean checkCompileSdkIsValid(List<HapVerifyInfo> list) throws BundleException {
        if (list.isEmpty()) {
            LOG.error("hapVerifyInfos is empty");
            return false;
        }
        String string = list.get(0).getCompileSdkType();
        for (HapVerifyInfo hapVerifyInfo : list) {
            if (string.equals(hapVerifyInfo.getCompileSdkType())) continue;
            LOG.error("compile sdk type is not same.");
            return false;
        }
        return true;
    }

    private static boolean checkProxyDataUriIsUnique(List<HapVerifyInfo> list) throws BundleException {
        if (list.isEmpty()) {
            LOG.error("hapVerifyInfos is empty");
            return false;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (HapVerifyInfo hapVerifyInfo : list) {
            for (String string : hapVerifyInfo.getProxyDataUris()) {
                if (hashSet.contains(string)) {
                    LOG.error("uri " + string + " in proxy data is duplicated");
                    LOG.error("Solutions: > Check if the uri in proxyData is unique in different modules.");
                    return false;
                }
                hashSet.add(string);
            }
        }
        return true;
    }

    private static boolean checkEntryIsValid(List<HapVerifyInfo> list) throws BundleException {
        ArrayList<HapVerifyInfo> arrayList = new ArrayList<HapVerifyInfo>();
        ArrayList<HapVerifyInfo> arrayList2 = new ArrayList<HapVerifyInfo>();
        for (HapVerifyInfo hapVerifyInfo : list) {
            if (ENTRY.equals(hapVerifyInfo.getModuleType())) {
                arrayList.add(hapVerifyInfo);
                continue;
            }
            if (FEATURE.equals(hapVerifyInfo.getModuleType())) {
                arrayList2.add(hapVerifyInfo);
                continue;
            }
            if ("shared".equals(hapVerifyInfo.getModuleType())) continue;
            LOG.warning("Input wrong type module.");
        }
        if (list.isEmpty() || arrayList.isEmpty() && !"shared".equals(list.get(0).getBundleType())) {
            LOG.warning("Warning: has no entry module.");
        }
        for (int i = 0; i < arrayList.size() - 1; ++i) {
            for (int j = i + 1; j < arrayList.size(); ++j) {
                if (HapVerify.checkDuplicatedIsValid((HapVerifyInfo)arrayList.get(i), (HapVerifyInfo)arrayList.get(j))) continue;
                LOG.error("Module: (" + ((HapVerifyInfo)arrayList.get(i)).getModuleName() + ") and Module: (" + ((HapVerifyInfo)arrayList.get(j)).getModuleName() + ") are entry, please check deviceType or distroFilter of the module.");
                LOG.error("Module: " + ((HapVerifyInfo)arrayList.get(i)).getModuleName() + " has deviceType " + ((HapVerifyInfo)arrayList.get(i)).getDeviceType() + ".");
                LOG.error("Another Module: " + ((HapVerifyInfo)arrayList.get(j)).getModuleName() + " has deviceType " + ((HapVerifyInfo)arrayList.get(j)).getDeviceType() + ".");
                if (!EMPTY_STRING.equals(((HapVerifyInfo)arrayList.get(i)).getDistroFilter().dump())) {
                    LOG.error("Module: " + ((HapVerifyInfo)arrayList.get(i)).getModuleName() + " DistroFilter is : " + ((HapVerifyInfo)arrayList.get(i)).getDistroFilter().dump() + ".");
                }
                if (!EMPTY_STRING.equals(((HapVerifyInfo)arrayList.get(j)).getDistroFilter().dump())) {
                    LOG.error("Another Module: " + ((HapVerifyInfo)arrayList.get(j)).getModuleName() + " DistroFilter is " + ((HapVerifyInfo)arrayList.get(j)).getDistroFilter().dump() + ".");
                }
                LOG.error("Solution: Make sure entry name is valid and unique.");
                LOG.error("Reference: FAQ.");
                return false;
            }
        }
        Map<String, List<HapVerifyInfo>> map = HapVerify.classifyEntry(arrayList);
        for (HapVerifyInfo hapVerifyInfo : arrayList2) {
            if (HapVerify.checkFeature(hapVerifyInfo, map)) continue;
            LOG.warning(hapVerifyInfo.getModuleName() + " can not be covered by entry.");
        }
        return true;
    }

    private static boolean checkDuplicatedIsValid(HapVerifyInfo hapVerifyInfo, HapVerifyInfo hapVerifyInfo2) throws BundleException {
        if (Collections.disjoint(hapVerifyInfo.getDeviceType(), hapVerifyInfo2.getDeviceType())) {
            return true;
        }
        return HapVerify.checkDistroFilterDisjoint(hapVerifyInfo.getDistroFilter(), hapVerifyInfo2.getDistroFilter());
    }

    private static boolean checkDistroFilterDisjoint(DistroFilter distroFilter, DistroFilter distroFilter2) throws BundleException {
        if (distroFilter == null || distroFilter2 == null) {
            return false;
        }
        if (distroFilter.apiVersion != null && distroFilter2.apiVersion != null && HapVerify.checkPolicyValueDisjoint(distroFilter.apiVersion.policy, distroFilter.apiVersion.value, distroFilter2.apiVersion.policy, distroFilter2.apiVersion.value)) {
            return true;
        }
        if (distroFilter.screenShape != null && distroFilter2.screenShape != null && HapVerify.checkPolicyValueDisjoint(distroFilter.screenShape.policy, distroFilter.screenShape.value, distroFilter2.screenShape.policy, distroFilter2.screenShape.value)) {
            return true;
        }
        if (distroFilter.screenDensity != null && distroFilter2.screenDensity != null && HapVerify.checkPolicyValueDisjoint(distroFilter.screenDensity.policy, distroFilter.screenDensity.value, distroFilter2.screenDensity.policy, distroFilter2.screenDensity.value)) {
            return true;
        }
        if (distroFilter.screenWindow != null && distroFilter2.screenWindow != null && HapVerify.checkPolicyValueDisjoint(distroFilter.screenWindow.policy, distroFilter.screenWindow.value, distroFilter2.screenWindow.policy, distroFilter2.screenWindow.value)) {
            return true;
        }
        return distroFilter.countryCode != null && distroFilter2.countryCode != null && HapVerify.checkPolicyValueDisjoint(distroFilter.countryCode.policy, distroFilter.countryCode.value, distroFilter2.countryCode.policy, distroFilter2.countryCode.value);
    }

    private static boolean checkPolicyValueDisjoint(String string, List<String> list, String string2, List<String> list2) throws BundleException {
        if (list == null || list2 == null) {
            LOG.error("HapVerify::checkPolicyValueDisjoint value should not empty.");
            throw new BundleException("HapVerify::checkPolicyValueDisjoint value should not empty.");
        }
        if (EXCLUDE.equals(string) && INCLUDE.equals(string2)) {
            if (list2.isEmpty() || list.containsAll(list2)) {
                return true;
            }
        } else if (INCLUDE.equals(string) && INCLUDE.equals(string2)) {
            if (Collections.disjoint(list, list2)) {
                return true;
            }
        } else if (INCLUDE.equals(string) && EXCLUDE.equals(string2)) {
            if (list.isEmpty() || list2.containsAll(list)) {
                return true;
            }
        } else {
            if (EXCLUDE.equals(string) && EXCLUDE.equals(string2)) {
                return false;
            }
            LOG.error("HapVerify::checkPolicyValueDisjoint input policy is invalid.");
            throw new BundleException("HapVerify::checkPolicyValueDisjoint input policy is invalid.");
        }
        return false;
    }

    private static Map<String, List<HapVerifyInfo>> classifyEntry(List<HapVerifyInfo> list) {
        HashMap<String, List<HapVerifyInfo>> hashMap = new HashMap<String, List<HapVerifyInfo>>();
        for (HapVerifyInfo hapVerifyInfo : list) {
            for (String string : hapVerifyInfo.getDeviceType()) {
                if (hashMap.containsKey(string)) {
                    ((List)hashMap.get(string)).add(hapVerifyInfo);
                    continue;
                }
                hashMap.put(string, new ArrayList());
                ((List)hashMap.get(string)).add(hapVerifyInfo);
            }
        }
        return hashMap;
    }

    private static boolean checkFeature(HapVerifyInfo hapVerifyInfo, Map<String, List<HapVerifyInfo>> map) throws BundleException {
        for (String string : hapVerifyInfo.getDeviceType()) {
            if (!map.containsKey(string)) {
                LOG.warning("Warning: device " + string + " has feature but has no entry.");
                return false;
            }
            List<HapVerifyInfo> list = map.get(string);
            if (HapVerify.checkFeatureDistroFilter(hapVerifyInfo, list)) continue;
            LOG.warning(hapVerifyInfo.getModuleName() + "'s distroFilter has not covered by entry.");
            if (!EMPTY_STRING.equals(hapVerifyInfo.getDistroFilter().dump())) {
                LOG.warning(hapVerifyInfo.getModuleName() + " has " + hapVerifyInfo.getDistroFilter().dump() + ".");
            }
            return false;
        }
        return true;
    }

    private static boolean checkFeatureDistroFilter(HapVerifyInfo hapVerifyInfo, List<HapVerifyInfo> list) throws BundleException {
        if (hapVerifyInfo.getDistroFilter() == null) {
            return HapVerify.checkApiVersionCovered(null, list) && HapVerify.checkScreenShapeCovered(null, list) && HapVerify.checkScreenWindowCovered(null, list) && HapVerify.checkScreenDensityCovered(null, list) && HapVerify.checkCountryCodeCovered(null, list);
        }
        if (!HapVerify.checkApiVersionCovered(hapVerifyInfo.getDistroFilter().apiVersion, list)) {
            LOG.warning("HapVerify::checkFeatureDistroFilter failed, apiVersion is not covered.");
            return false;
        }
        if (!HapVerify.checkScreenShapeCovered(hapVerifyInfo.getDistroFilter().screenShape, list)) {
            LOG.warning("HapVerify::checkFeatureDistroFilter failed, screenShape is not covered.");
            return false;
        }
        if (!HapVerify.checkScreenWindowCovered(hapVerifyInfo.getDistroFilter().screenWindow, list)) {
            LOG.warning("HapVerify::checkFeatureDistroFilter failed, screenWindow is not covered.");
            return false;
        }
        if (!HapVerify.checkScreenDensityCovered(hapVerifyInfo.getDistroFilter().screenDensity, list)) {
            LOG.warning("HapVerify::checkFeatureDistroFilter failed, screenDensity is not covered.");
            return false;
        }
        if (!HapVerify.checkCountryCodeCovered(hapVerifyInfo.getDistroFilter().countryCode, list)) {
            LOG.warning("HapVerify::checkFeatureDistroFilter failed, countryCode is not covered.");
            return false;
        }
        return true;
    }

    private static boolean checkApiVersionCovered(ApiVersion apiVersion, List<HapVerifyInfo> list) throws BundleException {
        List<String> list2 = null;
        List<String> list3 = null;
        for (HapVerifyInfo hapVerifyInfo : list) {
            if (hapVerifyInfo.getDistroFilter() == null || hapVerifyInfo.getDistroFilter().apiVersion == null) {
                return true;
            }
            if (hapVerifyInfo.getDistroFilter().apiVersion.policy == null) {
                LOG.error("HapVerify::checkApiVersionCovered input none policy.");
                return false;
            }
            if (INCLUDE.equals(hapVerifyInfo.getDistroFilter().apiVersion.policy)) {
                if (list2 == null) {
                    list2 = new ArrayList<String>();
                }
                list2.addAll(hapVerifyInfo.getDistroFilter().apiVersion.value);
                continue;
            }
            if (EXCLUDE.equals(hapVerifyInfo.getDistroFilter().apiVersion.policy)) {
                if (list3 == null) {
                    list3 = new ArrayList<String>();
                }
                list3 = Stream.of(list3, hapVerifyInfo.getDistroFilter().apiVersion.value).flatMap(Collection::stream).distinct().collect(Collectors.toList());
                continue;
            }
            LOG.error("HapVerify::checkApiVersionCovered input policy is invalid.");
            throw new BundleException("HapVerify::checkApiVersionCovered input policy is invalid.");
        }
        if (list2 != null) {
            list2 = list2.stream().distinct().collect(Collectors.toList());
        }
        if (list3 != null) {
            list3 = list3.stream().distinct().collect(Collectors.toList());
        }
        if (apiVersion == null) {
            return HapVerify.checkEntryPolicyValueCoverAll(list2, list3);
        }
        return HapVerify.checkPolicyValueCovered(apiVersion.policy, apiVersion.value, list2, list3);
    }

    private static boolean checkScreenShapeCovered(ScreenShape screenShape, List<HapVerifyInfo> list) throws BundleException {
        List<String> list2 = null;
        List<String> list3 = null;
        for (HapVerifyInfo hapVerifyInfo : list) {
            if (hapVerifyInfo.getDistroFilter() == null || hapVerifyInfo.getDistroFilter().screenShape == null) {
                return true;
            }
            if (hapVerifyInfo.getDistroFilter().screenShape.policy == null) {
                LOG.error("HapVerify::checkScreenShapeCovered input none policy.");
                return false;
            }
            if (INCLUDE.equals(hapVerifyInfo.getDistroFilter().screenShape.policy)) {
                if (list2 == null) {
                    list2 = new ArrayList<String>();
                }
                list2.addAll(hapVerifyInfo.getDistroFilter().screenShape.value);
                continue;
            }
            if (EXCLUDE.equals(hapVerifyInfo.getDistroFilter().screenShape.policy)) {
                if (list3 == null) {
                    list3 = new ArrayList<String>();
                }
                list3 = Stream.of(list3, hapVerifyInfo.getDistroFilter().screenShape.value).flatMap(Collection::stream).distinct().collect(Collectors.toList());
                continue;
            }
            LOG.error("HapVerify::checkScreenShapeCovered input policy is invalid.");
            throw new BundleException("HapVerify::checkScreenShapeCovered input policy is invalid.");
        }
        if (list2 != null) {
            list2 = list2.stream().distinct().collect(Collectors.toList());
        }
        if (list3 != null) {
            list3 = list3.stream().distinct().collect(Collectors.toList());
        }
        if (screenShape == null) {
            return HapVerify.checkEntryPolicyValueCoverAll(list2, list3);
        }
        return HapVerify.checkPolicyValueCovered(screenShape.policy, screenShape.value, list2, list3);
    }

    private static boolean checkScreenWindowCovered(ScreenWindow screenWindow, List<HapVerifyInfo> list) throws BundleException {
        List<String> list2 = null;
        List<String> list3 = null;
        for (HapVerifyInfo hapVerifyInfo : list) {
            if (hapVerifyInfo.getDistroFilter() == null || hapVerifyInfo.getDistroFilter().screenWindow == null) {
                return true;
            }
            if (hapVerifyInfo.getDistroFilter().screenWindow.policy == null) {
                LOG.error("HapVerify::checkScreenWindowCovered input none policy.");
                return false;
            }
            if (INCLUDE.equals(hapVerifyInfo.getDistroFilter().screenWindow.policy)) {
                if (list2 == null) {
                    list2 = new ArrayList<String>();
                }
                list2.addAll(hapVerifyInfo.getDistroFilter().screenWindow.value);
                continue;
            }
            if (EXCLUDE.equals(hapVerifyInfo.getDistroFilter().screenWindow.policy)) {
                if (list3 == null) {
                    list3 = new ArrayList<String>();
                }
                list3 = Stream.of(list3, hapVerifyInfo.getDistroFilter().screenWindow.value).flatMap(Collection::stream).distinct().collect(Collectors.toList());
                continue;
            }
            LOG.error("HapVerify::checkScreenWindowCovered input policy is invalid.");
            throw new BundleException("HapVerify::checkScreenWindowCovered input policy is invalid.");
        }
        if (list2 != null) {
            list2 = list2.stream().distinct().collect(Collectors.toList());
        }
        if (list3 != null) {
            list3 = list3.stream().distinct().collect(Collectors.toList());
        }
        if (screenWindow == null) {
            return HapVerify.checkEntryPolicyValueCoverAll(list2, list3);
        }
        return HapVerify.checkPolicyValueCovered(screenWindow.policy, screenWindow.value, list2, list3);
    }

    private static boolean checkScreenDensityCovered(ScreenDensity screenDensity, List<HapVerifyInfo> list) throws BundleException {
        List<String> list2 = null;
        List<String> list3 = null;
        for (HapVerifyInfo hapVerifyInfo : list) {
            if (hapVerifyInfo.getDistroFilter() == null || hapVerifyInfo.getDistroFilter().screenDensity == null) {
                return true;
            }
            if (hapVerifyInfo.getDistroFilter().screenDensity.policy == null) {
                LOG.error("HapVerify::checkScreenDensityCovered input none policy.");
                return false;
            }
            if (INCLUDE.equals(hapVerifyInfo.getDistroFilter().screenDensity.policy)) {
                if (list2 == null) {
                    list2 = new ArrayList<String>();
                }
                list2.addAll(hapVerifyInfo.getDistroFilter().screenDensity.value);
                continue;
            }
            if (EXCLUDE.equals(hapVerifyInfo.getDistroFilter().screenDensity.policy)) {
                if (list3 == null) {
                    list3 = new ArrayList<String>();
                }
                list3 = Stream.of(list3, hapVerifyInfo.getDistroFilter().screenDensity.value).flatMap(Collection::stream).distinct().collect(Collectors.toList());
                continue;
            }
            LOG.error("HapVerify::checkScreenDensityCovered input policy is invalid.");
            throw new BundleException("HapVerify::checkScreenDensityCovered input policy is invalid.");
        }
        if (list2 != null) {
            list2 = list2.stream().distinct().collect(Collectors.toList());
        }
        if (list3 != null) {
            list3 = list3.stream().distinct().collect(Collectors.toList());
        }
        if (screenDensity == null) {
            return HapVerify.checkEntryPolicyValueCoverAll(list2, list3);
        }
        return HapVerify.checkPolicyValueCovered(screenDensity.policy, screenDensity.value, list2, list3);
    }

    private static boolean checkCountryCodeCovered(CountryCode countryCode, List<HapVerifyInfo> list) throws BundleException {
        List<String> list2 = null;
        List<String> list3 = null;
        for (HapVerifyInfo hapVerifyInfo : list) {
            if (hapVerifyInfo.getDistroFilter() == null || hapVerifyInfo.getDistroFilter().countryCode == null) {
                return true;
            }
            if (hapVerifyInfo.getDistroFilter().countryCode.policy == null) {
                LOG.error("HapVerify::checkCountryCodeCovered input none policy.");
                return false;
            }
            if (INCLUDE.equals(hapVerifyInfo.getDistroFilter().countryCode.policy)) {
                if (list2 == null) {
                    list2 = new ArrayList<String>();
                }
                list2.addAll(hapVerifyInfo.getDistroFilter().countryCode.value);
                continue;
            }
            if (EXCLUDE.equals(hapVerifyInfo.getDistroFilter().countryCode.policy)) {
                if (list3 == null) {
                    list3 = new ArrayList<String>();
                }
                list3 = Stream.of(list3, hapVerifyInfo.getDistroFilter().countryCode.value).flatMap(Collection::stream).distinct().collect(Collectors.toList());
                continue;
            }
            LOG.error("HapVerify::checkCountryCodeCovered input policy is invalid.");
            throw new BundleException("HapVerify::checkCountryCodeCovered input policy is invalid.");
        }
        if (list2 != null) {
            list2 = list2.stream().distinct().collect(Collectors.toList());
        }
        if (list3 != null) {
            list3 = list3.stream().distinct().collect(Collectors.toList());
        }
        if (countryCode == null) {
            return HapVerify.checkEntryPolicyValueCoverAll(list2, list3);
        }
        return HapVerify.checkPolicyValueCovered(countryCode.policy, countryCode.value, list2, list3);
    }

    private static boolean checkEntryPolicyValueCoverAll(List<String> list, List<String> list2) {
        if (list == null) {
            return list2 == null || list2.isEmpty();
        }
        return list2 != null && list.containsAll(list2);
    }

    private static boolean checkPolicyValueCovered(String string, List<String> list, List<String> list2, List<String> list3) {
        if (list == null || string == null) {
            LOG.error("checkPolicyValueCovered::failed value is null.");
            return false;
        }
        if (EXCLUDE.equals(string)) {
            return HapVerify.checkCoveredExcludePolicyValue(list, list2, list3);
        }
        if (INCLUDE.equals(string)) {
            return HapVerify.checkCoveredIncludePolicyValue(list, list2, list3);
        }
        return false;
    }

    private static boolean checkCoveredExcludePolicyValue(List<String> list, List<String> list2, List<String> list3) {
        if (list2 == null) {
            return list3 == null || list.containsAll(list3);
        }
        if (list3 == null) {
            return false;
        }
        list3.removeAll(list2);
        return list.containsAll(list3);
    }

    private static boolean checkCoveredIncludePolicyValue(List<String> list, List<String> list2, List<String> list3) {
        if (list2 == null) {
            return list3 == null || Collections.disjoint(list3, list);
        }
        if (list3 == null) {
            return list2.containsAll(list);
        }
        list3.removeAll(list2);
        return Collections.disjoint(list3, list);
    }

    private static boolean checkDependencyIsValid(List<HapVerifyInfo> list) throws BundleException {
        if (list.isEmpty()) {
            LOG.error("HapVerify::checkDependencyIsValid failed, input none hap.");
            throw new BundleException("HapVerify::checkDependencyIsValid failed, input none hap.");
        }
        boolean bl = list.get(0).isInstallationFree();
        for (HapVerifyInfo hapVerifyInfo : list) {
            if (bl == hapVerifyInfo.isInstallationFree()) continue;
            LOG.error("installationFree is different in input hap.");
            return false;
        }
        for (HapVerifyInfo hapVerifyInfo : list) {
            ArrayList<HapVerifyInfo> arrayList = new ArrayList<HapVerifyInfo>();
            arrayList.add(hapVerifyInfo);
            if (!HapVerify.dfsTraverseDependency(hapVerifyInfo, list, arrayList)) {
                return false;
            }
            arrayList.remove(arrayList.size() - 1);
        }
        return true;
    }

    private static boolean dfsTraverseDependency(HapVerifyInfo hapVerifyInfo, List<HapVerifyInfo> list, List<HapVerifyInfo> list2) throws BundleException {
        if (HapVerify.checkDependencyListCirculate(list2)) {
            return false;
        }
        for (DependencyItem dependencyItem : hapVerifyInfo.getDependencyItemList()) {
            if (!dependencyItem.getBundleName().equals(hapVerifyInfo.getBundleName())) continue;
            if (!HapVerify.checkDependencyInFileList(dependencyItem, list)) {
                LOG.warning("Dependent module " + dependencyItem.getModuleName() + " missing, check the HSP-Path.");
                continue;
            }
            List<HapVerifyInfo> list3 = HapVerify.getLayerDependency(dependencyItem.getModuleName(), hapVerifyInfo, list);
            for (HapVerifyInfo hapVerifyInfo2 : list3) {
                if (FEATURE.equals(hapVerifyInfo2.getModuleType()) || ENTRY.equals(hapVerifyInfo2.getModuleType())) {
                    LOG.error("HAP or HSP cannot depend on HAP" + hapVerifyInfo2.getModuleName() + ".");
                    return false;
                }
                list2.add(hapVerifyInfo2);
                if (!HapVerify.dfsTraverseDependency(hapVerifyInfo2, list, list2)) {
                    return false;
                }
                list2.remove(list2.size() - 1);
            }
        }
        return true;
    }

    private static boolean checkDependencyInFileList(DependencyItem dependencyItem, List<HapVerifyInfo> list) {
        String string = dependencyItem.getModuleName();
        String string2 = dependencyItem.getBundleName();
        for (HapVerifyInfo hapVerifyInfo : list) {
            if (!string.equals(hapVerifyInfo.getModuleName()) || !string2.equals(hapVerifyInfo.getBundleName())) continue;
            return true;
        }
        return false;
    }

    private static List<HapVerifyInfo> getLayerDependency(String string, HapVerifyInfo hapVerifyInfo, List<HapVerifyInfo> list) throws BundleException {
        ArrayList<HapVerifyInfo> arrayList = new ArrayList<HapVerifyInfo>();
        for (HapVerifyInfo hapVerifyInfo2 : list) {
            if (!hapVerifyInfo2.getModuleName().equals(string) || !HapVerify.checkModuleJoint(hapVerifyInfo, hapVerifyInfo2)) continue;
            arrayList.add(hapVerifyInfo2);
        }
        return arrayList;
    }

    private static boolean checkModuleJoint(HapVerifyInfo hapVerifyInfo, HapVerifyInfo hapVerifyInfo2) throws BundleException {
        return !HapVerify.checkDuplicatedIsValid(hapVerifyInfo, hapVerifyInfo2);
    }

    private static boolean checkDependencyListCirculate(List<HapVerifyInfo> list) throws BundleException {
        for (int i = 0; i < list.size() - 1; ++i) {
            for (int j = i + 1; j < list.size(); ++j) {
                if (!HapVerify.isSameHapVerifyInfo(list.get(i), list.get(j))) continue;
                LOG.error("circular dependency, dependencyList is " + HapVerify.getHapVerifyInfoListNames(list) + ".");
                return true;
            }
        }
        return false;
    }

    private static boolean isSameHapVerifyInfo(HapVerifyInfo hapVerifyInfo, HapVerifyInfo hapVerifyInfo2) throws BundleException {
        if (!hapVerifyInfo.getModuleName().equals(hapVerifyInfo2.getModuleName())) {
            return false;
        }
        return HapVerify.checkModuleJoint(hapVerifyInfo, hapVerifyInfo2);
    }

    private static List<String> getHapVerifyInfoListNames(List<HapVerifyInfo> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (HapVerifyInfo hapVerifyInfo : list) {
            arrayList.add(hapVerifyInfo.getModuleName());
        }
        return arrayList;
    }

    private static boolean checkAtomicServiceModuleSize(List<HapVerifyInfo> list) throws BundleException {
        if (list.isEmpty()) {
            LOG.error("checkAtomicServiceIsValid failed, hapVerifyInfoList is empty.");
            return false;
        }
        int n = list.get(0).getEntrySizeLimit();
        int n2 = list.get(0).getNotEntrySizeLimit();
        for (HapVerifyInfo hapVerifyInfo : list) {
            List<String> list2 = HapVerify.getModuleDependency(hapVerifyInfo, list);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (String string : list2) {
                HapVerifyInfo hapVerifyInfo2 = HapVerify.findAtomicServiceHapVerifyInfo(string, list);
                arrayList.add(hapVerifyInfo2);
            }
            long l = hapVerifyInfo.getFileLength();
            for (HapVerifyInfo hapVerifyInfo3 : arrayList) {
                if (hapVerifyInfo3 == null) continue;
                l += hapVerifyInfo3.getFileLength();
            }
            if (hapVerifyInfo.getModuleType().equals(ENTRY) && l >= (long)n * 0x100000L) {
                LOG.error("module " + hapVerifyInfo.getModuleName() + " and it's dependencies size is " + HapVerify.getCeilFileSize(l, n) + "MB, which is overlarge than " + n + "MB.");
                return false;
            }
            if (hapVerifyInfo.getModuleType().equals(ENTRY) || l < (long)n2 * 0x100000L) continue;
            LOG.error("module " + hapVerifyInfo.getModuleName() + " and it's dependencies size is " + HapVerify.getCeilFileSize(l, n2) + "MB, which is overlarge than " + n2 + "MB.");
            return false;
        }
        return true;
    }

    private static double getCeilFileSize(long l, int n) {
        double d = Double.valueOf(n) + 0.01;
        double d2 = new BigDecimal((float)l / 1048576.0f).setScale(2, 4).doubleValue();
        if (d2 < d && d2 >= (double)n) {
            d2 = d;
        }
        return d2;
    }

    private static Map<String, List<HapVerifyInfo>> getDeviceHapVerifyInfoMap(List<HapVerifyInfo> list) throws BundleException {
        if (list.isEmpty()) {
            LOG.error("getDeviceHapVerifyInfoMap failed, hapVerifyInfoList is empty.");
            throw new BundleException("getDeviceHapVerifyInfoMap failed, hapVerifyInfoList is empty.");
        }
        HashMap<String, List<HapVerifyInfo>> hashMap = new HashMap<String, List<HapVerifyInfo>>();
        for (HapVerifyInfo hapVerifyInfo : list) {
            List<String> list2 = hapVerifyInfo.getDeviceType();
            for (String string : list2) {
                if (!hashMap.containsKey(string)) {
                    ArrayList<HapVerifyInfo> arrayList = new ArrayList<HapVerifyInfo>();
                    arrayList.add(hapVerifyInfo);
                    hashMap.put(string, arrayList);
                    continue;
                }
                ((List)hashMap.get(string)).add(hapVerifyInfo);
            }
        }
        return hashMap;
    }

    private static boolean checkAtomicServiceIsValid(List<HapVerifyInfo> list) throws BundleException {
        if (list.isEmpty()) {
            LOG.error("checkAtomicServiceIsValid failed, hapVerifyInfoList is empty.");
            return false;
        }
        String string = list.get(0).getBundleType();
        if (!string.equals(ATOMIC_SERVICE)) {
            return true;
        }
        boolean bl = list.get(0).isStageModule();
        if (!bl) {
            return true;
        }
        Map<String, List<HapVerifyInfo>> map = HapVerify.getDeviceHapVerifyInfoMap(list);
        for (String string2 : map.keySet()) {
            List<HapVerifyInfo> list2 = map.get(string2);
            if (HapVerify.checkAtomicServicePreloadsIsValid(list2)) continue;
            LOG.error("checkAtomicServicePreloadsIsValid failed on device " + string2 + ".");
            return false;
        }
        return true;
    }

    private static boolean checkAtomicServiceSumLimit(List<HapVerifyInfo> list) {
        int n = list.get(0).getSumSizeLimit();
        if (!list.get(0).isStageModule()) {
            return true;
        }
        long l = 0L;
        for (HapVerifyInfo hapVerifyInfo : list) {
            if ((l += hapVerifyInfo.getFileLength()) < (long)n * 0x100000L) continue;
            LOG.error("The total file size is " + HapVerify.getCeilFileSize(l, n) + "MB, greater than " + n + "MB.");
            return false;
        }
        return true;
    }

    private static boolean checkAtomicServicePreloadsIsValid(List<HapVerifyInfo> list) throws BundleException {
        String string;
        List<PreloadItem> list2;
        if (list.isEmpty()) {
            LOG.error("checkAtomicServicePreloadsIsValid failed, hapVerifyInfoList is empty.");
            throw new BundleException("checkAtomicServicePreloadsIsValid failed, hapVerifyInfoList is empty.");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (HapVerifyInfo iterator : list) {
            arrayList.add(iterator.getModuleName());
        }
        for (HapVerifyInfo hapVerifyInfo : list) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            list2 = hapVerifyInfo.getPreloadItems();
            for (PreloadItem preloadItem : list2) {
                string = preloadItem.getModuleName();
                if (arrayList2.contains(string)) {
                    LOG.error("preloads config a duplicate module " + string + " in " + hapVerifyInfo.getModuleName() + ".");
                    return false;
                }
                arrayList2.add(string);
                if (!arrayList.contains(string)) {
                    LOG.error("preloads config a invalid module " + string + " in " + hapVerifyInfo.getModuleName() + ".");
                    return false;
                }
                if (!string.equals(hapVerifyInfo.getModuleName())) continue;
                LOG.error("can not preload self, " + hapVerifyInfo.getModuleName() + " preload self.");
                return false;
            }
        }
        HashMap hashMap = new HashMap();
        for (HapVerifyInfo hapVerifyInfo : list) {
            hashMap.put(hapVerifyInfo.getModuleName(), hapVerifyInfo.getModuleType());
        }
        for (HapVerifyInfo hapVerifyInfo : list) {
            list2 = hapVerifyInfo.getPreloadItems();
            for (PreloadItem preloadItem : list2) {
                string = preloadItem.getModuleName();
                if (!((String)hashMap.get(string)).equals(ENTRY) && !((String)hashMap.get(string)).equals(HAR)) continue;
                LOG.error("feature or shared can not preload entry or har, " + hapVerifyInfo.getModuleName() + " preloads a " + (String)hashMap.get(string) + " module.");
                return false;
            }
        }
        return true;
    }

    public static boolean checkFileSizeIsValid(List<HapVerifyInfo> list) throws BundleException {
        if (list.isEmpty()) {
            LOG.error("checkFileSizeIsValid failed, hapVerifyInfoList is empty.");
            throw new BundleException("checkFileSizeIsValid failed, hapVerifyInfoList is empty.");
        }
        if (!HapVerify.checkFileSize(list)) {
            LOG.error("checkFileSize failed.");
            return false;
        }
        return true;
    }

    private static boolean checkFileSize(List<HapVerifyInfo> list) throws BundleException {
        if (list.isEmpty()) {
            LOG.error("checkFileSizeWhenSplit failed, hapVerifyInfoList is empty.");
            throw new BundleException("checkFileSizeWhenSplit failed, hapVerifyInfoList is empty.");
        }
        int n = list.get(0).getEntrySizeLimit();
        int n2 = list.get(0).getNotEntrySizeLimit();
        for (HapVerifyInfo object : list) {
            if (object.getModuleType().equals(ENTRY) && object.getFileLength() >= (long)n * 0x100000L) {
                LOG.error("module " + object.getModuleName() + "'s size is " + HapVerify.getCeilFileSize(object.getFileLength(), n) + "MB, which is overlarge than " + n + "MB.");
                return false;
            }
            if (object.getModuleType().equals(ENTRY) || object.getFileLength() < (long)n2 * 0x100000L) continue;
            LOG.error("module " + object.getModuleName() + "'s size is " + HapVerify.getCeilFileSize(object.getFileLength(), n2) + "MB, which is overlarge than " + n2 + "MB.");
            return false;
        }
        Map<String, List<HapVerifyInfo>> map = HapVerify.getDeviceHapVerifyInfoMap(list);
        for (String string : map.keySet()) {
            List list2 = (List)map.get(string);
            if (HapVerify.checkAtomicServiceModuleSize(list2)) continue;
            LOG.error("checkAtomicServiceModuleSize failed on device " + string + ".");
            return false;
        }
        return true;
    }

    private static List<String> getModuleDependency(HapVerifyInfo hapVerifyInfo, List<HapVerifyInfo> list) throws BundleException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(hapVerifyInfo.getDependencies());
        List<String> list2 = hapVerifyInfo.getDependencies();
        for (String string : list2) {
            HapVerifyInfo hapVerifyInfo2 = HapVerify.findAtomicServiceHapVerifyInfo(string, list);
            if (hapVerifyInfo2 == null) continue;
            List<String> list3 = HapVerify.getModuleDependency(hapVerifyInfo2, list);
            for (String string2 : list3) {
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    private static HapVerifyInfo findAtomicServiceHapVerifyInfo(String string, List<HapVerifyInfo> list) {
        for (HapVerifyInfo hapVerifyInfo : list) {
            if (!hapVerifyInfo.getModuleName().equals(string)) continue;
            return hapVerifyInfo;
        }
        return null;
    }
}

