/*
 * Decompiled with CFR 0.152.
 */
package ohos;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import ohos.AbilityInfo;
import ohos.BundleException;
import ohos.Distro;
import ohos.FileUtils;
import ohos.HQFInfo;
import ohos.HapInfo;
import ohos.HapZipInfo;
import ohos.JsonUtil;
import ohos.Log;
import ohos.ModuleAdaption;
import ohos.ModuleProfileInfo;
import ohos.ModuleResult;
import ohos.PackInfo;
import ohos.ProfileInfo;
import ohos.ResourceIndexResult;
import ohos.ResourcesParser;
import ohos.SkillInfo;
import ohos.UncompressResult;
import ohos.UncompressVerify;
import ohos.Utility;

public class Uncompress {
    private static final String HAP_SUFFIX = ".hap";
    private static final String APK_SUFFIX = ".apk";
    private static final String JSON_SUFFIX = ".json";
    private static final String PACK_INFO = "pack.info";
    private static final String HARMONY_PROFILE = "config.json";
    private static final String MODULE_JSON = "module.json";
    private static final String RESOURCE_INDEX = "resources.index";
    private static final String RPCID_SC = "rpcid.sc";
    private static final String LIBS = "libs";
    private static final String PACKAGEFILE = "packagefile";
    private static final String LINUX_FILE_SEPARATOR = "/";
    private static final String TEMP_PATH = "temp";
    private static final String HAP_SUFFIXI = ".hap";
    private static final String ENTRY_TYPE = "entry";
    private static final String SYSTEM_ACTION = "action.system.home";
    private static final String SYSTEM_WANT_HOME = "ohos.want.action.home";
    private static final String SYSTEM_ENTITY = "entity.system.home";
    private static final int READ_BUFFER_SIZE = 1024;
    private static final int BUFFER_SIZE = 10240;
    private static final String LIBS_DIR_NAME = "libs";
    private static final String CUT_ENTRY_FILENAME = "cut_entry.apk";
    private static final String SO_SUFFIX = ".so";
    private static final String RESOURCE_PATH = "resources/base/profile/";
    private static final String TRUE = "true";
    private static final String HQF_SUFFIX = ".hqf";
    private static final String PATCH_JSON = "patch.json";
    private static final String HAP_PREFIX = "HAP";
    private static final String HSP_SUFFIX = ".hsp";
    private static final int MAX_CPU_ABI_TYPE_NUM = 128;
    private static final Log LOG = new Log(Uncompress.class.toString());

    static boolean unpackageProcess(Utility utility) {
        if (utility == null) {
            LOG.error("Uncompress::unpackageProcess utility is null.");
            return false;
        }
        boolean bl = true;
        File file = new File(utility.getOutPath());
        if (!file.exists() && !file.mkdirs()) {
            LOG.error("Uncompress::unpackageProcess create out file directory failed!");
            return false;
        }
        try {
            if (!("hap".equals(utility.getMode()) && TRUE.equals(utility.getRpcid()) || utility.getForceRewrite().isEmpty() || !TRUE.equals(utility.getForceRewrite()))) {
                Object object = new File(utility.getOutPath());
                Uncompress.deleteFile((File)object);
                ((File)object).mkdirs();
            }
            switch (utility.getMode()) {
                case "hap": {
                    Uncompress.unpackageHapMode(utility);
                    break;
                }
                case "har": {
                    Uncompress.dataTransferAllFiles(utility.getHarPath(), utility.getOutPath());
                    break;
                }
                case "app": {
                    Uncompress.dataTransferFilesByApp(utility, utility.getAppPath(), utility.getOutPath());
                    break;
                }
                case "appqf": {
                    Uncompress.uncompressAPPQFFile(utility);
                    break;
                }
                case "hsp": {
                    Uncompress.unpackageHspMode(utility);
                    break;
                }
                default: {
                    LOG.error("Uncompress::unpackageProcess input wrong type!");
                    throw new BundleException("Uncompress::unpackageProcess input wrong type!");
                }
            }
        }
        catch (BundleException bundleException) {
            bl = false;
            LOG.error("Uncompress::unpackageProcess Bundle exception");
        }
        if (!bl) {
            LOG.error("Uncompress::unpackageProcess unpackage failed!");
        }
        return bl;
    }

    static void unpackageHapMode(Utility utility) throws BundleException {
        if (!"hap".equals(utility.getMode())) {
            LOG.error("unpackageHapMode input wrong unpack mode: " + utility.getMode());
            throw new BundleException("Uncompress::unpackageHapMode input wrong unpack mode");
        }
        try {
            if (TRUE.equals(utility.getLibs())) {
                Uncompress.unpackageLibsMode(utility.getHapPath(), utility.getOutPath(), utility.getFormattedCpuAbiList());
                return;
            }
            if (TRUE.equals(utility.getRpcid())) {
                Uncompress.getRpcidFromHap(utility.getHapPath(), utility.getOutPath());
                return;
            }
            if (TRUE.equals(utility.getUnpackApk())) {
                Uncompress.unzip(utility, utility.getHapPath(), utility.getOutPath(), APK_SUFFIX);
                String[] stringArray = utility.getHapPath().replace("\\", LINUX_FILE_SEPARATOR).split(LINUX_FILE_SEPARATOR);
                String string = stringArray[stringArray.length - 1];
                Uncompress.repackHap(utility.getHapPath(), utility.getOutPath(), string, utility.getUnpackApk());
            } else {
                Uncompress.dataTransferAllFiles(utility.getHapPath(), utility.getOutPath());
            }
        }
        catch (BundleException bundleException) {
            LOG.error("Uncompress::unpackageHapMode failed");
            throw new BundleException("Uncompress::unpackageHapMode failed");
        }
    }

    static void unpackageHspMode(Utility utility) throws BundleException {
        if (!"hsp".equals(utility.getMode())) {
            LOG.error("unpackageHspMode input wrong unpack mode: " + utility.getMode());
            throw new BundleException("Uncompress::unpackageHspMode input wrong unpack mode");
        }
        try {
            if (TRUE.equals(utility.getLibs())) {
                List<String> list = utility.getFormattedCpuAbiList();
                Uncompress.unpackageLibsMode(utility.getHspPath(), utility.getOutPath(), list);
                return;
            }
            Uncompress.dataTransferAllFiles(utility.getHspPath(), utility.getOutPath());
        }
        catch (BundleException bundleException) {
            LOG.error("Uncompress::unpackageHspMode failed");
            throw new BundleException("Uncompress::unpackageHspMode failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static UncompressResult uncompressAppByPath(Utility utility) {
        UncompressResult uncompressResult = new UncompressResult();
        Closeable closeable = null;
        String string = utility.getAppPath();
        String string2 = utility.getParseMode();
        try {
            if ("hap-list".equals(string2)) {
                uncompressResult = Uncompress.uncompress(utility.getDeviceType(), string, PACK_INFO);
            } else if ("hap-info".equals(string2)) {
                uncompressResult = Uncompress.uncompressHapAndHspFromAppPath(string, utility);
            } else if ("all".equals(string2)) {
                uncompressResult = Uncompress.uncompressAllAppByPath(string);
            } else {
                LOG.error("Uncompress::uncompressApp parseMode is invalid!");
                uncompressResult.setResult(false);
                uncompressResult.setMessage("ParseApp parseMode is invalid");
            }
            uncompressResult.setPackageSize(FileUtils.getFileSize(string));
        }
        catch (BundleException bundleException) {
            LOG.error("Uncompress::uncompressApp Bundle exception");
            uncompressResult.setResult(false);
            uncompressResult.setMessage("ParseApp Bundle exception");
        }
        finally {
            Utility.closeStream(closeable);
        }
        return uncompressResult;
    }

    private static UncompressResult uncompressHapAndHspFromAppPath(String string, Utility utility) throws BundleException {
        UncompressResult uncompressResult = new UncompressResult();
        String string2 = utility.getHapName();
        if (!string2.toLowerCase(Locale.ENGLISH).endsWith(".hap") && !string2.toLowerCase(Locale.ENGLISH).endsWith(HSP_SUFFIX)) {
            string2 = string2 + ".hap";
        }
        ZipFile zipFile = null;
        ZipEntry zipEntry = null;
        InputStream inputStream = null;
        try {
            zipFile = new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                zipEntry = enumeration.nextElement();
                inputStream = zipFile.getInputStream(zipEntry);
                if (!string2.equals(zipEntry.getName().toLowerCase(Locale.ENGLISH))) continue;
                UncompressResult uncompressResult2 = Uncompress.uncompressHapByStream("", inputStream, string2);
                if (uncompressResult2.getProfileInfos() == null || uncompressResult2.getProfileInfos().size() <= 0) break;
                uncompressResult2.getProfileInfos().get((int)0).hapInfo.originalSize = zipEntry.getSize();
                uncompressResult2.getProfileInfos().get((int)0).hapInfo.compressedSize = zipEntry.getCompressedSize();
                uncompressResult.addProfileInfo(uncompressResult2.getProfileInfos().get(0));
                uncompressResult.addProfileInfoStr(uncompressResult2.getProfileInfosStr().get(0));
            }
        }
        catch (IOException | BundleException exception) {
            try {
                LOG.error("uncompressHapFromAppPath failed: " + exception.getMessage());
                throw new BundleException("uncompressHapFromAppPath failed!");
            }
            catch (Throwable throwable) {
                Utility.closeStream(zipFile);
                Utility.closeStream(inputStream);
                throw throwable;
            }
        }
        Utility.closeStream(zipFile);
        Utility.closeStream(inputStream);
        return uncompressResult;
    }

    private static UncompressResult uncompressAllAppByPath(String string) throws BundleException {
        UncompressResult uncompressResult = new UncompressResult();
        ZipFile zipFile = null;
        ZipEntry zipEntry = null;
        InputStream inputStream = null;
        try {
            zipFile = new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                Object object;
                zipEntry = enumeration.nextElement();
                inputStream = zipFile.getInputStream(zipEntry);
                if (PACK_INFO.equals(zipEntry.getName().toLowerCase(Locale.ENGLISH))) {
                    object = ((Stream)new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().parallel()).collect(Collectors.joining(System.lineSeparator()));
                    List<PackInfo> list = JsonUtil.parseHapList("", (String)object);
                    uncompressResult.setPackInfoStr((String)object);
                    uncompressResult.setPackInfos(list);
                }
                if (!zipEntry.getName().toLowerCase(Locale.ENGLISH).endsWith(".hap") && !zipEntry.getName().toLowerCase(Locale.ENGLISH).endsWith(HSP_SUFFIX) || ((UncompressResult)(object = Uncompress.uncompressHapByStream("", inputStream, zipEntry.getName()))).getProfileInfos() == null || ((UncompressResult)object).getProfileInfos().size() <= 0) continue;
                ((UncompressResult)object).getProfileInfos().get((int)0).hapInfo.originalSize = zipEntry.getSize();
                ((UncompressResult)object).getProfileInfos().get((int)0).hapInfo.compressedSize = zipEntry.getCompressedSize();
                uncompressResult.addProfileInfo(((UncompressResult)object).getProfileInfos().get(0));
                uncompressResult.addProfileInfoStr(((UncompressResult)object).getProfileInfosStr().get(0));
            }
            uncompressResult = Uncompress.checkParseAllResult(uncompressResult);
            uncompressResult = Uncompress.obtainLabelAndIcon(uncompressResult);
        }
        catch (IOException | BundleException exception) {
            try {
                LOG.error("uncompressAllAppByPath failed: " + exception.getMessage());
                throw new BundleException("uncompressAllAppByPath failed!");
            }
            catch (Throwable throwable) {
                Utility.closeStream(zipFile);
                Utility.closeStream(inputStream);
                throw throwable;
            }
        }
        Utility.closeStream(zipFile);
        Utility.closeStream(inputStream);
        return uncompressResult;
    }

    static UncompressResult uncompressAppByInput(Utility utility, InputStream inputStream) {
        UncompressResult uncompressResult = new UncompressResult();
        String string = utility.getParseMode();
        try {
            if (!string.isEmpty() && "hap-list".equals(string)) {
                uncompressResult = Uncompress.uncompressByInput(utility.getDeviceType(), inputStream, PACK_INFO, "");
            } else if (!string.isEmpty() && "hap-info".equals(string)) {
                uncompressResult = Uncompress.uncompressHapFromAppStream(utility.getDeviceType(), inputStream, utility.getHapName());
            } else if (!string.isEmpty() && "all".equals(string)) {
                uncompressResult = Uncompress.uncompressAllFromAppStream(inputStream);
            } else {
                LOG.error("Uncompress::uncompressAppByInput parseMode is invalid!");
                uncompressResult.setResult(false);
                uncompressResult.setMessage("ParseApp parseMode is invalid");
            }
        }
        catch (BundleException bundleException) {
            LOG.error("Uncompress::uncompressAppByInput Bundle exception");
            uncompressResult.setResult(false);
            uncompressResult.setMessage("ParseApp Bundle exception");
        }
        return uncompressResult;
    }

    private static UncompressResult uncompressHapFromAppStream(String string, InputStream inputStream, String string2) throws BundleException {
        String string3 = string2;
        if (!string2.toLowerCase(Locale.ENGLISH).endsWith(".hap") && !string2.toLowerCase(Locale.ENGLISH).endsWith(HSP_SUFFIX)) {
            string3 = string3 + ".hap";
        }
        UncompressResult uncompressResult = new UncompressResult();
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(inputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.getName().toLowerCase(Locale.ENGLISH).equals(string3)) {
                    uncompressResult = Uncompress.uncompressHapByStream("", zipInputStream, zipEntry.getName());
                }
                if (uncompressResult.getProfileInfos().size() <= 0) continue;
                uncompressResult.getProfileInfos().get((int)0).hapInfo.originalSize = zipEntry.getSize();
                uncompressResult.getProfileInfos().get((int)0).hapInfo.compressedSize = zipEntry.getCompressedSize();
            }
        }
        catch (IOException iOException) {
            try {
                LOG.error("uncompressHapFromAppStream failed: " + iOException.getMessage());
                throw new BundleException("uncompressHapFromAppStream failed!");
            }
            catch (Throwable throwable) {
                Utility.closeStream(zipInputStream);
                throw throwable;
            }
        }
        Utility.closeStream(zipInputStream);
        return uncompressResult;
    }

    private static UncompressResult uncompressAllFromAppStream(InputStream inputStream) throws BundleException {
        UncompressResult uncompressResult = new UncompressResult();
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(inputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                Object object;
                if (PACK_INFO.equals(zipEntry.getName().toLowerCase(Locale.ENGLISH))) {
                    object = ((Stream)new BufferedReader(new InputStreamReader((InputStream)zipInputStream, StandardCharsets.UTF_8)).lines().parallel()).collect(Collectors.joining(System.lineSeparator()));
                    List<PackInfo> list = JsonUtil.parseHapList("", (String)object);
                    uncompressResult.setPackInfoStr((String)object);
                    uncompressResult.setPackInfos(list);
                }
                if (!zipEntry.getName().toLowerCase(Locale.ENGLISH).endsWith(".hap") && !zipEntry.getName().toLowerCase(Locale.ENGLISH).endsWith(HSP_SUFFIX) || ((UncompressResult)(object = Uncompress.uncompressHapByStream("", zipInputStream, zipEntry.getName()))).getProfileInfos() == null || ((UncompressResult)object).getProfileInfos().size() <= 0) continue;
                ((UncompressResult)object).getProfileInfos().get((int)0).hapInfo.originalSize = zipEntry.getSize();
                ((UncompressResult)object).getProfileInfos().get((int)0).hapInfo.compressedSize = zipEntry.getCompressedSize();
                uncompressResult.addProfileInfo(((UncompressResult)object).getProfileInfos().get(0));
                uncompressResult.addProfileInfoStr(((UncompressResult)object).getProfileInfosStr().get(0));
            }
            uncompressResult = Uncompress.checkParseAllResult(uncompressResult);
            uncompressResult = Uncompress.obtainLabelAndIcon(uncompressResult);
        }
        catch (IOException | BundleException exception) {
            try {
                LOG.error("uncompressAllFromAppStream failed: " + exception.getMessage());
                throw new BundleException("uncompressAllFromAppStream failed!");
            }
            catch (Throwable throwable) {
                Utility.closeStream(zipInputStream);
                throw throwable;
            }
        }
        Utility.closeStream(zipInputStream);
        return uncompressResult;
    }

    static UncompressResult uncompressHap(Utility utility) {
        UncompressResult uncompressResult = new UncompressResult();
        try {
            uncompressResult = Uncompress.uncompressHapByPath(utility.getDeviceType(), utility.getHapPath());
        }
        catch (BundleException bundleException) {
            LOG.error("Uncompress::uncompressHap Bundle exception");
            uncompressResult.setResult(false);
            uncompressResult.setMessage("uncompressHap Bundle exception");
        }
        return uncompressResult;
    }

    static UncompressResult uncompressHapByPath(String string, String string2) throws BundleException {
        UncompressResult uncompressResult = new UncompressResult();
        try {
            if (Uncompress.isModuleHap(string2, uncompressResult)) {
                uncompressResult = Uncompress.unCompressModuleHap(string, string2, MODULE_JSON);
            } else {
                uncompressResult = Uncompress.uncompress(string, string2, HARMONY_PROFILE);
                uncompressResult = Uncompress.obtainLabelAndIcon(uncompressResult);
            }
        }
        catch (BundleException bundleException) {
            LOG.error("Uncompress::uncompressHapByPath Bundle exception");
            throw new BundleException("Uncompress::uncompressHapByPath failed");
        }
        return uncompressResult;
    }

    static UncompressResult uncompressHapByInput(Utility utility, InputStream inputStream) {
        UncompressResult uncompressResult = new UncompressResult();
        try {
            uncompressResult = Uncompress.uncompressHapByStream(utility.getDeviceType(), inputStream, "");
        }
        catch (BundleException bundleException) {
            LOG.error("Uncompress::uncompressHapByInput Bundle exception");
            uncompressResult.setResult(false);
            uncompressResult.setMessage("uncompressHapByInput Bundle exception");
        }
        return uncompressResult;
    }

    static UncompressResult uncompressHapByStream(String string, InputStream inputStream, String string2) throws BundleException {
        UncompressResult uncompressResult = new UncompressResult();
        uncompressResult = Uncompress.uncompressHapByBigStream(string, inputStream, string2);
        return uncompressResult;
    }

    static UncompressResult uncompressHapByBigStream(String string, InputStream inputStream, String string2) throws BundleException {
        File file;
        FileInputStream fileInputStream;
        FileInputStream fileInputStream2;
        UncompressResult uncompressResult;
        block8: {
            uncompressResult = new UncompressResult();
            fileInputStream2 = null;
            fileInputStream = null;
            file = null;
            try {
                String string3 = System.getProperty("user.dir");
                File file2 = new File(string3);
                file = File.createTempFile(HAP_PREFIX, ".hap", file2);
                Uncompress.writeToTempFile(inputStream, file);
                fileInputStream2 = new FileInputStream(file);
                boolean bl = false;
                if (Uncompress.isModuleInput(fileInputStream2)) {
                    bl = true;
                }
                fileInputStream = new FileInputStream(file);
                if (bl) {
                    uncompressResult = Uncompress.uncompressModuleHapByInput(string, fileInputStream, MODULE_JSON, string2);
                    break block8;
                }
                uncompressResult = Uncompress.uncompressByInput(string, fileInputStream, HARMONY_PROFILE, string2);
                uncompressResult = Uncompress.obtainLabelAndIcon(uncompressResult);
            }
            catch (IOException iOException) {
                try {
                    LOG.error("uncompressHapByBigStream failed for IO exception: " + iOException.getMessage());
                    throw new BundleException("uncompressHapByBigStream failed for IO exception!");
                }
                catch (Throwable throwable) {
                    Utility.closeStream(fileInputStream2);
                    Utility.closeStream(fileInputStream);
                    if (file != null) {
                        FileUtils.deleteFile(file.getPath());
                    }
                    throw throwable;
                }
            }
        }
        Utility.closeStream(fileInputStream2);
        Utility.closeStream(fileInputStream);
        if (file != null) {
            FileUtils.deleteFile(file.getPath());
        }
        return uncompressResult;
    }

    private static void unzip(Utility utility, String string, String string2, String string3) throws BundleException {
        if (utility == null) {
            LOG.error("Uncompress::unzip utility is null!");
            throw new BundleException("Unzip failed, utility is null");
        }
        if (string.isEmpty() || !UncompressVerify.isPathValid(string, true, "")) {
            LOG.error("Uncompress::unzip srcPath is invalid!");
            throw new BundleException("Unzip failed, srcPath is invalid");
        }
        if (string2.isEmpty() || !UncompressVerify.isPathValid(string2, false, null)) {
            LOG.error("Uncompress::unzip destDirPath is invalid!");
            throw new BundleException("Unzip failed, destDirPath is invalid");
        }
        Uncompress.unzipFromFile(utility, string, string2, string3);
    }

    private static void unzipFromFile(Utility utility, String string, String string2, String string3) throws BundleException {
        ZipFile zipFile = null;
        String string4 = "";
        try {
            zipFile = new ZipFile(new File(string));
            if (utility != null && !utility.getDeviceType().isEmpty() && (".hap".equals(string3) || HSP_SUFFIX.equals(string3))) {
                List<PackInfo> list = Uncompress.uncompress(utility.getDeviceType(), string, PACK_INFO).getPackInfos();
                for (PackInfo object2 : list) {
                    string4 = string4 + object2.name + ",";
                }
            }
            int n = 0;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                Object object;
                ++n;
                ZipEntry zipEntry = enumeration.nextElement();
                String string5 = "";
                if (zipEntry == null || zipEntry.getName().isEmpty() || zipEntry.getName().toLowerCase().endsWith(CUT_ENTRY_FILENAME) && "false".equals(utility.getUnpackCutEntryApk()) || !(string5 = zipEntry.getName()).toLowerCase(Locale.ENGLISH).endsWith(string3) || !string4.isEmpty() && !string4.contains(string5.replace(string3, ""))) continue;
                String string6 = string2.replace(File.separator, LINUX_FILE_SEPARATOR);
                if (".hap".equals(string3) && TRUE.equals(utility.getUnpackApk()) && !((File)(object = new File(string6 = string6 + LINUX_FILE_SEPARATOR + string5.replace(string3, "")))).exists()) {
                    ((File)object).mkdir();
                }
                if (APK_SUFFIX.equals(string3) && TRUE.equals(utility.getUnpackApk()) && string5.contains(LINUX_FILE_SEPARATOR)) continue;
                object = string6 + LINUX_FILE_SEPARATOR + string5;
                if (!FileUtils.matchPattern((String)object)) {
                    LOG.error("Input invalid file: " + (String)object);
                    throw new BundleException("Input invalid file " + (String)object);
                }
                File file = new File((String)object);
                Uncompress.dataTransfer(zipFile, zipEntry, file);
                if (JSON_SUFFIX.equals(string3)) break;
                if (!".hap".equals(string3) || !TRUE.equals(utility.getUnpackApk())) continue;
                Uncompress.unzip(utility, (String)object, string6, APK_SUFFIX);
                Uncompress.repackHap((String)object, string6, string5, utility.getUnpackApk());
            }
        }
        catch (IOException | BundleException exception) {
            try {
                LOG.error("Uncompress::unzipInHapMode failed: " + exception.getMessage());
                throw new BundleException("Unzip in hap mode failed");
            }
            catch (Throwable throwable) {
                Utility.closeStream(zipFile);
                throw throwable;
            }
        }
        Utility.closeStream(zipFile);
    }

    private static void dataTransfer(ZipFile zipFile, ZipEntry zipEntry, File file) throws BundleException {
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            if (!FileUtils.matchPattern(file.getCanonicalPath())) {
                LOG.error("Input invalid file " + file.getCanonicalPath());
                throw new BundleException("Input invalid file" + file.getCanonicalPath());
            }
            inputStream = zipFile.getInputStream(zipEntry);
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[10240];
            int n = inputStream.read(byArray);
            int n2 = 0;
            while (n > 0) {
                fileOutputStream.write(byArray, 0, n);
                n2 += n;
                n = inputStream.read(byArray);
            }
        }
        catch (IOException | BundleException exception) {
            try {
                LOG.error("Uncompress::dataTransfer file " + exception.getMessage());
                throw new BundleException("DataTransfer failed");
            }
            catch (Throwable throwable) {
                Utility.closeStream(fileOutputStream);
                Utility.closeStream(inputStream);
                throw throwable;
            }
        }
        Utility.closeStream(fileOutputStream);
        Utility.closeStream(inputStream);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void dataTransferAllFiles(String string, String string2) throws BundleException {
        ZipFile zipFile = null;
        try {
            if (!FileUtils.matchPattern(string)) {
                throw new BundleException("Input invalid file " + string);
            }
            zipFile = new ZipFile(new File(string));
            int n = 0;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ++n;
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry == null) continue;
                String string3 = string2 + LINUX_FILE_SEPARATOR + zipEntry.getName();
                File file = new File(string3);
                if (file != null && file.getParentFile() != null && !file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                Uncompress.dataTransfer(zipFile, zipEntry, file);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                LOG.error("Uncompress::unzipApk file not found exception: " + fileNotFoundException.getMessage());
                throw new BundleException("Unzip Apk failed");
                catch (IOException iOException) {
                    LOG.error("Uncompress::unzipApk io exception: " + iOException.getMessage());
                    throw new BundleException("Unzip Apk failed");
                }
            }
            catch (Throwable throwable) {
                Utility.closeStream(zipFile);
                throw throwable;
            }
        }
        Utility.closeStream(zipFile);
    }

    private static void dataTransferFilesByApp(Utility utility, String string, String string2) throws BundleException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(new File(string));
            int n = 0;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                boolean bl;
                ++n;
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry == null) continue;
                String string3 = string2 + LINUX_FILE_SEPARATOR + zipEntry.getName();
                if (!FileUtils.matchPattern(string3)) {
                    throw new BundleException("Input invalid path " + string3);
                }
                File file = new File(string3);
                if (file != null && file.getParentFile() != null && !file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if ((bl = TRUE.equals(utility.getUnpackApk())) && string3.toLowerCase().endsWith(".hap")) {
                    Uncompress.dataTransfer(zipFile, zipEntry, file);
                    Uncompress.unzip(utility, string3, string2, APK_SUFFIX);
                    String[] stringArray = string3.replace("\\", LINUX_FILE_SEPARATOR).split(LINUX_FILE_SEPARATOR);
                    String string4 = "";
                    if (stringArray.length > 0) {
                        string4 = stringArray[stringArray.length - 1];
                    }
                    Uncompress.repackHap(string3, string2, string4, utility.getUnpackApk());
                    continue;
                }
                Uncompress.dataTransfer(zipFile, zipEntry, file);
            }
        }
        catch (IOException | BundleException exception) {
            try {
                LOG.error("Uncompress::unzipApk file failed " + exception.getMessage());
                throw new BundleException("Unzip Apk failed");
            }
            catch (Throwable throwable) {
                Utility.closeStream(zipFile);
                throw throwable;
            }
        }
        Utility.closeStream(zipFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getResourceDataFromHap(ZipFile zipFile) throws BundleException, IOException {
        byte[] byArray;
        int n = 0;
        InputStream inputStream = null;
        try {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ++n;
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry == null) continue;
                if (zipEntry == null || "".equals(zipEntry.getName()) || !zipEntry.getName().toLowerCase().endsWith(RESOURCE_INDEX)) break block4;
                inputStream = zipFile.getInputStream(zipEntry);
                byArray = Uncompress.getByte(inputStream);
            }
        }
        catch (Throwable throwable) {
            Utility.closeStream(inputStream);
            throw throwable;
        }
        {
            block4: {
                Utility.closeStream(inputStream);
                return byArray;
            }
            continue;
        }
        Utility.closeStream(inputStream);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HapZipInfo unZipHapFileFromHapFile(String string) throws BundleException, IOException {
        HapZipInfo hapZipInfo = new HapZipInfo();
        ZipFile zipFile = null;
        if (!FileUtils.matchPattern(string)) {
            LOG.error("Input invalid path " + string);
            throw new BundleException("Input invalid path " + string);
        }
        try {
            File file = new File(string);
            zipFile = new ZipFile(file);
            hapZipInfo.setHarmonyProfileJsonStr(FileUtils.getFileStringFromZip(HARMONY_PROFILE, zipFile));
            hapZipInfo.setResDataBytes(Uncompress.getResourceDataFromHap(zipFile));
            hapZipInfo.setPackInfoJsonStr(FileUtils.getFileStringFromZip(PACK_INFO, zipFile));
            hapZipInfo.setHapFileName(Uncompress.getHapNameWithoutSuffix(file.getName()));
        }
        catch (Throwable throwable) {
            Utility.closeStream(zipFile);
            throw throwable;
        }
        Utility.closeStream(zipFile);
        return hapZipInfo;
    }

    private static UncompressResult uncompress(String string, String string2, String string3) throws BundleException {
        if (string2.isEmpty() || string3.isEmpty()) {
            LOG.error("Uncompress::uncompress srcPath, fileName is empty!");
            throw new BundleException("Uncompress failed, srcPath or fileName is empty");
        }
        UncompressResult uncompressResult = new UncompressResult();
        try {
            HapZipInfo hapZipInfo = Uncompress.unZipHapFileFromHapFile(string2);
            if (Uncompress.isPackInfo(string3)) {
                Uncompress.uncompressPackInfo(string, hapZipInfo, uncompressResult);
            } else {
                Uncompress.uncompressProfileInfo(hapZipInfo, uncompressResult);
            }
        }
        catch (IOException iOException) {
            LOG.error("Uncompress::uncompress io exception: " + iOException.getMessage());
            throw new BundleException("Uncompress failed");
        }
        return uncompressResult;
    }

    private static void uncompressPackInfo(String string, HapZipInfo hapZipInfo, UncompressResult uncompressResult) throws BundleException {
        List<PackInfo> list = JsonUtil.parseHapList(string, hapZipInfo.getPackInfoJsonStr());
        uncompressResult.setPackInfoStr(hapZipInfo.getPackInfoJsonStr());
        uncompressResult.setPackInfos(list);
    }

    private static void uncompressProfileInfo(HapZipInfo hapZipInfo, UncompressResult uncompressResult) throws BundleException {
        ProfileInfo profileInfo = JsonUtil.parseProfileInfo(hapZipInfo.getHarmonyProfileJsonStr(), hapZipInfo.getResDataBytes(), hapZipInfo.getPackInfoJsonStr(), hapZipInfo.getHapFileName());
        profileInfo.hapName = hapZipInfo.getHapFileName();
        profileInfo.appInfo.setBundleType(Uncompress.getFABundleType(profileInfo));
        uncompressResult.addProfileInfoStr(hapZipInfo.getHarmonyProfileJsonStr());
        uncompressResult.addProfileInfo(profileInfo);
    }

    private static String getFABundleType(ProfileInfo profileInfo) {
        String string = "app";
        if (profileInfo.hapInfo.distro.installationFree == 1) {
            string = "atomicService";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HapZipInfo unZipHapFileFromInputStream(InputStream inputStream) throws BundleException, IOException {
        BufferedInputStream bufferedInputStream = null;
        ZipInputStream zipInputStream = null;
        BufferedReader bufferedReader = null;
        HapZipInfo hapZipInfo = new HapZipInfo();
        try {
            ZipEntry zipEntry = null;
            bufferedInputStream = new BufferedInputStream(inputStream);
            zipInputStream = new ZipInputStream(bufferedInputStream);
            int n = 0;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                ++n;
                if (zipEntry.getName().toLowerCase().endsWith(RESOURCE_INDEX)) {
                    hapZipInfo.setResDataBytes(Uncompress.getByte(zipInputStream));
                    continue;
                }
                if (Uncompress.isPackInfo(zipEntry.getName())) {
                    bufferedReader = new BufferedReader(new InputStreamReader(zipInputStream));
                    hapZipInfo.setPackInfoJsonStr(Uncompress.readStringFromInputStream(zipInputStream, bufferedReader));
                    continue;
                }
                if (!Uncompress.isHarmonyProfile(zipEntry.getName())) continue;
                bufferedReader = new BufferedReader(new InputStreamReader(zipInputStream));
                hapZipInfo.setHarmonyProfileJsonStr(Uncompress.readStringFromInputStream(zipInputStream, bufferedReader));
            }
        }
        catch (Throwable throwable) {
            Utility.closeStream(bufferedReader);
            Utility.closeStream(bufferedInputStream);
            Utility.closeStream(zipInputStream);
            throw throwable;
        }
        Utility.closeStream(bufferedReader);
        Utility.closeStream(bufferedInputStream);
        Utility.closeStream(zipInputStream);
        return hapZipInfo;
    }

    private static String readStringFromInputStream(ZipInputStream zipInputStream, BufferedReader bufferedReader) throws IOException {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static UncompressResult uncompressByInput(String string, InputStream inputStream, String string2, String string3) throws BundleException {
        UncompressResult uncompressResult = new UncompressResult();
        try {
            HapZipInfo hapZipInfo = Uncompress.unZipHapFileFromInputStream(inputStream);
            hapZipInfo.setHapFileName(string3);
            if (Uncompress.isPackInfo(string2)) {
                Uncompress.uncompressPackInfo(string, hapZipInfo, uncompressResult);
            } else {
                Uncompress.uncompressProfileInfo(hapZipInfo, uncompressResult);
            }
        }
        catch (IOException iOException) {
            LOG.error("Uncompress::uncompressByInput io exception: " + iOException.getMessage());
            throw new BundleException("Uncompress by input failed");
        }
        return uncompressResult;
    }

    private static ModuleResult uncompressModuleByInput(String string, InputStream inputStream, String string2, String string3) throws BundleException {
        ModuleResult moduleResult = new ModuleResult();
        try {
            HapZipInfo hapZipInfo = Uncompress.unZipModuleHapFileFromInputStream(inputStream);
            hapZipInfo.setHapFileName(string3);
            if (!Uncompress.isPackInfo(string2)) {
                Uncompress.uncompressModuleJsonInfo(hapZipInfo, moduleResult);
            }
        }
        catch (BundleException bundleException) {
            LOG.error("Uncompress::uncompressByInput io exception: " + bundleException.getMessage());
            throw new BundleException("Uncompress by input failed");
        }
        return moduleResult;
    }

    private static byte[] getByte(InputStream inputStream) throws BundleException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = null;
        try {
            byte[] byArray2 = new byte[1024];
            int n = 0;
            while ((n = inputStream.read(byArray2, 0, 1024)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            LOG.error("Uncompress::getByte io exception: " + iOException.getMessage());
            throw new BundleException("Get byte failed");
        }
        finally {
            Utility.closeStream(byteArrayOutputStream);
        }
        return byArray;
    }

    private static void repackHap(String string, String string2, String string3, String string4) throws BundleException {
        if (string.isEmpty() || string2.isEmpty() || string3.isEmpty()) {
            LOG.error("Uncompress::repackHap srcPath, destDirPath or fileName is empty!");
            throw new BundleException("Repack hap failed, srcPath, destDirPath or fileName is empty");
        }
        if (!UncompressVerify.isPathValid(string, true, "")) {
            LOG.error("Uncompress::repackHap srcPath is invalid!");
            throw new BundleException("Repack hap failed, srcPath is invalid");
        }
        if (!UncompressVerify.isPathValid(string2, false, null)) {
            LOG.error("Uncompress::repackHap destDirPath is invalid!");
            throw new BundleException("Repack hap failed, destDirPath is invalid");
        }
        String string5 = string2.replace(File.separator, LINUX_FILE_SEPARATOR) + LINUX_FILE_SEPARATOR + TEMP_PATH;
        Uncompress.dataTransferAllFiles(string, string5);
        Uncompress.packFilesByPath(string5, string2, string3, string4);
        File file = new File(string5);
        Uncompress.deleteFile(file);
    }

    private static void packFilesByPath(String string, String string2, String string3, String string4) throws BundleException {
        if (string.isEmpty() || string2.isEmpty() || string3.isEmpty()) {
            LOG.error("Uncompress::packFilesByPath srcPath, destDirPath or fileName is empty!");
            throw new BundleException("Pack files by path failed, srcPath, destDirPath or fileName is empty");
        }
        if (!UncompressVerify.isPathValid(string, false, null) || !UncompressVerify.isPathValid(string2, false, null)) {
            LOG.error("Uncompress::packFilesByPath srcPath or destDirPath is invalid!");
            throw new BundleException("Pack files by path failed, srcPath or destDirPath is invalid");
        }
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        FileOutputStream fileOutputStream = null;
        CheckedOutputStream checkedOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        try {
            String string5 = string2 + LINUX_FILE_SEPARATOR + string3;
            if (!FileUtils.matchPattern(string5)) {
                throw new BundleException("Input invalid file" + string5);
            }
            File file2 = new File(string5);
            fileOutputStream = new FileOutputStream(file2);
            checkedOutputStream = new CheckedOutputStream(fileOutputStream, new CRC32());
            zipOutputStream = new ZipOutputStream(checkedOutputStream);
            for (int i = 0; i < fileArray.length; ++i) {
                File file3 = fileArray[i];
                if (file3.isDirectory()) {
                    if (file3.getPath().toLowerCase(Locale.ENGLISH).endsWith("libs")) {
                        Uncompress.compressDirectory(file3, "", zipOutputStream, true);
                        continue;
                    }
                    Uncompress.compressDirectory(file3, "", zipOutputStream, false);
                    continue;
                }
                if (file3.getPath().toLowerCase(Locale.ENGLISH).endsWith(APK_SUFFIX) && TRUE.equals(string4)) continue;
                Uncompress.compressFile(file3, "", zipOutputStream, false);
            }
        }
        catch (FileNotFoundException | BundleException exception) {
            try {
                LOG.error("Uncompress::packFilesByPath " + exception.getMessage());
                throw new BundleException("Pack files by path failed");
            }
            catch (Throwable throwable) {
                Utility.closeStream(zipOutputStream);
                Utility.closeStream(checkedOutputStream);
                Utility.closeStream(fileOutputStream);
                throw throwable;
            }
        }
        Utility.closeStream(zipOutputStream);
        Utility.closeStream(checkedOutputStream);
        Utility.closeStream(fileOutputStream);
    }

    private static void compressDirectory(File file, String string, ZipOutputStream zipOutputStream, boolean bl) throws BundleException {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                Uncompress.compressDirectory(file2, string + file.getName() + File.separator, zipOutputStream, bl);
                continue;
            }
            Uncompress.compressFile(file2, string + file.getName() + File.separator, zipOutputStream, bl);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void compressFile(File file, String string, ZipOutputStream zipOutputStream, boolean bl) throws BundleException {
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            Object object;
            String string2 = (string + file.getName()).replace(File.separator, LINUX_FILE_SEPARATOR);
            ZipEntry zipEntry = new ZipEntry(string2);
            boolean bl2 = bl;
            if (file.isFile() && file.getName().toLowerCase(Locale.ENGLISH).endsWith(SO_SUFFIX)) {
                bl2 = false;
            }
            if (bl2) {
                zipEntry.setMethod(8);
            } else {
                zipEntry.setMethod(0);
                zipEntry.setCompressedSize(file.length());
                zipEntry.setSize(file.length());
                object = Uncompress.getCrcFromFile(file);
                zipEntry.setCrc(((CRC32)object).getValue());
            }
            zipOutputStream.putNextEntry(zipEntry);
            object = new byte[10240];
            fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            int n = bufferedInputStream.read((byte[])object);
            while (n > 0) {
                zipOutputStream.write((byte[])object, 0, n);
                n = bufferedInputStream.read((byte[])object);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                LOG.error("Uncompress::compressFile file not found exception: " + fileNotFoundException.getMessage());
                throw new BundleException("Compress file failed");
                catch (IOException iOException) {
                    LOG.error("Uncompress::compressFile io exception: " + iOException.getMessage());
                    throw new BundleException("Compress file failed");
                }
            }
            catch (Throwable throwable) {
                Utility.closeStream(fileInputStream);
                Utility.closeStream(bufferedInputStream);
                throw throwable;
            }
        }
        Utility.closeStream(fileInputStream);
        Utility.closeStream(bufferedInputStream);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static CRC32 getCrcFromFile(File file) throws BundleException {
        FileInputStream fileInputStream = null;
        CRC32 cRC32 = new CRC32();
        try {
            fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[10240];
            int n = fileInputStream.read(byArray);
            while (n > 0) {
                cRC32.update(byArray, 0, n);
                n = fileInputStream.read(byArray);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                LOG.error("Uncompressor::getCrcFromFile file not found exception");
                throw new BundleException("Get Crc from file failed");
                catch (IOException iOException) {
                    LOG.error("Uncompressor::getCrcFromFile io exception: " + iOException.getMessage());
                    throw new BundleException("Get Crc from file failed");
                }
            }
            catch (Throwable throwable) {
                Utility.closeStream(fileInputStream);
                throw throwable;
            }
        }
        Utility.closeStream(fileInputStream);
        return cRC32;
    }

    private static void deleteFile(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    Uncompress.deleteFile(fileArray[i]);
                }
            }
            file.delete();
        }
    }

    private static UncompressResult checkParseAllResult(UncompressResult uncompressResult) {
        UncompressResult uncompressResult2 = new UncompressResult();
        uncompressResult2.setResult(false);
        uncompressResult2.setMessage("App package is invalid.");
        if (uncompressResult == null || uncompressResult.getPackInfos() == null || uncompressResult.getProfileInfos() == null) {
            return uncompressResult2;
        }
        List<PackInfo> list = uncompressResult.getPackInfos();
        List<ProfileInfo> list2 = uncompressResult.getProfileInfos();
        int n = list.size();
        int n2 = list2.size();
        if (n == 0 || n2 == 0 || n != n2) {
            LOG.error("Uncompress::checkParseAllResult error, hapNum is invalid in app");
            return uncompressResult2;
        }
        for (int i = 0; i < n; ++i) {
            if (list.get(i) == null || list.get((int)i).name.isEmpty()) {
                return uncompressResult2;
            }
            boolean bl = false;
            for (int j = 0; j < n2; ++j) {
                if (list2.get(j) == null || list2.get((int)j).hapName.isEmpty()) {
                    return uncompressResult2;
                }
                if (!Uncompress.comparePackAndProfile(list.get(i), list2.get(j))) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return uncompressResult2;
        }
        return uncompressResult;
    }

    private static UncompressResult obtainLabelAndIcon(UncompressResult uncompressResult) {
        List<ProfileInfo> list = uncompressResult.getProfileInfos();
        if (list.isEmpty()) {
            return uncompressResult;
        }
        for (ProfileInfo profileInfo : list) {
            String string;
            Distro distro;
            HapInfo hapInfo;
            if (profileInfo == null || (hapInfo = profileInfo.hapInfo) == null || (distro = hapInfo.distro) == null || !ENTRY_TYPE.equals((string = distro.moduleType).toLowerCase(Locale.ENGLISH))) continue;
            return Uncompress.obtainInnerLabelAndIcon(uncompressResult, hapInfo, distro);
        }
        return uncompressResult;
    }

    private static UncompressResult obtainInnerLabelAndIcon(UncompressResult uncompressResult, HapInfo hapInfo, Distro distro) {
        List<AbilityInfo> list = hapInfo.abilities;
        if (list == null || list.isEmpty()) {
            uncompressResult.setLabel(distro.moduleName);
            return uncompressResult;
        }
        int n = 0;
        for (AbilityInfo abilityInfo : list) {
            if (abilityInfo == null) {
                ++n;
                continue;
            }
            if (abilityInfo.skills == null || abilityInfo.skills.isEmpty()) continue;
            for (SkillInfo skillInfo : abilityInfo.skills) {
                if (skillInfo == null) continue;
                List<String> list2 = skillInfo.actions;
                List<String> list3 = skillInfo.entities;
                if (list2.isEmpty() || !list2.contains(SYSTEM_ACTION) && !list2.contains(SYSTEM_WANT_HOME) || list3.isEmpty() || !list3.contains(SYSTEM_ENTITY)) continue;
                uncompressResult.setLabel(abilityInfo.label);
                uncompressResult.setIcon(abilityInfo.icon);
                return uncompressResult;
            }
        }
        if (n == list.size()) {
            uncompressResult.setLabel(distro.moduleName);
            return uncompressResult;
        }
        for (AbilityInfo abilityInfo : list) {
            if (abilityInfo == null) continue;
            uncompressResult.setLabel(abilityInfo.label);
            uncompressResult.setIcon(abilityInfo.icon);
            break;
        }
        return uncompressResult;
    }

    private static boolean isHarmonyProfile(String string) {
        return HARMONY_PROFILE.equals(string);
    }

    private static boolean isPackInfo(String string) {
        return PACK_INFO.equals(string);
    }

    private static String getHapNameWithoutSuffix(String string) {
        if (string == null || string.isEmpty() || string.lastIndexOf(".") == -1) {
            return "";
        }
        return string.substring(0, string.lastIndexOf("."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HapZipInfo unZipModuleHapFile(String string) throws BundleException, IOException {
        HapZipInfo hapZipInfo = new HapZipInfo();
        ZipFile zipFile = null;
        try {
            File file = new File(string);
            zipFile = new ZipFile(file);
            Uncompress.getProfileJson(zipFile, hapZipInfo.resourcemMap);
            hapZipInfo.setHarmonyProfileJsonStr(FileUtils.getFileStringFromZip(MODULE_JSON, zipFile));
            hapZipInfo.setPackInfoJsonStr(FileUtils.getFileStringFromZip(PACK_INFO, zipFile));
            hapZipInfo.setResDataBytes(Uncompress.getResourceDataFromHap(zipFile));
            hapZipInfo.setHapFileName(Uncompress.getHapNameWithoutSuffix(file.getName()));
        }
        catch (Throwable throwable) {
            Utility.closeStream(zipFile);
            throw throwable;
        }
        Utility.closeStream(zipFile);
        return hapZipInfo;
    }

    private static void uncompressModuleJsonInfo(HapZipInfo hapZipInfo, ModuleResult moduleResult) throws BundleException {
        ModuleProfileInfo moduleProfileInfo = JsonUtil.parseModuleProfileInfo(hapZipInfo.getHarmonyProfileJsonStr(), hapZipInfo.getResDataBytes(), hapZipInfo.getPackInfoJsonStr(), hapZipInfo.getHapFileName(), hapZipInfo.resourcemMap);
        moduleProfileInfo.hapName = hapZipInfo.getHapFileName();
        moduleResult.addModuleProfileInfo(moduleProfileInfo);
        moduleResult.moduleProfileStr.add(hapZipInfo.getHarmonyProfileJsonStr());
    }

    private static ModuleResult uncompressModule(String string, String string2, String string3) throws BundleException {
        if (string2.isEmpty() || string3.isEmpty()) {
            LOG.error("Uncompress::uncompressModule srcPath, fileName is empty!");
            throw new BundleException("uncompressModule failed, srcPath or fileName is empty");
        }
        ModuleResult moduleResult = new ModuleResult();
        try {
            HapZipInfo hapZipInfo = Uncompress.unZipModuleHapFile(string2);
            Uncompress.uncompressModuleJsonInfo(hapZipInfo, moduleResult);
            if (moduleResult.packInfos.isEmpty() && !hapZipInfo.getPackInfoJsonStr().isEmpty()) {
                moduleResult.packInfos = JsonUtil.parsePackInfos(hapZipInfo.getPackInfoJsonStr());
            }
        }
        catch (IOException iOException) {
            moduleResult.setResult(false);
            LOG.error("Uncompress::uncompressModule parseMode is invalid!");
        }
        return moduleResult;
    }

    static UncompressResult unCompressModuleHap(String string, String string2, String string3) throws BundleException {
        if (string2.isEmpty() || string3.isEmpty()) {
            LOG.error("Uncompress::uncompress srcPath, fileName is empty!");
            throw new BundleException("Uncompress failed, srcPath or fileName is empty");
        }
        UncompressResult uncompressResult = new UncompressResult();
        ModuleResult moduleResult = new ModuleResult();
        try {
            moduleResult = Uncompress.uncompressModule(string, string2, string3);
            ModuleAdaption moduleAdaption = new ModuleAdaption();
            uncompressResult = moduleAdaption.convertToUncompressResult(moduleResult);
        }
        catch (BundleException bundleException) {
            LOG.error("Uncompress::uncompressHap Bundle exception");
            uncompressResult.setResult(false);
            uncompressResult.setMessage("uncompressHap Bundle exception");
        }
        return uncompressResult;
    }

    static void getProfileJson(ZipFile zipFile, HashMap<String, String> hashMap) throws BundleException {
        try {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (!zipEntry.getName().contains(RESOURCE_PATH)) continue;
                String string = zipEntry.getName();
                String string2 = string.replaceAll(RESOURCE_PATH, "");
                String string3 = FileUtils.getFileStringFromZip(string, zipFile);
                hashMap.put(string2, string3);
            }
        }
        catch (IOException iOException) {
            LOG.error("Uncompress::getProfileJson IOException");
            throw new BundleException("Uncompress::getProfileJson failed");
        }
    }

    static UncompressResult uncompressModuleHapByInput(String string, InputStream inputStream, String string2, String string3) {
        UncompressResult uncompressResult = new UncompressResult();
        ModuleResult moduleResult = new ModuleResult();
        try {
            moduleResult = Uncompress.uncompressModuleByInput(string, inputStream, MODULE_JSON, string3);
            ModuleAdaption moduleAdaption = new ModuleAdaption();
            uncompressResult = moduleAdaption.convertToUncompressResult(moduleResult);
        }
        catch (BundleException bundleException) {
            LOG.error("Uncompress::uncompressHapByInput Bundle exception");
            uncompressResult.setResult(false);
            uncompressResult.setMessage("uncompressHapByInput Bundle exception");
        }
        return uncompressResult;
    }

    private static HapZipInfo unZipModuleHapFileFromInputStream(InputStream inputStream) throws BundleException {
        BufferedInputStream bufferedInputStream = null;
        ZipInputStream zipInputStream = null;
        BufferedReader bufferedReader = null;
        HapZipInfo hapZipInfo = new HapZipInfo();
        try {
            ZipEntry zipEntry = null;
            bufferedInputStream = new BufferedInputStream(inputStream);
            zipInputStream = new ZipInputStream(bufferedInputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.getName().toLowerCase().endsWith(RESOURCE_INDEX)) {
                    hapZipInfo.setResDataBytes(Uncompress.getByte(zipInputStream));
                    continue;
                }
                if (Uncompress.isPackInfo(zipEntry.getName())) {
                    bufferedReader = new BufferedReader(new InputStreamReader(zipInputStream));
                    hapZipInfo.setPackInfoJsonStr(Uncompress.readStringFromInputStream(zipInputStream, bufferedReader));
                    continue;
                }
                if (MODULE_JSON.equals(zipEntry.getName())) {
                    bufferedReader = new BufferedReader(new InputStreamReader(zipInputStream));
                    hapZipInfo.setHarmonyProfileJsonStr(Uncompress.readStringFromInputStream(zipInputStream, bufferedReader));
                }
                if (!zipEntry.getName().contains(RESOURCE_PATH)) continue;
                bufferedReader = new BufferedReader(new InputStreamReader(zipInputStream));
                String string = zipEntry.getName();
                String string2 = string.replaceAll(RESOURCE_PATH, "");
                String string3 = Uncompress.readStringFromInputStream(zipInputStream, bufferedReader);
                hapZipInfo.pushResourceMap(string2, string3);
            }
        }
        catch (IOException | BundleException exception) {
            try {
                LOG.error("unZipModuleHapFileFromInputStream failed!");
                throw new BundleException("unZipModuleHapFileFromInputStream failed!");
            }
            catch (Throwable throwable) {
                Utility.closeStream(bufferedReader);
                Utility.closeStream(bufferedInputStream);
                Utility.closeStream(zipInputStream);
                throw throwable;
            }
        }
        Utility.closeStream(bufferedReader);
        Utility.closeStream(bufferedInputStream);
        Utility.closeStream(zipInputStream);
        return hapZipInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isModuleHap(String string, UncompressResult uncompressResult) {
        boolean bl;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(new File(string));
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (!MODULE_JSON.equals(zipEntry.getName())) continue;
                bl = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOG.error("Uncompress::isModuleHap file not found exception");
            uncompressResult.setResult(false);
            uncompressResult.setMessage("judge is module failed");
            {
                catch (Throwable throwable) {
                    Utility.closeStream(zipFile);
                    throw throwable;
                }
            }
            Utility.closeStream(zipFile);
            return false;
            catch (IOException iOException) {
                LOG.error("Uncompress::isModuleHap io exception: " + iOException.getMessage());
                uncompressResult.setResult(false);
                uncompressResult.setMessage("judge is module failed");
                Utility.closeStream(zipFile);
                return false;
            }
        }
        Utility.closeStream(zipFile);
        return false;
        Utility.closeStream(zipFile);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isModuleInput(InputStream inputStream) throws BundleException {
        Closeable closeable;
        ZipInputStream zipInputStream;
        BufferedInputStream bufferedInputStream;
        block6: {
            boolean bl;
            block5: {
                bufferedInputStream = null;
                zipInputStream = null;
                closeable = null;
                try {
                    ZipEntry zipEntry = null;
                    bufferedInputStream = new BufferedInputStream(inputStream);
                    zipInputStream = new ZipInputStream(bufferedInputStream);
                    while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                        if (!zipEntry.getName().toLowerCase().endsWith(MODULE_JSON)) continue;
                        bl = true;
                        break block5;
                    }
                    break block6;
                }
                catch (IOException iOException) {
                    try {
                        LOG.error("Uncompress::isModuleHap judge failed!");
                        throw new BundleException("Uncompress::isModuleHap judge failed!");
                    }
                    catch (Throwable throwable) {
                        Utility.closeStream(closeable);
                        Utility.closeStream(bufferedInputStream);
                        Utility.closeStream(zipInputStream);
                        throw throwable;
                    }
                }
            }
            Utility.closeStream(closeable);
            Utility.closeStream(bufferedInputStream);
            Utility.closeStream(zipInputStream);
            return bl;
        }
        Utility.closeStream(closeable);
        Utility.closeStream(bufferedInputStream);
        Utility.closeStream(zipInputStream);
        return false;
    }

    static void writeToTempFile(InputStream inputStream, File file) throws BundleException {
        FileOutputStream fileOutputStream = null;
        try {
            if (file == null) {
                LOG.error("file not exist!");
            }
            fileOutputStream = new FileOutputStream(file);
            int n = 0;
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            try {
                LOG.error("writeToTempFile failed!");
                throw new BundleException("writeToTempFile failed!");
            }
            catch (Throwable throwable) {
                Utility.closeStream(fileOutputStream);
                throw throwable;
            }
        }
        Utility.closeStream(fileOutputStream);
    }

    static void getRpcidFromHap(String string, String string2) throws BundleException {
        FileOutputStream fileOutputStream;
        InputStream inputStream;
        ZipFile zipFile;
        block8: {
            zipFile = null;
            inputStream = null;
            fileOutputStream = null;
            try {
                Object object;
                zipFile = new ZipFile(string);
                String string3 = null;
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    if (!RPCID_SC.equals(((ZipEntry)object).getName())) continue;
                    string3 = ((ZipEntry)object).getName();
                    break;
                }
                if (string3 != null) {
                    object = new File(string2, RPCID_SC);
                    if (((File)object).getParentFile() != null && !((File)object).getParentFile().exists()) {
                        ((File)object).getParentFile().mkdirs();
                    }
                    ZipEntry zipEntry = zipFile.getEntry(string3);
                    inputStream = zipFile.getInputStream(zipEntry);
                    byte[] byArray = new byte[1024];
                    int n = 0;
                    fileOutputStream = new FileOutputStream((File)object);
                    while ((n = inputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                    break block8;
                }
                LOG.error("Uncompress::getRpcidFromHap hap has no rpcid.sc file");
                throw new BundleException("Uncompress::getRpcidFromHap hap has no rpcid.sc file");
            }
            catch (IOException iOException) {
                try {
                    LOG.error("Uncompress::getRpcidFromHap IOException " + iOException.getMessage());
                    throw new BundleException("Uncompress::getRpcidFromHap failed");
                }
                catch (Throwable throwable) {
                    Utility.closeStream(zipFile);
                    Utility.closeStream(inputStream);
                    Utility.closeStream(fileOutputStream);
                    throw throwable;
                }
            }
        }
        Utility.closeStream(zipFile);
        Utility.closeStream(inputStream);
        Utility.closeStream(fileOutputStream);
    }

    static void unpackageLibsMode(String string, String string2, List<String> list) throws BundleException {
        String string3 = string.replace("\\", LINUX_FILE_SEPARATOR);
        String string4 = string2.replace("\\", LINUX_FILE_SEPARATOR);
        String string5 = string4 + LINUX_FILE_SEPARATOR + TEMP_PATH;
        try {
            List<String> list2 = Uncompress.getLibsFromPackageAndUnpackage(string3, string5, list);
            Uncompress.repackPackage(string3, string4, string5, list2);
        }
        catch (BundleException bundleException) {
            LOG.error("Uncompress::unpackageLibsMode failed.");
            throw new BundleException("Uncompress::unpackageLibsMode failed");
        }
        finally {
            File file = new File(string5);
            Uncompress.deleteFile(file);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List<String> getLibsFromPackageAndUnpackage(String string2, String string3, List<String> list) throws BundleException {
        try (ZipFile zipFile = new ZipFile(string2);){
            Cloneable cloneable;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            HashSet<String> hashSet = new HashSet<String>();
            while (enumeration.hasMoreElements()) {
                File file;
                String string4;
                cloneable = enumeration.nextElement();
                if (((ZipEntry)cloneable).getName().startsWith("libs/")) {
                    string4 = ((ZipEntry)cloneable).getName().substring("libs".length() + 1).split(LINUX_FILE_SEPARATOR)[0];
                    if (!list.isEmpty() && !list.contains(string4)) continue;
                    hashSet.add(string4);
                    file = new File(string3, ((ZipEntry)cloneable).getName().substring("libs".length() + 1));
                    FileUtils.createParentDir(file);
                    try {
                        InputStream inputStream = zipFile.getInputStream((ZipEntry)cloneable);
                        Throwable throwable = null;
                        try {
                            FileOutputStream fileOutputStream = new FileOutputStream(file);
                            Throwable throwable2 = null;
                            try {
                                FileUtils.copyStream(inputStream, fileOutputStream);
                                continue;
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (fileOutputStream == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        fileOutputStream.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                fileOutputStream.close();
                                continue;
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (inputStream == null) continue;
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            inputStream.close();
                            continue;
                        }
                    }
                    catch (IOException iOException) {
                        LOG.error("Uncompress::getLibsFromPackageAndUnpackage IOException " + iOException.getMessage());
                        throw new BundleException("Uncompress::getLibsFromPackageAndUnpackage failed");
                    }
                }
                string4 = string3 + LINUX_FILE_SEPARATOR + PACKAGEFILE + LINUX_FILE_SEPARATOR + ((ZipEntry)cloneable).getName();
                file = new File(string4);
                FileUtils.createParentDir(file);
                Uncompress.dataTransfer(zipFile, cloneable, file);
            }
            if (hashSet.size() != list.size() && !list.isEmpty()) {
                cloneable = list.stream().filter(string -> !hashSet.contains(string)).collect(Collectors.toList());
                LOG.error("The specified abi does not exist, " + cloneable);
                throw new BundleException("Uncompress::getLibsFromPackageAndUnpackage failed");
            }
            if (hashSet.size() > 128 && list.isEmpty()) {
                LOG.error("Uncompress::getLibsFromPackageAndUnpackage failed: the architecture type exceeds the limit and must be less than or equal to 128");
                throw new BundleException("Uncompress::getLibsFromPackageAndUnpackage failed");
            }
            if (hashSet.isEmpty()) {
                LOG.error("Uncompress::getLibsFromPackageAndUnpackage failed: libs has no CPU ABI");
                throw new BundleException("Uncompress::getLibsFromPackageAndUnpackage failed");
            }
            cloneable = new ArrayList<String>(hashSet);
            return cloneable;
        }
        catch (IOException iOException) {
            LOG.error("Uncompress::getLibsFromPackageAndUnpackage IOException " + iOException.getMessage());
            throw new BundleException("Uncompress::getLibsFromPackageAndUnpackage failed");
        }
    }

    private static void repackPackage(String string, String string2, String string3, List<String> list) throws BundleException {
        File file = new File(string3 + LINUX_FILE_SEPARATOR + PACKAGEFILE);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        String[] stringArray = string.split(LINUX_FILE_SEPARATOR);
        if (stringArray.length == 0) {
            LOG.error("Uncompress::repackPackage failed: Wrong file path");
            throw new BundleException("Uncompress::repackPackage failed");
        }
        String string4 = stringArray[stringArray.length - 1];
        for (String string5 : list) {
            Uncompress.processCpuAbi(string2, string4, string5, fileArray, string3);
        }
    }

    private static void processCpuAbi(String string, String string2, String string3, File[] fileArray, String string4) throws BundleException {
        String string5 = string + LINUX_FILE_SEPARATOR + string3 + LINUX_FILE_SEPARATOR + string2;
        File file = new File(string5);
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string5));){
            Uncompress.compressSourceFiles(fileArray, zipOutputStream);
            File file2 = new File(string4 + LINUX_FILE_SEPARATOR + string3);
            Uncompress.compressDirectory(file2, "libs/", zipOutputStream, true);
        }
        catch (IOException iOException) {
            LOG.error("Uncompress::processCpuAbi IOException for path: " + string5 + " - " + iOException.getMessage());
            throw new BundleException("Uncompress::processCpuAbi failed for path: " + string5);
        }
    }

    private static void compressSourceFiles(File[] fileArray, ZipOutputStream zipOutputStream) throws IOException, BundleException {
        for (File file : fileArray) {
            if (file.isDirectory()) {
                Uncompress.compressDirectory(file, "", zipOutputStream, false);
                continue;
            }
            Uncompress.compressFile(file, "", zipOutputStream, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<ResourceIndexResult> getResourceFromHap(String string) throws BundleException, IOException {
        List<ResourceIndexResult> list;
        ZipFile zipFile = null;
        try {
            File file = new File(string);
            zipFile = new ZipFile(file);
            byte[] byArray = Uncompress.getResourceDataFromHap(zipFile);
            list = ResourcesParser.getAllDataItem(byArray);
        }
        catch (Throwable throwable) {
            Utility.closeStream(zipFile);
            throw throwable;
        }
        Utility.closeStream(zipFile);
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void uncompressAPPQFFile(Utility utility) throws BundleException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(new File(utility.getAPPQFPath()));
            int n = 0;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ++n;
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry == null) continue;
                String string = utility.getOutPath() + File.separator + zipEntry.getName();
                if (!FileUtils.matchPattern(string)) {
                    LOG.error("uncompressAPPQFFile: Input invalid file" + string);
                    throw new BundleException("uncompressAPPQFFile: Input invalid file" + string);
                }
                File file = new File(string);
                if (file != null && file.getParentFile() != null && !file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                Uncompress.dataTransfer(zipFile, zipEntry, file);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                LOG.error("Uncompress::uncompressAPPQFFile file not found exception");
                throw new BundleException("Uncompress::uncompressAPPQFFile file not found");
                catch (IOException iOException) {
                    LOG.error("Uncompress::uncompressAPPQFFile io exception");
                    throw new BundleException("Uncompress::uncompressAPPQFFile io exception");
                }
            }
            catch (Throwable throwable) {
                Utility.closeStream(zipFile);
                throw throwable;
            }
        }
        Utility.closeStream(zipFile);
    }

    public static List<HQFInfo> parseAPPQFFile(String string) throws BundleException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ZipFile zipFile = null;
        InputStream inputStream = null;
        ZipInputStream zipInputStream = null;
        try {
            zipFile = new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                String string2;
                ZipEntry zipEntry = enumeration.nextElement();
                inputStream = zipFile.getInputStream(zipEntry);
                if (!zipEntry.getName().endsWith(HQF_SUFFIX) || (string2 = Uncompress.readPatchJson(zipInputStream = new ZipInputStream(inputStream))) == null) continue;
                arrayList.add(string2);
            }
        }
        catch (IOException iOException) {
            try {
                LOG.error("parseAPPQFFile failed!");
                throw new BundleException("parseAPPQFFile failed!");
            }
            catch (Throwable throwable) {
                Utility.closeStream(zipFile);
                Utility.closeStream(inputStream);
                Utility.closeStream(zipInputStream);
                throw throwable;
            }
        }
        Utility.closeStream(zipFile);
        Utility.closeStream(inputStream);
        Utility.closeStream(zipInputStream);
        return Uncompress.parsePatchJson(arrayList);
    }

    private static String readPatchJson(ZipInputStream zipInputStream) throws BundleException {
        String string = null;
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!PATCH_JSON.equals(zipEntry.getName())) continue;
                string = ((Stream)new BufferedReader(new InputStreamReader((InputStream)zipInputStream, StandardCharsets.UTF_8)).lines().parallel()).collect(Collectors.joining(System.lineSeparator()));
            }
        }
        catch (IOException iOException) {
            LOG.error("readPatchJson failed!");
            throw new BundleException("readPatchJson failed!");
        }
        return string;
    }

    private static List<HQFInfo> parsePatchJson(List<String> list) throws BundleException {
        ArrayList<HQFInfo> arrayList = new ArrayList<HQFInfo>();
        for (String string : list) {
            arrayList.add(JsonUtil.parsePatch(string));
        }
        return arrayList;
    }

    private static boolean comparePackAndProfile(PackInfo packInfo, ProfileInfo profileInfo) {
        if (profileInfo.hapName.replace(".hap", "").equals(packInfo.name.replace(".hap", ""))) {
            return true;
        }
        return profileInfo.hapName.replace(HSP_SUFFIX, "").equals(packInfo.name.replace(HSP_SUFFIX, ""));
    }
}

