/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.webwolf.requests;

import com.google.common.collect.EvictingQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.owasp.webgoat.webwolf.requests.WebWolfTraceRepository;
import org.springframework.boot.actuate.web.exchanges.HttpExchange;
import org.springframework.boot.actuate.web.exchanges.HttpExchangeRepository;

public class WebWolfTraceRepository
implements HttpExchangeRepository {
    private final EvictingQueue<HttpExchange> traces = EvictingQueue.create((int)10000);
    private final List<Exclusion> exclusionList = List.of(Exclusion.contains((String)"/tmpdir"), Exclusion.contains((String)"/home"), Exclusion.endsWith((String)"/files"), Exclusion.contains((String)"/images/"), Exclusion.contains((String)"/js/"), Exclusion.contains((String)"/webjars/"), Exclusion.contains((String)"/requests"), Exclusion.contains((String)"/css/"), Exclusion.contains((String)"/mail"));

    public List<HttpExchange> findAll() {
        return new ArrayList<HttpExchange>((Collection<HttpExchange>)this.traces);
    }

    private boolean isInExclusionList(String path) {
        return this.exclusionList.stream().anyMatch(e -> e.matches(path));
    }

    public void add(HttpExchange httpTrace) {
        String path = httpTrace.getRequest().getUri().getPath();
        if (!this.isInExclusionList(path)) {
            this.traces.add((Object)httpTrace);
        }
    }
}

