/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.webwolf.requests;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.owasp.webgoat.webwolf.requests.Requests;
import org.owasp.webgoat.webwolf.requests.WebWolfTraceRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.web.exchanges.HttpExchange;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/requests"})
public class Requests {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Requests.class);
    private final WebWolfTraceRepository traceRepository;
    private final ObjectMapper objectMapper;

    @GetMapping
    public ModelAndView get(Authentication authentication) {
        ModelAndView model = new ModelAndView("requests");
        String username = null != authentication ? authentication.getName() : "anonymous";
        List<Tracert> traces = this.traceRepository.findAll().stream().filter(t -> this.allowedTrace(t, username)).map(t -> new Tracert(this, t.getTimestamp(), this.path(t), this.toJsonString(t))).toList();
        model.addObject("traces", traces);
        return model;
    }

    private boolean allowedTrace(HttpExchange t, String username) {
        HttpExchange.Request req = t.getRequest();
        boolean allowed = true;
        if (req.getUri().getPath().contains("/files") && !req.getUri().getPath().contains(username)) {
            allowed = false;
        } else if (req.getUri().getPath().contains("/landing") && req.getUri().getQuery() != null && req.getUri().getQuery().contains("uniqueCode") && !req.getUri().getQuery().contains(StringUtils.reverse((String)username))) {
            allowed = false;
        }
        return allowed;
    }

    private String path(HttpExchange t) {
        return t.getRequest().getUri().getPath();
    }

    private String toJsonString(HttpExchange t) {
        try {
            return this.objectMapper.writeValueAsString((Object)t);
        }
        catch (JsonProcessingException e) {
            log.error("Unable to create json", (Throwable)e);
            return "No request(s) found";
        }
    }

    @Generated
    public Requests(WebWolfTraceRepository traceRepository, ObjectMapper objectMapper) {
        this.traceRepository = traceRepository;
        this.objectMapper = objectMapper;
    }
}

