/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.webwolf.mailbox;

import java.util.List;
import lombok.Generated;
import org.owasp.webgoat.webwolf.mailbox.Email;
import org.owasp.webgoat.webwolf.mailbox.MailboxRepository;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
public class MailboxController {
    private final MailboxRepository mailboxRepository;

    @GetMapping(value={"/mail"})
    public ModelAndView mail(Authentication authentication, Model model) {
        String username = null != authentication ? authentication.getName() : "anonymous";
        ModelAndView modelAndView = new ModelAndView();
        List emails = this.mailboxRepository.findByRecipientOrderByTimeDesc(username);
        if (emails != null && !emails.isEmpty()) {
            modelAndView.addObject("total", (Object)emails.size());
            modelAndView.addObject("emails", (Object)emails);
        }
        modelAndView.setViewName("mailbox");
        model.addAttribute("username", (Object)username);
        return modelAndView;
    }

    @PostMapping(value={"/mail"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public void sendEmail(@RequestBody Email email) {
        this.mailboxRepository.save((Object)email);
    }

    @DeleteMapping(value={"/mail"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void deleteAllMail() {
        this.mailboxRepository.deleteAll();
    }

    @Generated
    public MailboxController(MailboxRepository mailboxRepository) {
        this.mailboxRepository = mailboxRepository;
    }
}

