/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.webwolf.mailbox;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import lombok.Generated;
import org.owasp.webgoat.webwolf.mailbox.Email;

@Entity
public class Email
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @JsonIgnore
    private LocalDateTime time = LocalDateTime.now();
    @Column(length=1024)
    private String contents;
    private String sender;
    private String title;
    private String recipient;

    public String getSummary() {
        return "-" + this.contents.substring(0, Math.min(50, this.contents.length()));
    }

    public LocalDateTime getTimestamp() {
        return this.time;
    }

    public String getTime() {
        return DateTimeFormatter.ofPattern("h:mm a").format(this.time);
    }

    public String getShortSender() {
        return this.sender.substring(0, this.sender.indexOf("@"));
    }

    @Generated
    public static EmailBuilder builder() {
        return new EmailBuilder();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getContents() {
        return this.contents;
    }

    @Generated
    public String getSender() {
        return this.sender;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getRecipient() {
        return this.recipient;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    @Generated
    public void setTime(LocalDateTime time) {
        this.time = time;
    }

    @Generated
    public void setContents(String contents) {
        this.contents = contents;
    }

    @Generated
    public void setSender(String sender) {
        this.sender = sender;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Email)) {
            return false;
        }
        Email other = (Email)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$time = this.getTime();
        String other$time = other.getTime();
        if (this$time == null ? other$time != null : !this$time.equals(other$time)) {
            return false;
        }
        String this$contents = this.getContents();
        String other$contents = other.getContents();
        if (this$contents == null ? other$contents != null : !this$contents.equals(other$contents)) {
            return false;
        }
        String this$sender = this.getSender();
        String other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$recipient = this.getRecipient();
        String other$recipient = other.getRecipient();
        return !(this$recipient == null ? other$recipient != null : !this$recipient.equals(other$recipient));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Email;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : $time.hashCode());
        String $contents = this.getContents();
        result = result * 59 + ($contents == null ? 43 : $contents.hashCode());
        String $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : $sender.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $recipient = this.getRecipient();
        result = result * 59 + ($recipient == null ? 43 : $recipient.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Email(id=" + this.getId() + ", time=" + this.getTime() + ", contents=" + this.getContents() + ", sender=" + this.getSender() + ", title=" + this.getTitle() + ", recipient=" + this.getRecipient() + ")";
    }

    @Generated
    public Email(Long id, LocalDateTime time, String contents, String sender, String title, String recipient) {
        this.id = id;
        this.time = time;
        this.contents = contents;
        this.sender = sender;
        this.title = title;
        this.recipient = recipient;
    }

    @Generated
    public Email() {
    }
}

