/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.webwolf;

import jakarta.annotation.PostConstruct;
import java.io.File;
import org.owasp.webgoat.container.UserInterceptor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class MvcConfiguration
implements WebMvcConfigurer {
    @Value(value="${webwolf.fileserver.location}")
    private String fileLocation;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/files/**"}).addResourceLocations(new String[]{"file:///" + this.fileLocation + "/"});
        registry.addResourceHandler(new String[]{"/css/**"}).addResourceLocations(new String[]{"classpath:/webwolf/static/css/"});
        registry.addResourceHandler(new String[]{"/js/**"}).addResourceLocations(new String[]{"classpath:/webwolf/static/js/"});
        registry.addResourceHandler(new String[]{"/images/**"}).addResourceLocations(new String[]{"classpath:/webwolf/static/images/"});
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/login").setViewName("webwolf-login");
        registry.addViewController("/home").setViewName("home");
        registry.addViewController("/").setViewName("home");
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new UserInterceptor());
    }

    @PostConstruct
    public void createDirectory() {
        File file = new File(this.fileLocation);
        if (!file.exists()) {
            file.mkdirs();
        }
    }
}

