/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.webwolf;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.TimeZone;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.owasp.webgoat.webwolf.FileServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class FileServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileServer.class);
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    @Value(value="${webwolf.fileserver.location}")
    private String fileLocation;
    @Value(value="${server.address}")
    private String server;
    @Value(value="${server.servlet.context-path}")
    private String contextPath;
    @Value(value="${server.port}")
    private int port;

    @RequestMapping(path={"/file-server-location"}, consumes={"*/*"}, produces={"text/plain"})
    @ResponseBody
    public String getFileLocation() {
        return this.fileLocation;
    }

    @PostMapping(value={"/fileupload"})
    public ModelAndView importFile(@RequestParam(value="file") MultipartFile multipartFile, Authentication authentication) throws IOException {
        String username = authentication.getName();
        File destinationDir = new File(this.fileLocation, username);
        destinationDir.mkdirs();
        try (InputStream is = multipartFile.getInputStream();){
            Path destinationFile = destinationDir.toPath().resolve(multipartFile.getOriginalFilename());
            Files.deleteIfExists(destinationFile);
            Files.copy(is, destinationFile, new CopyOption[0]);
        }
        log.debug("File saved to {}", (Object)new File(destinationDir, multipartFile.getOriginalFilename()));
        return new ModelAndView((View)new RedirectView("files", true), (Map)new ModelMap().addAttribute("uploadSuccess", (Object)"File uploaded successful"));
    }

    @GetMapping(value={"/files"})
    public ModelAndView getFiles(HttpServletRequest request, Authentication authentication, TimeZone timezone) {
        String username = null != authentication ? authentication.getName() : "anonymous";
        File destinationDir = new File(this.fileLocation, username);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("files");
        File changeIndicatorFile = new File(destinationDir, username + "_changed");
        if (changeIndicatorFile.exists()) {
            modelAndView.addObject("uploadSuccess", (Object)request.getParameter("uploadSuccess"));
        }
        changeIndicatorFile.delete();
        ArrayList<UploadedFile> uploadedFiles = new ArrayList<UploadedFile>();
        File[] files = destinationDir.listFiles(File::isFile);
        if (files != null) {
            for (File file : files) {
                String size = FileUtils.byteCountToDisplaySize((long)file.length());
                String link = String.format("files/%s/%s", username, file.getName());
                uploadedFiles.add(new UploadedFile(file.getName(), size, link, this.getCreationTime(timezone, file)));
            }
        }
        modelAndView.addObject("files", uploadedFiles.stream().sorted(Comparator.comparing(UploadedFile::creationTime).reversed()).toList());
        modelAndView.addObject("webwolf_url", (Object)("http://" + this.server + ":" + this.port + this.contextPath));
        return modelAndView;
    }

    private String getCreationTime(TimeZone timezone, File file) {
        try {
            FileTime creationTime = (FileTime)Files.getAttribute(file.toPath(), "creationTime", new LinkOption[0]);
            ZonedDateTime zonedDateTime = creationTime.toInstant().atZone(timezone.toZoneId());
            return dateTimeFormatter.format(zonedDateTime);
        }
        catch (IOException e) {
            return "unknown";
        }
    }
}

