/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.xxe;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Optional;
import org.apache.commons.exec.OS;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.owasp.webgoat.container.CurrentUser;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.container.users.WebGoatUser;
import org.owasp.webgoat.lessons.xxe.Comment;
import org.owasp.webgoat.lessons.xxe.CommentsCache;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"xxe.hints.content.type.xxe.1", "xxe.hints.content.type.xxe.2"})
public class ContentTypeAssignment
implements AssignmentEndpoint {
    private static final String[] DEFAULT_LINUX_DIRECTORIES = new String[]{"usr", "etc", "var"};
    private static final String[] DEFAULT_WINDOWS_DIRECTORIES = new String[]{"Windows", "Program Files (x86)", "Program Files", "pagefile.sys"};
    private final CommentsCache comments;

    public ContentTypeAssignment(CommentsCache comments) {
        this.comments = comments;
    }

    @PostMapping(path={"xxe/content-type"})
    @ResponseBody
    public AttackResult createNewUser(@RequestBody String commentStr, @RequestHeader(value="Content-Type") String contentType, @CurrentUser WebGoatUser user) {
        AttackResult attackResult = AttackResultBuilder.failed((AssignmentEndpoint)this).build();
        if ("application/json".equals(contentType)) {
            this.parseJson(commentStr).ifPresent(c -> this.comments.addComment(c, user, true));
            attackResult = AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("xxe.content.type.feedback.json").build();
        }
        if (null != contentType && contentType.contains("application/xml")) {
            try {
                Comment comment = this.comments.parseXml(commentStr, false);
                this.comments.addComment(comment, user, false);
                if (this.checkSolution(comment)) {
                    attackResult = AttackResultBuilder.success((AssignmentEndpoint)this).build();
                }
            }
            catch (Exception e) {
                String error = ExceptionUtils.getStackTrace((Throwable)e);
                attackResult = AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("xxe.content.type.feedback.xml").output(error).build();
            }
        }
        return attackResult;
    }

    protected Optional<Comment> parseJson(String comment) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return Optional.of((Comment)mapper.readValue(comment, Comment.class));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    private boolean checkSolution(Comment comment) {
        String[] directoriesToCheck = OS.isFamilyMac() || OS.isFamilyUnix() ? DEFAULT_LINUX_DIRECTORIES : DEFAULT_WINDOWS_DIRECTORIES;
        boolean success = false;
        for (String directory : directoriesToCheck) {
            success |= StringUtils.contains((CharSequence)comment.getText(), (CharSequence)directory);
        }
        return success;
    }
}

