/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.xxe;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.RandomStringUtils;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.container.lessons.Initializable;
import org.owasp.webgoat.container.users.WebGoatUser;
import org.owasp.webgoat.lessons.xxe.Comment;
import org.owasp.webgoat.lessons.xxe.CommentsCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"xxe.blind.hints.1", "xxe.blind.hints.2", "xxe.blind.hints.3", "xxe.blind.hints.4", "xxe.blind.hints.5"})
public class BlindSendFileAssignment
implements AssignmentEndpoint,
Initializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BlindSendFileAssignment.class);
    private final String webGoatHomeDirectory;
    private final CommentsCache comments;
    private final Map<WebGoatUser, String> userToFileContents = new HashMap();

    public BlindSendFileAssignment(@Value(value="${webgoat.user.directory}") String webGoatHomeDirectory, CommentsCache comments) {
        this.webGoatHomeDirectory = webGoatHomeDirectory;
        this.comments = comments;
    }

    private void createSecretFileWithRandomContents(WebGoatUser user) {
        String fileContents = "WebGoat 8.0 rocks... (" + RandomStringUtils.randomAlphabetic((int)10) + ")";
        this.userToFileContents.put(user, fileContents);
        File targetDirectory = new File(this.webGoatHomeDirectory, "/XXE/" + user.getUsername());
        if (!targetDirectory.exists()) {
            targetDirectory.mkdirs();
        }
        try {
            Files.writeString(new File(targetDirectory, "secret.txt").toPath(), (CharSequence)fileContents, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            log.error("Unable to write 'secret.txt' to '{}", (Object)targetDirectory);
        }
    }

    @PostMapping(path={"xxe/blind"}, consumes={"*/*"}, produces={"application/json"})
    @ResponseBody
    public AttackResult addComment(@RequestBody String commentStr, @AuthenticationPrincipal WebGoatUser user) {
        String fileContentsForUser = this.userToFileContents.getOrDefault(user, "");
        if (commentStr.contains(fileContentsForUser)) {
            return AttackResultBuilder.success((AssignmentEndpoint)this).build();
        }
        try {
            Comment comment = this.comments.parseXml(commentStr, false);
            if (fileContentsForUser.contains(comment.getText())) {
                comment.setText("Nice try, you need to send the file to WebWolf");
            }
            this.comments.addComment(comment, user, false);
        }
        catch (Exception e) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).output(e.toString()).build();
        }
        return AttackResultBuilder.failed((AssignmentEndpoint)this).build();
    }

    public void initialize(WebGoatUser user) {
        this.comments.reset(user);
        this.userToFileContents.remove(user);
        this.createSecretFileWithRandomContents(user);
    }
}

