/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.xss.mitigation;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"xss-mitigation-3-hint1", "xss-mitigation-3-hint2", "xss-mitigation-3-hint3", "xss-mitigation-3-hint4"})
public class CrossSiteScriptingLesson3
implements AssignmentEndpoint {
    @PostMapping(value={"/CrossSiteScripting/attack3"})
    @ResponseBody
    public AttackResult completed(@RequestParam String editor) {
        String unescapedString = Parser.unescapeEntities((String)editor, (boolean)true);
        try {
            if (editor.isEmpty()) {
                return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("xss-mitigation-3-no-code").build();
            }
            Document doc = Jsoup.parse((String)unescapedString);
            String[] lines = unescapedString.split("<html>");
            String include = lines[0];
            String fistNameElement = doc.select("body > table > tbody > tr:nth-child(1) > td:nth-child(2)").first().text();
            String lastNameElement = doc.select("body > table > tbody > tr:nth-child(2) > td:nth-child(2)").first().text();
            boolean includeCorrect = false;
            boolean firstNameCorrect = false;
            boolean lastNameCorrect = false;
            if (include.contains("<%@") && include.contains("taglib") && include.contains("uri=\"https://www.owasp.org/index.php/OWASP_Java_Encoder_Project\"") && include.contains("%>")) {
                includeCorrect = true;
            }
            if (fistNameElement.equals("${e:forHtml(param.first_name)}")) {
                firstNameCorrect = true;
            }
            if (lastNameElement.equals("${e:forHtml(param.last_name)}")) {
                lastNameCorrect = true;
            }
            if (includeCorrect && firstNameCorrect && lastNameCorrect) {
                return AttackResultBuilder.success((AssignmentEndpoint)this).feedback("xss-mitigation-3-success").build();
            }
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("xss-mitigation-3-failure").build();
        }
        catch (Exception e) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).output(e.getMessage()).build();
        }
    }
}

