/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.xss;

import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.container.session.LessonSession;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"xss-dom-message-hint-1", "xss-dom-message-hint-2", "xss-dom-message-hint-3", "xss-dom-message-hint-4", "xss-dom-message-hint-5", "xss-dom-message-hint-6"})
public class DOMCrossSiteScriptingVerifier
implements AssignmentEndpoint {
    private final LessonSession lessonSession;

    public DOMCrossSiteScriptingVerifier(LessonSession lessonSession) {
        this.lessonSession = lessonSession;
    }

    @PostMapping(value={"/CrossSiteScripting/dom-follow-up"})
    @ResponseBody
    public AttackResult completed(@RequestParam String successMessage) {
        String answer = (String)this.lessonSession.getValue("randValue");
        if (successMessage.equals(answer)) {
            return AttackResultBuilder.success((AssignmentEndpoint)this).feedback("xss-dom-message-success").build();
        }
        return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("xss-dom-message-failure").build();
    }
}

