/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.webwolfintroduction;

import org.apache.commons.lang3.StringUtils;
import org.owasp.webgoat.container.CurrentUsername;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.lessons.webwolfintroduction.Email;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@RestController
public class MailAssignment
implements AssignmentEndpoint {
    private final String webWolfURL;
    private RestTemplate restTemplate;

    public MailAssignment(RestTemplate restTemplate, @Value(value="${webwolf.mail.url}") String webWolfURL) {
        this.restTemplate = restTemplate;
        this.webWolfURL = webWolfURL;
    }

    @PostMapping(value={"/WebWolf/mail/send"})
    @ResponseBody
    public AttackResult sendEmail(@RequestParam String email, @CurrentUsername String webGoatUsername) {
        String username = email.substring(0, email.indexOf("@"));
        if (username.equalsIgnoreCase(webGoatUsername)) {
            Email mailEvent = Email.builder().recipient(username).title("Test messages from WebWolf").contents("This is a test message from WebWolf, your unique code is: " + StringUtils.reverse((String)username)).sender("webgoat@owasp.org").build();
            try {
                this.restTemplate.postForEntity(this.webWolfURL, (Object)mailEvent, Object.class, new Object[0]);
            }
            catch (RestClientException e) {
                return AttackResultBuilder.informationMessage((AssignmentEndpoint)this).feedback("webwolf.email_failed").output(e.getMessage()).build();
            }
            return AttackResultBuilder.informationMessage((AssignmentEndpoint)this).feedback("webwolf.email_send").feedbackArgs(new Object[]{email}).build();
        }
        return AttackResultBuilder.informationMessage((AssignmentEndpoint)this).feedback("webwolf.email_mismatch").feedbackArgs(new Object[]{username}).build();
    }

    @PostMapping(value={"/WebWolf/mail"})
    @ResponseBody
    public AttackResult completed(@RequestParam String uniqueCode, @CurrentUsername String username) {
        if (uniqueCode.equals(StringUtils.reverse((String)username))) {
            return AttackResultBuilder.success((AssignmentEndpoint)this).build();
        }
        return AttackResultBuilder.failed((AssignmentEndpoint)this).feedbackArgs(new Object[]{"webwolf.code_incorrect"}).feedbackArgs(new Object[]{uniqueCode}).build();
    }
}

