/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.ssrf;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"ssrf.hint3"})
public class SSRFTask2
implements AssignmentEndpoint {
    @PostMapping(value={"/SSRF/task2"})
    @ResponseBody
    public AttackResult completed(@RequestParam String url) {
        return this.furBall(url);
    }

    protected AttackResult furBall(String url) {
        if (url.matches("http://ifconfig\\.pro")) {
            String html;
            try (InputStream in = new URL(url).openStream();){
                html = new String(in.readAllBytes(), StandardCharsets.UTF_8).replaceAll("\n", "<br>");
            }
            catch (MalformedURLException e) {
                return this.getFailedResult(e.getMessage());
            }
            catch (IOException e) {
                html = "<html><body>Although the http://ifconfig.pro site is down, you still managed to solve this exercise the right way!</body></html>";
            }
            return AttackResultBuilder.success((AssignmentEndpoint)this).feedback("ssrf.success").output(html).build();
        }
        String html = "<img class=\"image\" alt=\"image post\" src=\"images/cat.jpg\">";
        return this.getFailedResult(html);
    }

    private AttackResult getFailedResult(String errorMsg) {
        return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("ssrf.failure").output(errorMsg).build();
    }
}

