/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.ssrf;

import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"ssrf.hint1", "ssrf.hint2"})
public class SSRFTask1
implements AssignmentEndpoint {
    @PostMapping(value={"/SSRF/task1"})
    @ResponseBody
    public AttackResult completed(@RequestParam String url) {
        return this.stealTheCheese(url);
    }

    protected AttackResult stealTheCheese(String url) {
        try {
            StringBuilder html = new StringBuilder();
            if (url.matches("images/tom\\.png")) {
                html.append("<img class=\"image\" alt=\"Tom\" src=\"images/tom.png\" width=\"25%\" height=\"25%\">");
                return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("ssrf.tom").output(html.toString()).build();
            }
            if (url.matches("images/jerry\\.png")) {
                html.append("<img class=\"image\" alt=\"Jerry\" src=\"images/jerry.png\" width=\"25%\" height=\"25%\">");
                return AttackResultBuilder.success((AssignmentEndpoint)this).feedback("ssrf.success").output(html.toString()).build();
            }
            html.append("<img class=\"image\" alt=\"Silly Cat\" src=\"images/cat.jpg\">");
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("ssrf.failure").output(html.toString()).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return AttackResultBuilder.failed((AssignmentEndpoint)this).output(e.getMessage()).build();
        }
    }
}

