/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.sqlinjection.mitigation;

import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.lessons.sqlinjection.advanced.SqlInjectionLesson6a;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"SqlOnlyInputValidationOnKeywords-1", "SqlOnlyInputValidationOnKeywords-2", "SqlOnlyInputValidationOnKeywords-3"})
public class SqlOnlyInputValidationOnKeywords
implements AssignmentEndpoint {
    private final SqlInjectionLesson6a lesson6a;

    public SqlOnlyInputValidationOnKeywords(SqlInjectionLesson6a lesson6a) {
        this.lesson6a = lesson6a;
    }

    @PostMapping(value={"/SqlOnlyInputValidationOnKeywords/attack"})
    @ResponseBody
    public AttackResult attack(@RequestParam(value="userid_sql_only_input_validation_on_keywords") String userId) {
        if ((userId = userId.toUpperCase().replace("FROM", "").replace("SELECT", "")).contains(" ")) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("SqlOnlyInputValidationOnKeywords-failed").build();
        }
        AttackResult attackResult = this.lesson6a.injectableQuery(userId);
        return new AttackResult(attackResult.isLessonCompleted(), attackResult.getFeedback(), attackResult.getFeedbackArgs(), attackResult.getOutput(), attackResult.getOutputArgs(), this.getClass().getSimpleName(), true);
    }
}

