/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.sqlinjection.mitigation;

import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.lessons.sqlinjection.advanced.SqlInjectionLesson6a;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"SqlOnlyInputValidation-1", "SqlOnlyInputValidation-2", "SqlOnlyInputValidation-3"})
public class SqlOnlyInputValidation
implements AssignmentEndpoint {
    private final SqlInjectionLesson6a lesson6a;

    public SqlOnlyInputValidation(SqlInjectionLesson6a lesson6a) {
        this.lesson6a = lesson6a;
    }

    @PostMapping(value={"/SqlOnlyInputValidation/attack"})
    @ResponseBody
    public AttackResult attack(@RequestParam(value="userid_sql_only_input_validation") String userId) {
        if (userId.contains(" ")) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("SqlOnlyInputValidation-failed").build();
        }
        AttackResult attackResult = this.lesson6a.injectableQuery(userId);
        return new AttackResult(attackResult.isLessonCompleted(), attackResult.getFeedback(), attackResult.getFeedbackArgs(), attackResult.getOutput(), attackResult.getOutputArgs(), this.getClass().getSimpleName(), true);
    }
}

