/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.sqlinjection.mitigation;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import lombok.Generated;
import org.owasp.webgoat.container.LessonDataSource;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"SqlStringInjectionHint-mitigation-13-1", "SqlStringInjectionHint-mitigation-13-2", "SqlStringInjectionHint-mitigation-13-3", "SqlStringInjectionHint-mitigation-13-4"})
public class SqlInjectionLesson13
implements AssignmentEndpoint {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqlInjectionLesson13.class);
    private final LessonDataSource dataSource;

    public SqlInjectionLesson13(LessonDataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"/SqlInjectionMitigations/attack12a"})
    @ResponseBody
    public AttackResult completed(@RequestParam String ip) {
        try (Connection connection = this.dataSource.getConnection();){
            AttackResult attackResult;
            block18: {
                PreparedStatement preparedStatement;
                block16: {
                    AttackResult attackResult2;
                    block17: {
                        preparedStatement = connection.prepareStatement("select ip from servers where ip = ? and hostname = ?");
                        try {
                            preparedStatement.setString(1, ip);
                            preparedStatement.setString(2, "webgoat-prd");
                            ResultSet resultSet = preparedStatement.executeQuery();
                            if (!resultSet.next()) break block16;
                            attackResult2 = AttackResultBuilder.success((AssignmentEndpoint)this).build();
                            if (preparedStatement == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (preparedStatement != null) {
                                try {
                                    preparedStatement.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        preparedStatement.close();
                    }
                    return attackResult2;
                }
                attackResult = AttackResultBuilder.failed((AssignmentEndpoint)this).build();
                if (preparedStatement == null) break block18;
                preparedStatement.close();
            }
            return attackResult;
        }
        catch (SQLException e) {
            log.error("Failed", (Throwable)e);
            return AttackResultBuilder.failed((AssignmentEndpoint)this).build();
        }
    }
}

