/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.sqlinjection.introduction;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.owasp.webgoat.container.LessonDataSource;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.lessons.sqlinjection.introduction.SqlInjectionLesson8;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"SqlStringInjectionHint.9.1", "SqlStringInjectionHint.9.2", "SqlStringInjectionHint.9.3", "SqlStringInjectionHint.9.4", "SqlStringInjectionHint.9.5"})
public class SqlInjectionLesson9
implements AssignmentEndpoint {
    private final LessonDataSource dataSource;

    public SqlInjectionLesson9(LessonDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @PostMapping(value={"/SqlInjection/attack9"})
    @ResponseBody
    public AttackResult completed(@RequestParam String name, @RequestParam String auth_tan) {
        return this.injectableQueryIntegrity(name, auth_tan);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AttackResult injectableQueryIntegrity(String name, String auth_tan) {
        StringBuilder output = new StringBuilder();
        String queryInjection = "SELECT * FROM employees WHERE last_name = '" + name + "' AND auth_tan = '" + auth_tan + "'";
        try (Connection connection = this.dataSource.getConnection();){
            int oldMaxSalary = this.getMaxSalary(connection);
            int oldSumSalariesOfOtherEmployees = this.getSumSalariesOfOtherEmployees(connection);
            connection.setAutoCommit(false);
            Statement statement = connection.createStatement(1005, 1008);
            SqlInjectionLesson8.log((Connection)connection, (String)queryInjection);
            statement.execute(queryInjection);
            int newJohnSalary = this.getJohnSalary(connection);
            int newSumSalariesOfOtherEmployees = this.getSumSalariesOfOtherEmployees(connection);
            if (newJohnSalary > oldMaxSalary && newSumSalariesOfOtherEmployees == oldSumSalariesOfOtherEmployees) {
                connection.commit();
                connection.setAutoCommit(true);
                output.append(SqlInjectionLesson8.generateTable((ResultSet)this.getEmployeesDataOrderBySalaryDesc(connection)));
                AttackResult attackResult2 = AttackResultBuilder.success((AssignmentEndpoint)this).feedback("sql-injection.9.success").output(output.toString()).build();
                return attackResult2;
            }
            connection.rollback();
            AttackResult attackResult = AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("sql-injection.9.one").output(SqlInjectionLesson8.generateTable((ResultSet)this.getEmployeesDataOrderBySalaryDesc(connection))).build();
            return attackResult;
        }
        catch (SQLException e) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).output("<br><span class='feedback-negative'>" + e.getMessage() + "</span>").build();
        }
    }

    private int getSqlInt(Connection connection, String query) throws SQLException {
        Statement statement = connection.createStatement(1005, 1008);
        ResultSet results = statement.executeQuery(query);
        results.first();
        return results.getInt(1);
    }

    private int getMaxSalary(Connection connection) throws SQLException {
        String query = "SELECT max(salary) FROM employees";
        return this.getSqlInt(connection, query);
    }

    private int getSumSalariesOfOtherEmployees(Connection connection) throws SQLException {
        String query = "SELECT sum(salary) FROM employees WHERE auth_tan != '3SL99A'";
        return this.getSqlInt(connection, query);
    }

    private int getJohnSalary(Connection connection) throws SQLException {
        String query = "SELECT salary FROM employees WHERE auth_tan = '3SL99A'";
        return this.getSqlInt(connection, query);
    }

    private ResultSet getEmployeesDataOrderBySalaryDesc(Connection connection) throws SQLException {
        String query = "SELECT * FROM employees ORDER BY salary DESC";
        Statement statement = connection.createStatement(1005, 1008);
        return statement.executeQuery(query);
    }
}

