/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.sqlinjection.introduction;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.owasp.webgoat.container.LessonDataSource;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@AssignmentHints(value={"SqlStringInjectionHint.8.1", "SqlStringInjectionHint.8.2", "SqlStringInjectionHint.8.3", "SqlStringInjectionHint.8.4", "SqlStringInjectionHint.8.5"})
public class SqlInjectionLesson8
implements AssignmentEndpoint {
    private final LessonDataSource dataSource;

    public SqlInjectionLesson8(LessonDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @PostMapping(value={"/SqlInjection/attack8"})
    @ResponseBody
    public AttackResult completed(@RequestParam String name, @RequestParam String auth_tan) {
        return this.injectableQueryConfidentiality(name, auth_tan);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AttackResult injectableQueryConfidentiality(String name, String auth_tan) {
        StringBuilder output = new StringBuilder();
        String query = "SELECT * FROM employees WHERE last_name = '" + name + "' AND auth_tan = '" + auth_tan + "'";
        try (Connection connection = this.dataSource.getConnection();){
            Statement statement = connection.createStatement(1004, 1008);
            SqlInjectionLesson8.log((Connection)connection, (String)query);
            ResultSet results = statement.executeQuery(query);
            if (results.getStatement() != null) {
                if (!results.first()) {
                    AttackResult attackResult = AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("sql-injection.8.no.results").build();
                    return attackResult;
                }
                output.append(SqlInjectionLesson8.generateTable((ResultSet)results));
                results.last();
                if (results.getRow() > 1) {
                    AttackResult attackResult = AttackResultBuilder.success((AssignmentEndpoint)this).feedback("sql-injection.8.success").output(output.toString()).build();
                    return attackResult;
                }
                AttackResult attackResult = AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("sql-injection.8.one").output(output.toString()).build();
                return attackResult;
            }
            AttackResult attackResult = AttackResultBuilder.failed((AssignmentEndpoint)this).build();
            return attackResult;
        }
        catch (Exception e) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).output("<br><span class='feedback-negative'>" + e.getMessage() + "</span>").build();
        }
    }

    public static String generateTable(ResultSet results) throws SQLException {
        ResultSetMetaData resultsMetaData = results.getMetaData();
        int numColumns = resultsMetaData.getColumnCount();
        results.beforeFirst();
        StringBuilder table = new StringBuilder();
        table.append("<table>");
        if (results.next()) {
            int i;
            table.append("<tr>");
            for (i = 1; i < numColumns + 1; ++i) {
                table.append("<th>" + resultsMetaData.getColumnName(i) + "</th>");
            }
            table.append("</tr>");
            results.beforeFirst();
            while (results.next()) {
                table.append("<tr>");
                for (i = 1; i < numColumns + 1; ++i) {
                    table.append("<td>" + results.getString(i) + "</td>");
                }
                table.append("</tr>");
            }
        } else {
            table.append("Query Successful; however no data was returned from this query.");
        }
        table.append("</table>");
        return table.toString();
    }

    public static void log(Connection connection, String action) {
        action = action.replace('\'', '\"');
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String time = sdf.format(cal.getTime());
        String logQuery = "INSERT INTO access_log (time, action) VALUES ('" + time + "', '" + action + "')";
        try {
            Statement statement = connection.createStatement(1005, 1008);
            statement.executeUpdate(logQuery);
        }
        catch (SQLException e) {
            System.err.println(e.getMessage());
        }
    }
}

