/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.sqlinjection.introduction;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.owasp.webgoat.container.LessonDataSource;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@AssignmentHints(value={"SqlStringInjectionHint5a1"})
public class SqlInjectionLesson5a
implements AssignmentEndpoint {
    private static final String EXPLANATION = "<br> Explanation: This injection works, because <span style=\"font-style: italic\">or '1' = '1'</span> always evaluates to true (The string ending literal for '1 is closed by the query itself, so you should not inject it). So the injected query basically looks like this: <span style=\"font-style: italic\">SELECT * FROM user_data WHERE (first_name = 'John' and last_name = '') or (TRUE)</span>, which will always evaluate to true, no matter what came before it.";
    private final LessonDataSource dataSource;

    public SqlInjectionLesson5a(LessonDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @PostMapping(value={"/SqlInjection/assignment5a"})
    @ResponseBody
    public AttackResult completed(@RequestParam String account, @RequestParam String operator, @RequestParam String injection) {
        return this.injectableQuery(account + " " + operator + " " + injection);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    protected AttackResult injectableQuery(String accountName) {
        Object query = "";
        try (Connection connection = this.dataSource.getConnection();){
            AttackResult attackResult;
            block25: {
                Statement statement;
                block21: {
                    AttackResult attackResult2;
                    block24: {
                        StringBuilder output;
                        block22: {
                            AttackResult attackResult3;
                            block23: {
                                query = "SELECT * FROM user_data WHERE first_name = 'John' and last_name = '" + accountName + "'";
                                statement = connection.createStatement(1004, 1008);
                                ResultSet results = statement.executeQuery((String)query);
                                if (results == null || !results.first()) break block21;
                                ResultSetMetaData resultsMetaData = results.getMetaData();
                                output = new StringBuilder();
                                output.append(SqlInjectionLesson5a.writeTable((ResultSet)results, (ResultSetMetaData)resultsMetaData));
                                results.last();
                                if (results.getRow() < 6) break block22;
                                attackResult3 = AttackResultBuilder.success((AssignmentEndpoint)this).feedback("sql-injection.5a.success").output("Your query was: " + (String)query + "<br> Explanation: This injection works, because <span style=\"font-style: italic\">or '1' = '1'</span> always evaluates to true (The string ending literal for '1 is closed by the query itself, so you should not inject it). So the injected query basically looks like this: <span style=\"font-style: italic\">SELECT * FROM user_data WHERE (first_name = 'John' and last_name = '') or (TRUE)</span>, which will always evaluate to true, no matter what came before it.").feedbackArgs(new Object[]{output.toString()}).build();
                                if (statement == null) break block23;
                                statement.close();
                            }
                            return attackResult3;
                        }
                        attackResult2 = AttackResultBuilder.failed((AssignmentEndpoint)this).output(output.toString() + "<br> Your query was: " + (String)query).build();
                        if (statement == null) break block24;
                        {
                            catch (Throwable throwable) {
                                try {
                                    if (statement != null) {
                                        try {
                                            statement.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (SQLException sqle) {
                                    AttackResult attackResult4 = AttackResultBuilder.failed((AssignmentEndpoint)this).output(sqle.getMessage() + "<br> Your query was: " + (String)query).build();
                                    return attackResult4;
                                }
                            }
                        }
                        statement.close();
                    }
                    return attackResult2;
                }
                attackResult = AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("sql-injection.5a.no.results").output("Your query was: " + (String)query).build();
                if (statement == null) break block25;
                statement.close();
            }
            return attackResult;
        }
        catch (Exception e) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).output(this.getClass().getName() + " : " + e.getMessage() + "<br> Your query was: " + (String)query).build();
        }
    }

    public static String writeTable(ResultSet results, ResultSetMetaData resultsMetaData) throws SQLException {
        int numColumns = resultsMetaData.getColumnCount();
        results.beforeFirst();
        StringBuilder t = new StringBuilder();
        t.append("<p>");
        if (results.next()) {
            int i;
            for (i = 1; i < numColumns + 1; ++i) {
                t.append(resultsMetaData.getColumnName(i));
                t.append(", ");
            }
            t.append("<br />");
            results.beforeFirst();
            while (results.next()) {
                for (i = 1; i < numColumns + 1; ++i) {
                    t.append(results.getString(i));
                    t.append(", ");
                }
                t.append("<br />");
            }
        } else {
            t.append("Query Successful; however no data was returned from this query.");
        }
        t.append("</p>");
        return t.toString();
    }
}

