/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.sqlinjection.introduction;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.owasp.webgoat.container.LessonDataSource;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"SqlStringInjectionHint4-1", "SqlStringInjectionHint4-2", "SqlStringInjectionHint4-3"})
public class SqlInjectionLesson4
implements AssignmentEndpoint {
    private final LessonDataSource dataSource;

    public SqlInjectionLesson4(LessonDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @PostMapping(value={"/SqlInjection/attack4"})
    @ResponseBody
    public AttackResult completed(@RequestParam String query) {
        return this.injectableQuery(query);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected AttackResult injectableQuery(String query) {
        try (Connection connection = this.dataSource.getConnection();){
            AttackResult attackResult;
            block20: {
                StringBuilder output;
                Statement statement;
                block18: {
                    AttackResult attackResult2;
                    block19: {
                        statement = connection.createStatement(1004, 1007);
                        try {
                            statement.executeUpdate(query);
                            connection.commit();
                            ResultSet results = statement.executeQuery("SELECT phone from employees;");
                            output = new StringBuilder();
                            if (!results.first()) break block18;
                            output.append("<span class='feedback-positive'>" + query + "</span>");
                            attackResult2 = AttackResultBuilder.success((AssignmentEndpoint)this).output(output.toString()).build();
                            if (statement == null) break block19;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (statement != null) {
                                    try {
                                        statement.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (SQLException sqle) {
                                AttackResult attackResult3 = AttackResultBuilder.failed((AssignmentEndpoint)this).output(sqle.getMessage()).build();
                                return attackResult3;
                            }
                        }
                        statement.close();
                    }
                    return attackResult2;
                }
                attackResult = AttackResultBuilder.failed((AssignmentEndpoint)this).output(output.toString()).build();
                if (statement == null) break block20;
                statement.close();
            }
            return attackResult;
        }
        catch (Exception e) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).output(this.getClass().getName() + " : " + e.getMessage()).build();
        }
    }
}

