/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.sqlinjection.introduction;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.owasp.webgoat.container.LessonDataSource;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.lessons.sqlinjection.introduction.SqlInjectionLesson8;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"SqlStringInjectionHint.10.1", "SqlStringInjectionHint.10.2", "SqlStringInjectionHint.10.3", "SqlStringInjectionHint.10.4", "SqlStringInjectionHint.10.5", "SqlStringInjectionHint.10.6"})
public class SqlInjectionLesson10
implements AssignmentEndpoint {
    private final LessonDataSource dataSource;

    public SqlInjectionLesson10(LessonDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @PostMapping(value={"/SqlInjection/attack10"})
    @ResponseBody
    public AttackResult completed(@RequestParam String action_string) {
        return this.injectableQueryAvailability(action_string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AttackResult injectableQueryAvailability(String action) {
        StringBuilder output = new StringBuilder();
        String query = "SELECT * FROM access_log WHERE action LIKE '%" + action + "%'";
        try (Connection connection = this.dataSource.getConnection();){
            Statement statement = connection.createStatement(1004, 1007);
            ResultSet results = statement.executeQuery(query);
            if (results.getStatement() != null) {
                results.first();
                output.append(SqlInjectionLesson8.generateTable((ResultSet)results));
                AttackResult attackResult = AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("sql-injection.10.entries").output(output.toString()).build();
                return attackResult;
            }
            if (this.tableExists(connection)) {
                AttackResult attackResult = AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("sql-injection.10.entries").output(output.toString()).build();
                return attackResult;
            }
            AttackResult attackResult = AttackResultBuilder.success((AssignmentEndpoint)this).feedback("sql-injection.10.success").build();
            return attackResult;
        }
        catch (Exception e) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).output("<span class='feedback-negative'>" + e.getMessage() + "</span>").build();
        }
    }

    private boolean tableExists(Connection connection) {
        try {
            Statement stmt = connection.createStatement(1004, 1007);
            ResultSet results = stmt.executeQuery("SELECT * FROM access_log");
            int cols = results.getMetaData().getColumnCount();
            return cols > 0;
        }
        catch (SQLException e) {
            String errorMsg = e.getMessage();
            return !errorMsg.contains("object not found: ACCESS_LOG");
        }
    }
}

