/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.sqlinjection.advanced;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.owasp.webgoat.container.LessonDataSource;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.lessons.sqlinjection.introduction.SqlInjectionLesson5a;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"SqlStringInjectionHint-advanced-6a-1", "SqlStringInjectionHint-advanced-6a-2", "SqlStringInjectionHint-advanced-6a-3", "SqlStringInjectionHint-advanced-6a-4", "SqlStringInjectionHint-advanced-6a-5"})
public class SqlInjectionLesson6a
implements AssignmentEndpoint {
    private final LessonDataSource dataSource;
    private static final String YOUR_QUERY_WAS = "<br> Your query was: ";

    public SqlInjectionLesson6a(LessonDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @PostMapping(value={"/SqlInjectionAdvanced/attack6a"})
    @ResponseBody
    public AttackResult completed(@RequestParam(value="userid_6a") String userId) {
        return this.injectableQuery(userId);
    }

    public AttackResult injectableQuery(String accountName) {
        AttackResult attackResult;
        block8: {
            Object query = "";
            Connection connection = this.dataSource.getConnection();
            try {
                boolean usedUnion = this.unionQueryChecker(accountName);
                query = "SELECT * FROM user_data WHERE last_name = '" + accountName + "'";
                attackResult = this.executeSqlInjection(connection, (String)query, usedUnion);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return AttackResultBuilder.failed((AssignmentEndpoint)this).output(this.getClass().getName() + " : " + e.getMessage() + YOUR_QUERY_WAS + (String)query).build();
                }
            }
            connection.close();
        }
        return attackResult;
    }

    private boolean unionQueryChecker(String accountName) {
        return accountName.matches("(?i)(^[^-/*;)]*)(\\s*)UNION(.*$)");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AttackResult executeSqlInjection(Connection connection, String query, boolean usedUnion) {
        try (Statement statement = connection.createStatement(1004, 1007);){
            ResultSet results = statement.executeQuery(query);
            if (results == null || !results.first()) {
                AttackResult attackResult2 = AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("sql-injection.advanced.6a.no.results").output(YOUR_QUERY_WAS + query).build();
                return attackResult2;
            }
            ResultSetMetaData resultsMetaData = results.getMetaData();
            StringBuilder output = new StringBuilder();
            String appendingWhenSucceded = this.appendSuccededMessage(usedUnion);
            output.append(SqlInjectionLesson5a.writeTable((ResultSet)results, (ResultSetMetaData)resultsMetaData));
            results.last();
            AttackResult attackResult = this.verifySqlInjection(output, appendingWhenSucceded, query);
            return attackResult;
        }
        catch (SQLException sqle) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).output(sqle.getMessage() + YOUR_QUERY_WAS + query).build();
        }
    }

    private String appendSuccededMessage(boolean isUsedUnion) {
        Object appendingWhenSucceded = "Well done! Can you also figure out a solution, by ";
        appendingWhenSucceded = (String)appendingWhenSucceded + (isUsedUnion ? "appending a new SQL Statement?" : "using a UNION?");
        return appendingWhenSucceded;
    }

    private AttackResult verifySqlInjection(StringBuilder output, String appendingWhenSucceded, String query) {
        if (!output.toString().contains("dave") || !output.toString().contains("passW0rD")) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).output(output.toString() + YOUR_QUERY_WAS + query).build();
        }
        output.append(appendingWhenSucceded);
        return AttackResultBuilder.success((AssignmentEndpoint)this).feedback("sql-injection.advanced.6a.success").feedbackArgs(new Object[]{output.toString()}).output(" Your query was: " + query).build();
    }
}

