/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.spoofcookie;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.lessons.spoofcookie.encoders.EncDec;
import org.springframework.web.bind.UnsatisfiedServletRequestParameterException;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@AssignmentHints(value={"spoofcookie.hint1", "spoofcookie.hint2", "spoofcookie.hint3"})
@RestController
public class SpoofCookieAssignment
implements AssignmentEndpoint {
    private static final String COOKIE_NAME = "spoof_auth";
    private static final String COOKIE_INFO = "Cookie details for user %s:<br />spoof_auth=%s";
    private static final String ATTACK_USERNAME = "tom";
    private static final Map<String, String> users = Map.of("webgoat", "webgoat", "admin", "admin", "tom", "apasswordfortom");

    @PostMapping(path={"/SpoofCookie/login"})
    @ResponseBody
    @ExceptionHandler(value={UnsatisfiedServletRequestParameterException.class})
    public AttackResult login(@RequestParam String username, @RequestParam String password, @CookieValue(value="spoof_auth", required=false) String cookieValue, HttpServletResponse response) {
        if (StringUtils.isEmpty((CharSequence)cookieValue)) {
            return this.credentialsLoginFlow(username, password, response);
        }
        return this.cookieLoginFlow(cookieValue);
    }

    @GetMapping(path={"/SpoofCookie/cleanup"})
    public void cleanup(HttpServletResponse response) {
        Cookie cookie = new Cookie(COOKIE_NAME, "");
        cookie.setMaxAge(0);
        response.addCookie(cookie);
    }

    private AttackResult credentialsLoginFlow(String username, String password, HttpServletResponse response) {
        String lowerCasedUsername = username.toLowerCase();
        if (ATTACK_USERNAME.equals(lowerCasedUsername) && ((String)users.get(lowerCasedUsername)).equals(password)) {
            return AttackResultBuilder.informationMessage((AssignmentEndpoint)this).feedback("spoofcookie.cheating").build();
        }
        String authPassword = users.getOrDefault(lowerCasedUsername, "");
        if (!authPassword.isBlank() && authPassword.equals(password)) {
            String newCookieValue = EncDec.encode((String)lowerCasedUsername);
            Cookie newCookie = new Cookie(COOKIE_NAME, newCookieValue);
            newCookie.setPath("/WebGoat");
            newCookie.setSecure(true);
            response.addCookie(newCookie);
            return AttackResultBuilder.informationMessage((AssignmentEndpoint)this).feedback("spoofcookie.login").output(String.format(COOKIE_INFO, lowerCasedUsername, newCookie.getValue())).build();
        }
        return AttackResultBuilder.informationMessage((AssignmentEndpoint)this).feedback("spoofcookie.wrong-login").build();
    }

    private AttackResult cookieLoginFlow(String cookieValue) {
        String cookieUsername;
        try {
            cookieUsername = EncDec.decode((String)cookieValue).toLowerCase();
        }
        catch (Exception e) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).output(e.getMessage()).build();
        }
        if (users.containsKey(cookieUsername)) {
            if (cookieUsername.equals(ATTACK_USERNAME)) {
                return AttackResultBuilder.success((AssignmentEndpoint)this).build();
            }
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("spoofcookie.cookie-login").output(String.format(COOKIE_INFO, cookieUsername, cookieValue)).build();
        }
        return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("spoofcookie.wrong-cookie").build();
    }
}

