/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.pathtraversal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import lombok.Generated;
import org.owasp.webgoat.container.CurrentUsername;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.lessons.pathtraversal.ProfileUploadBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@AssignmentHints(value={"path-traversal-zip-slip.hint1", "path-traversal-zip-slip.hint2", "path-traversal-zip-slip.hint3", "path-traversal-zip-slip.hint4"})
public class ProfileZipSlip
extends ProfileUploadBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProfileZipSlip.class);

    public ProfileZipSlip(@Value(value="${webgoat.server.directory}") String webGoatHomeDirectory) {
        super(webGoatHomeDirectory);
    }

    @PostMapping(value={"/PathTraversal/zip-slip"}, consumes={"*/*"}, produces={"application/json"})
    @ResponseBody
    public AttackResult uploadFileHandler(@RequestParam(value="uploadedFileZipSlip") MultipartFile file, @CurrentUsername String username) {
        if (!file.getOriginalFilename().toLowerCase().endsWith(".zip")) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("path-traversal-zip-slip.no-zip").build();
        }
        return this.processZipUpload(file, username);
    }

    private AttackResult processZipUpload(MultipartFile file, String username) {
        Path tmpZipDirectory = Files.createTempDirectory(username, new FileAttribute[0]);
        this.cleanupAndCreateDirectoryForUser(username);
        byte[] currentImage = this.getProfilePictureAsBase64(username);
        try {
            Path uploadedZipFile = tmpZipDirectory.resolve(file.getOriginalFilename());
            FileCopyUtils.copy((byte[])file.getBytes(), (File)uploadedZipFile.toFile());
            ZipFile zip = new ZipFile(uploadedZipFile.toFile());
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry e = entries.nextElement();
                File f = new File(tmpZipDirectory.toFile(), e.getName());
                InputStream is = zip.getInputStream(e);
                Files.copy(is, f.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            return this.isSolved(currentImage, this.getProfilePictureAsBase64(username));
        }
        catch (IOException e) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).output(e.getMessage()).build();
        }
    }

    private AttackResult isSolved(byte[] currentImage, byte[] newImage) {
        if (Arrays.equals(currentImage, newImage)) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).output("path-traversal-zip-slip.extracted").build();
        }
        return AttackResultBuilder.success((AssignmentEndpoint)this).output("path-traversal-zip-slip.extracted").build();
    }

    @GetMapping(value={"/PathTraversal/zip-slip/"})
    @ResponseBody
    public ResponseEntity<?> getProfilePicture(@CurrentUsername String username) {
        return super.getProfilePicture(username);
    }

    @GetMapping(value={"/PathTraversal/zip-slip/profile-image/{username}"})
    @ResponseBody
    public ResponseEntity<?> getProfileImage(@PathVariable String username) {
        return ResponseEntity.notFound().build();
    }
}

