/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.pathtraversal;

import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Base64;
import lombok.Generated;
import org.apache.commons.lang3.RandomUtils;
import org.owasp.webgoat.container.CurrentUsername;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.token.Sha512DigestUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"path-traversal-profile-retrieve.hint1", "path-traversal-profile-retrieve.hint2", "path-traversal-profile-retrieve.hint3", "path-traversal-profile-retrieve.hint4", "path-traversal-profile-retrieve.hint5", "path-traversal-profile-retrieve.hint6"})
public class ProfileUploadRetrieval
implements AssignmentEndpoint {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProfileUploadRetrieval.class);
    private final File catPicturesDirectory;

    public ProfileUploadRetrieval(@Value(value="${webgoat.server.directory}") String webGoatHomeDirectory) {
        this.catPicturesDirectory = new File(webGoatHomeDirectory, "/PathTraversal//cats");
        this.catPicturesDirectory.mkdirs();
    }

    @PostConstruct
    public void initAssignment() {
        for (int i = 1; i <= 10; ++i) {
            try (InputStream is = new ClassPathResource("lessons/pathtraversal/images/cats/" + i + ".jpg").getInputStream();){
                FileCopyUtils.copy((InputStream)is, (OutputStream)new FileOutputStream(new File(this.catPicturesDirectory, i + ".jpg")));
                continue;
            }
            catch (Exception e) {
                log.error("Unable to copy pictures" + e.getMessage());
            }
        }
        File secretDirectory = this.catPicturesDirectory.getParentFile().getParentFile();
        try {
            Files.writeString(secretDirectory.toPath().resolve("path-traversal-secret.jpg"), (CharSequence)"You found it submit the SHA-512 hash of your username as answer", new OpenOption[0]);
        }
        catch (IOException e) {
            log.error("Unable to write secret in: {}", (Object)secretDirectory, (Object)e);
        }
    }

    @PostMapping(value={"/PathTraversal/random"})
    @ResponseBody
    public AttackResult execute(@RequestParam(value="secret", required=false) String secret, @CurrentUsername String username) {
        if (Sha512DigestUtils.shaHex((String)username).equalsIgnoreCase(secret)) {
            return AttackResultBuilder.success((AssignmentEndpoint)this).build();
        }
        return AttackResultBuilder.failed((AssignmentEndpoint)this).build();
    }

    @GetMapping(value={"/PathTraversal/random-picture"})
    @ResponseBody
    public ResponseEntity<?> getProfilePicture(HttpServletRequest request) {
        String queryParams = request.getQueryString();
        if (queryParams != null && (queryParams.contains("..") || queryParams.contains("/"))) {
            return ResponseEntity.badRequest().body((Object)"Illegal characters are not allowed in the query params");
        }
        try {
            String id = request.getParameter("id");
            File catPicture = new File(this.catPicturesDirectory, String.valueOf(id == null ? Integer.valueOf(RandomUtils.nextInt((int)1, (int)11)) : id) + ".jpg");
            if (catPicture.getName().toLowerCase().contains("path-traversal-secret.jpg")) {
                return ResponseEntity.ok().contentType(MediaType.parseMediaType((String)"image/jpeg")).body((Object)FileCopyUtils.copyToByteArray((File)catPicture));
            }
            if (catPicture.exists()) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)"image/jpeg")).location(new URI("/PathTraversal/random-picture?id=" + catPicture.getName()))).body((Object)Base64.getEncoder().encode(FileCopyUtils.copyToByteArray((File)catPicture)));
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).location(new URI("/PathTraversal/random-picture?id=" + catPicture.getName()))).body((Object)StringUtils.arrayToCommaDelimitedString((Object[])catPicture.getParentFile().listFiles()).getBytes());
        }
        catch (IOException | URISyntaxException e) {
            log.error("Image not found", (Throwable)e);
            return ResponseEntity.badRequest().build();
        }
    }
}

