/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.passwordreset;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.owasp.webgoat.container.CurrentUsername;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.lessons.passwordreset.resetlink.PasswordChangeForm;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@AssignmentHints(value={"password-reset-hint1", "password-reset-hint2", "password-reset-hint3", "password-reset-hint4", "password-reset-hint5", "password-reset-hint6"})
public class ResetLinkAssignment
implements AssignmentEndpoint {
    private static final String VIEW_FORMATTER = "lessons/passwordreset/templates/%s.html";
    static final String PASSWORD_TOM_9 = "somethingVeryRandomWhichNoOneWillEverTypeInAsPasswordForTom";
    static final String TOM_EMAIL = "tom@webgoat-cloud.org";
    static Map<String, String> userToTomResetLink = new HashMap();
    static Map<String, String> usersToTomPassword = Maps.newHashMap();
    static List<String> resetLinks = new ArrayList();
    static final String TEMPLATE = "Hi, you requested a password reset link, please use this <a target='_blank'\n href='http://%s/WebGoat/PasswordReset/reset/reset-password/%s'>link</a> to reset your\n password.\n\nIf you did not request this password change you can ignore this message.\nIf you have any comments or questions, please do not hesitate to reach us at\n support@webgoat-cloud.org\n\nKind regards,\nTeam WebGoat\n";

    @PostMapping(value={"/PasswordReset/reset/login"})
    @ResponseBody
    public AttackResult login(@RequestParam String password, @RequestParam String email, @CurrentUsername String username) {
        if (TOM_EMAIL.equals(email)) {
            String passwordTom = usersToTomPassword.getOrDefault(username, PASSWORD_TOM_9);
            if (passwordTom.equals(PASSWORD_TOM_9)) {
                return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("login_failed").build();
            }
            if (passwordTom.equals(password)) {
                return AttackResultBuilder.success((AssignmentEndpoint)this).build();
            }
        }
        return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("login_failed.tom").build();
    }

    @GetMapping(value={"/PasswordReset/reset/reset-password/{link}"})
    public ModelAndView resetPassword(@PathVariable(value="link") String link, Model model) {
        ModelAndView modelAndView = new ModelAndView();
        if (resetLinks.contains(link)) {
            PasswordChangeForm form = new PasswordChangeForm();
            form.setResetLink(link);
            model.addAttribute("form", (Object)form);
            modelAndView.addObject("form", (Object)form);
            modelAndView.setViewName(VIEW_FORMATTER.formatted("password_reset"));
        } else {
            modelAndView.setViewName(VIEW_FORMATTER.formatted("password_link_not_found"));
        }
        return modelAndView;
    }

    @PostMapping(value={"/PasswordReset/reset/change-password"})
    public ModelAndView changePassword(@ModelAttribute(value="form") PasswordChangeForm form, BindingResult bindingResult, @CurrentUsername String username) {
        ModelAndView modelAndView = new ModelAndView();
        if (!StringUtils.hasText((String)form.getPassword())) {
            bindingResult.rejectValue("password", "not.empty");
        }
        if (bindingResult.hasErrors()) {
            modelAndView.setViewName(VIEW_FORMATTER.formatted("password_reset"));
            return modelAndView;
        }
        if (!resetLinks.contains(form.getResetLink())) {
            modelAndView.setViewName(VIEW_FORMATTER.formatted("password_link_not_found"));
            return modelAndView;
        }
        if (this.checkIfLinkIsFromTom(form.getResetLink(), username)) {
            usersToTomPassword.put(username, form.getPassword());
        }
        modelAndView.setViewName(VIEW_FORMATTER.formatted("success"));
        return modelAndView;
    }

    private boolean checkIfLinkIsFromTom(String resetLinkFromForm, String username) {
        String resetLink = userToTomResetLink.getOrDefault(username, "unknown");
        return resetLink.equals(resetLinkFromForm);
    }
}

