/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.missingac;

import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.owasp.webgoat.container.LessonDataSource;
import org.owasp.webgoat.lessons.missingac.User;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MissingAccessControlUserRepository {
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final RowMapper<User> mapper = (rs, rowNum) -> new User(rs.getString("username"), rs.getString("password"), rs.getBoolean("admin"));

    public MissingAccessControlUserRepository(LessonDataSource lessonDataSource) {
        this.jdbcTemplate = new NamedParameterJdbcTemplate((DataSource)lessonDataSource);
    }

    public List<User> findAllUsers() {
        return this.jdbcTemplate.query("select username, password, admin from access_control_users", this.mapper);
    }

    public User findByUsername(String username) {
        List users = this.jdbcTemplate.query("select username, password, admin from access_control_users where username=:username", (SqlParameterSource)new MapSqlParameterSource().addValue("username", (Object)username), this.mapper);
        if (CollectionUtils.isEmpty((Collection)users)) {
            return null;
        }
        return (User)users.get(0);
    }

    public User save(User user) {
        this.jdbcTemplate.update("INSERT INTO access_control_users(username, password, admin) VALUES(:username,:password,:admin)", (SqlParameterSource)new MapSqlParameterSource().addValue("username", (Object)user.getUsername()).addValue("password", (Object)user.getPassword()).addValue("admin", (Object)user.isAdmin()));
        return user;
    }
}

