/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.missingac;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import lombok.Generated;
import org.owasp.webgoat.lessons.missingac.User;

public class DisplayUser {
    private final String username;
    private final boolean admin;
    private String userHash;

    public DisplayUser(User user, String passwordSalt) {
        this.username = user.getUsername();
        this.admin = user.isAdmin();
        try {
            this.userHash = this.genUserHash(user.getUsername(), user.getPassword(), passwordSalt);
        }
        catch (Exception ex) {
            this.userHash = "Error generating user hash";
        }
    }

    protected String genUserHash(String username, String password, String passwordSalt) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        String salted = password + passwordSalt + username;
        byte[] hash = md.digest(salted.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(hash);
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public boolean isAdmin() {
        return this.admin;
    }

    @Generated
    public String getUserHash() {
        return this.userHash;
    }
}

