/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.jwt.votes;

import com.fasterxml.jackson.annotation.JsonView;
import lombok.Generated;
import org.owasp.webgoat.lessons.jwt.votes.Views;

public class Vote {
    @JsonView(value={Views.GuestView.class})
    private final String title;
    @JsonView(value={Views.GuestView.class})
    private final String information;
    @JsonView(value={Views.GuestView.class})
    private final String imageSmall;
    @JsonView(value={Views.GuestView.class})
    private final String imageBig;
    @JsonView(value={Views.UserView.class})
    private int numberOfVotes;
    @JsonView(value={Views.UserView.class})
    private boolean votingAllowed = true;
    @JsonView(value={Views.UserView.class})
    private long average = 0L;

    public Vote(String title, String information, String imageSmall, String imageBig, int numberOfVotes, int totalVotes) {
        this.title = title;
        this.information = information;
        this.imageSmall = imageSmall;
        this.imageBig = imageBig;
        this.numberOfVotes = numberOfVotes;
        this.average = this.calculateStars(totalVotes);
    }

    public void incrementNumberOfVotes(int totalVotes) {
        ++this.numberOfVotes;
        this.average = this.calculateStars(totalVotes);
    }

    public void reset() {
        this.numberOfVotes = 1;
        this.average = 1L;
    }

    private long calculateStars(int totalVotes) {
        return Math.round((double)this.numberOfVotes / (double)totalVotes * 4.0);
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getInformation() {
        return this.information;
    }

    @Generated
    public String getImageSmall() {
        return this.imageSmall;
    }

    @Generated
    public String getImageBig() {
        return this.imageBig;
    }

    @Generated
    public int getNumberOfVotes() {
        return this.numberOfVotes;
    }

    @Generated
    public boolean isVotingAllowed() {
        return this.votingAllowed;
    }

    @Generated
    public long getAverage() {
        return this.average;
    }
}

