/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.jwt.claimmisuse;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SigningKeyResolver;
import org.apache.commons.lang3.StringUtils;
import org.owasp.webgoat.container.LessonDataSource;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"jwt-kid-hint1", "jwt-kid-hint2", "jwt-kid-hint3", "jwt-kid-hint4", "jwt-kid-hint5", "jwt-kid-hint6"})
@RequestMapping(value={"/JWT/"})
public class JWTHeaderKIDEndpoint
implements AssignmentEndpoint {
    private final LessonDataSource dataSource;

    private JWTHeaderKIDEndpoint(LessonDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @PostMapping(value={"kid/follow/{user}"})
    @ResponseBody
    public String follow(@PathVariable(value="user") String user) {
        if ("Jerry".equals(user)) {
            return "Following yourself seems redundant";
        }
        return "You are now following Tom";
    }

    @PostMapping(value={"kid/delete"})
    @ResponseBody
    public AttackResult resetVotes(@RequestParam(value="token") String token) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("jwt-invalid-token").build();
        }
        try {
            String[] errorMessage = new String[]{null};
            Jws jwt = Jwts.parser().setSigningKeyResolver((SigningKeyResolver)new /* Unavailable Anonymous Inner Class!! */).parseClaimsJws(token);
            if (errorMessage[0] != null) {
                return AttackResultBuilder.failed((AssignmentEndpoint)this).output(errorMessage[0]).build();
            }
            Claims claims = (Claims)jwt.getBody();
            String username = (String)claims.get((Object)"username");
            if ("Jerry".equals(username)) {
                return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("jwt-final-jerry-account").build();
            }
            if ("Tom".equals(username)) {
                return AttackResultBuilder.success((AssignmentEndpoint)this).build();
            }
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("jwt-final-not-tom").build();
        }
        catch (JwtException e) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("jwt-invalid-token").output(e.toString()).build();
        }
    }
}

