/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.jwt.claimmisuse;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.JwkProviderBuilder;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPublicKey;
import org.apache.commons.lang3.StringUtils;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/JWT/"})
@RestController
@AssignmentHints(value={"jwt-jku-hint1", "jwt-jku-hint2", "jwt-jku-hint3", "jwt-jku-hint4", "jwt-jku-hint5"})
public class JWTHeaderJKUEndpoint
implements AssignmentEndpoint {
    @PostMapping(value={"jku/follow/{user}"})
    @ResponseBody
    public String follow(@PathVariable(value="user") String user) {
        if ("Jerry".equals(user)) {
            return "Following yourself seems redundant";
        }
        return "You are now following Tom";
    }

    @PostMapping(value={"jku/delete"})
    @ResponseBody
    public AttackResult resetVotes(@RequestParam(value="token") String token) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("jwt-invalid-token").build();
        }
        try {
            DecodedJWT decodedJWT = JWT.decode((String)token);
            Claim jku = decodedJWT.getHeaderClaim("jku");
            JwkProvider jwkProvider = new JwkProviderBuilder(new URL(jku.asString())).build();
            Jwk jwk = jwkProvider.get(decodedJWT.getKeyId());
            Algorithm algorithm = Algorithm.RSA256((RSAKey)((RSAPublicKey)jwk.getPublicKey()));
            JWT.require((Algorithm)algorithm).build().verify(decodedJWT);
            String username = ((Claim)decodedJWT.getClaims().get("username")).asString();
            if ("Jerry".equals(username)) {
                return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("jwt-final-jerry-account").build();
            }
            if ("Tom".equals(username)) {
                return AttackResultBuilder.success((AssignmentEndpoint)this).build();
            }
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("jwt-final-not-tom").build();
        }
        catch (JwkException | JWTVerificationException | MalformedURLException e) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("jwt-invalid-token").output(e.toString()).build();
        }
    }
}

