/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.impl.TextCodec;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.time.Duration;
import java.time.Instant;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.lessons.jwt.votes.Views;
import org.owasp.webgoat.lessons.jwt.votes.Vote;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.json.MappingJacksonValue;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"jwt-change-token-hint1", "jwt-change-token-hint2", "jwt-change-token-hint3", "jwt-change-token-hint4", "jwt-change-token-hint5"})
public class JWTVotesEndpoint
implements AssignmentEndpoint {
    public static final String JWT_PASSWORD = TextCodec.BASE64.encode("victory");
    private static String validUsers = "TomJerrySylvester";
    private static int totalVotes = 38929;
    private final Map<String, Vote> votes = new HashMap();

    @PostConstruct
    public void initVotes() {
        this.votes.put("Admin lost password", new Vote("Admin lost password", "In this challenge you will need to help the admin and find the password in order to login", "challenge1-small.png", "challenge1.png", 36000, totalVotes));
        this.votes.put("Vote for your favourite", new Vote("Vote for your favourite", "In this challenge ...", "challenge5-small.png", "challenge5.png", 30000, totalVotes));
        this.votes.put("Get it for free", new Vote("Get it for free", "The objective for this challenge is to buy a Samsung phone for free.", "challenge2-small.png", "challenge2.png", 20000, totalVotes));
        this.votes.put("Photo comments", new Vote("Photo comments", "n this challenge you can comment on the photo you will need to find the flag somewhere.", "challenge3-small.png", "challenge3.png", 10000, totalVotes));
    }

    @GetMapping(value={"/JWT/votings/login"})
    public void login(@RequestParam(value="user") String user, HttpServletResponse response) {
        if (validUsers.contains(user)) {
            Claims claims = Jwts.claims().setIssuedAt(Date.from(Instant.now().plus(Duration.ofDays(10L))));
            claims.put((Object)"admin", (Object)"false");
            claims.put((Object)"user", (Object)user);
            String token = Jwts.builder().setClaims(claims).signWith(SignatureAlgorithm.HS512, JWT_PASSWORD).compact();
            Cookie cookie = new Cookie("access_token", token);
            response.addCookie(cookie);
            response.setStatus(HttpStatus.OK.value());
            response.setContentType("application/json");
        } else {
            Cookie cookie = new Cookie("access_token", "");
            response.addCookie(cookie);
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            response.setContentType("application/json");
        }
    }

    @GetMapping(value={"/JWT/votings"})
    @ResponseBody
    public MappingJacksonValue getVotes(@CookieValue(value="access_token", required=false) String accessToken) {
        MappingJacksonValue value = new MappingJacksonValue(this.votes.values().stream().sorted(Comparator.comparingLong(Vote::getAverage).reversed()).collect(Collectors.toList()));
        if (StringUtils.isEmpty((CharSequence)accessToken)) {
            value.setSerializationView(Views.GuestView.class);
        } else {
            try {
                Jwt jwt = Jwts.parser().setSigningKey(JWT_PASSWORD).parse(accessToken);
                Claims claims = (Claims)jwt.getBody();
                String user = (String)claims.get((Object)"user");
                if ("Guest".equals(user) || !validUsers.contains(user)) {
                    value.setSerializationView(Views.GuestView.class);
                } else {
                    value.setSerializationView(Views.UserView.class);
                }
            }
            catch (JwtException e) {
                value.setSerializationView(Views.GuestView.class);
            }
        }
        return value;
    }

    @PostMapping(value={"/JWT/votings/{title}"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public ResponseEntity<?> vote(@PathVariable String title, @CookieValue(value="access_token", required=false) String accessToken) {
        if (StringUtils.isEmpty((CharSequence)accessToken)) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        try {
            Jwt jwt = Jwts.parser().setSigningKey(JWT_PASSWORD).parse(accessToken);
            Claims claims = (Claims)jwt.getBody();
            String user = (String)claims.get((Object)"user");
            if (!validUsers.contains(user)) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
            }
            Optional.ofNullable((Vote)this.votes.get(title)).ifPresent(v -> v.incrementNumberOfVotes(totalVotes));
            return ResponseEntity.accepted().build();
        }
        catch (JwtException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
    }

    @PostMapping(value={"/JWT/votings"})
    @ResponseBody
    public AttackResult resetVotes(@CookieValue(value="access_token", required=false) String accessToken) {
        if (StringUtils.isEmpty((CharSequence)accessToken)) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("jwt-invalid-token").build();
        }
        try {
            Jwt jwt = Jwts.parser().setSigningKey(JWT_PASSWORD).parse(accessToken);
            Claims claims = (Claims)jwt.getBody();
            boolean isAdmin = Boolean.valueOf(String.valueOf(claims.get((Object)"admin")));
            if (!isAdmin) {
                return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("jwt-only-admin").build();
            }
            this.votes.values().forEach(vote -> vote.reset());
            return AttackResultBuilder.success((AssignmentEndpoint)this).build();
        }
        catch (JwtException e) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("jwt-invalid-token").output(e.toString()).build();
        }
    }
}

