/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.impl.TextCodec;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"jwt-secret-hint1", "jwt-secret-hint2", "jwt-secret-hint3"})
public class JWTSecretKeyEndpoint
implements AssignmentEndpoint {
    public static final String[] SECRETS = new String[]{"victory", "business", "available", "shipping", "washington"};
    public static final String JWT_SECRET = TextCodec.BASE64.encode(SECRETS[new Random().nextInt(SECRETS.length)]);
    private static final String WEBGOAT_USER = "WebGoat";
    private static final List<String> expectedClaims = List.of("iss", "iat", "exp", "aud", "sub", "username", "Email", "Role");

    @RequestMapping(path={"/JWT/secret/gettoken"}, produces={"text/html"})
    @ResponseBody
    public String getSecretToken() {
        return Jwts.builder().setIssuer("WebGoat Token Builder").setAudience("webgoat.org").setIssuedAt(Calendar.getInstance().getTime()).setExpiration(Date.from(Instant.now().plusSeconds(60L))).setSubject("tom@webgoat.org").claim("username", (Object)"Tom").claim("Email", (Object)"tom@webgoat.org").claim("Role", (Object)new String[]{"Manager", "Project Administrator"}).signWith(SignatureAlgorithm.HS256, JWT_SECRET).compact();
    }

    @PostMapping(value={"/JWT/secret"})
    @ResponseBody
    public AttackResult login(@RequestParam String token) {
        try {
            Jws jwt = Jwts.parser().setSigningKey(JWT_SECRET).parseClaimsJws(token);
            Claims claims = (Claims)jwt.getBody();
            if (!claims.keySet().containsAll(expectedClaims)) {
                return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("jwt-secret-claims-missing").build();
            }
            String user = (String)claims.get((Object)"username");
            if (WEBGOAT_USER.equalsIgnoreCase(user)) {
                return AttackResultBuilder.success((AssignmentEndpoint)this).build();
            }
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("jwt-secret-incorrect-user").feedbackArgs(new Object[]{user}).build();
        }
        catch (Exception e) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("jwt-invalid-token").output(e.getMessage()).build();
        }
    }
}

